/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.io.IOException;
import net.sf.jasperreports.components.sort.SortComponent;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class SortComponentXmlWriter
implements ComponentXmlWriter {
    private JasperReportsContext jasperReportsContext;

    public SortComponentXmlWriter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public SortComponentXmlWriter(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    @Override
    public void writeToXml(ComponentKey componentKey, Component component, JRXmlWriter reportWriter) throws IOException {
        if (component instanceof SortComponent) {
            SortComponent sortComponent = (SortComponent)component;
            this.writeSortComponent(sortComponent, componentKey, reportWriter);
        }
    }

    protected void writeSortComponent(SortComponent sortComponent, ComponentKey componentKey, JRXmlWriter reportWriter) throws IOException {
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        String namespaceURI = componentKey.getNamespace();
        String schemaLocation = ComponentsEnvironment.getInstance(this.jasperReportsContext).getBundle(namespaceURI).getXmlParser().getPublicSchemaLocation();
        XmlNamespace componentNamespace = new XmlNamespace(namespaceURI, componentKey.getNamespacePrefix(), schemaLocation);
        writer.startElement("sort", componentNamespace);
        if (sortComponent.getEvaluationTime() != EvaluationTimeEnum.NOW) {
            writer.addAttribute("evaluationTime", sortComponent.getEvaluationTime());
        }
        writer.addAttribute("evaluationGroup", sortComponent.getEvaluationGroup());
        writer.startElement("symbol");
        if (sortComponent.getHandlerColor() != null) {
            writer.addAttribute("handlerColor", sortComponent.getHandlerColor());
        }
        writer.addAttribute("sortFieldType", sortComponent.getSortFieldType());
        writer.addAttribute("sortFieldName", sortComponent.getSortFieldName());
        writer.addAttribute("handlerHorizontalAlign", sortComponent.getHandlerHorizontalAlign());
        writer.addAttribute("handlerVerticalAlign", sortComponent.getHandlerVerticalAlign());
        reportWriter.writeFont(sortComponent.getSymbolFont());
        writer.closeElement();
        writer.closeElement();
    }
}

