
CREATE TABLE report_col_string(
    column_name      varchar(100)  NOT NULL,
    column_value     int,
    column_string    varchar(100)
);

DELETE FROM report_col_string;

INSERT INTO report_col_string VALUES('sale_groups.stype',    0 , 'VAR');
INSERT INTO report_col_string VALUES('sale_groups.stype',    1 , 'Referral');
INSERT INTO report_col_string VALUES('quota_unit',           1 , 'MB');
INSERT INTO report_col_string VALUES('quota_unit',           2 , 'GB');
INSERT INTO report_col_string VALUES('customer_quota.flag2', 0 , 'Protected Size');
INSERT INTO report_col_string VALUES('customer_quota.flag2', 2 , 'Stored Size');
INSERT INTO report_col_string VALUES('dsbox.status',         0 , 'Unregistred');
INSERT INTO report_col_string VALUES('dsbox.status',         1 , 'Active');
INSERT INTO report_col_string VALUES('dsbox.status',         2 , 'Suspend');
INSERT INTO report_col_string VALUES('dsbox.status',         3 , 'Deactivate');
INSERT INTO report_col_string VALUES('dsbox.status',         4 , 'Deregistrated');
INSERT INTO report_col_string VALUES('dsbox_quota.flag40',   0 , 'Protected Size');
INSERT INTO report_col_string VALUES('dsbox_quota.flag40',   64, 'Stored Size');

INSERT INTO report_col_string VALUES('head_inv.sc_cal_method', 0 , 'Based on Stored Size');
INSERT INTO report_col_string VALUES('head_inv.sc_cal_method', 1 , 'Based on Protected Size');
INSERT INTO report_col_string VALUES('head_inv.sc_cal_method', 2 , 'Flat Fee');

INSERT INTO report_col_string VALUES('head_inv.blm_sc_cal_method', 0 , 'Based on Stored Size');
INSERT INTO report_col_string VALUES('head_inv.blm_sc_cal_method', 1 , 'Based on Protected Size');
INSERT INTO report_col_string VALUES('head_inv.blm_sc_cal_method', 2 , 'Flat Fee');

INSERT INTO report_col_string VALUES('head_inv.sc_inv_method', 0 , 'End-of-Month Size');
INSERT INTO report_col_string VALUES('head_inv.sc_inv_method', 1 , 'Average-of-Month Size');
INSERT INTO report_col_string VALUES('head_inv.sc_inv_method', 2 , 'Peak-of-Month Size');

INSERT INTO report_col_string VALUES('head_inv.blm_sc_inv_method', 0 , 'End-of-Month Size');
INSERT INTO report_col_string VALUES('head_inv.blm_sc_inv_method', 1 , 'Average-of-Month Size');
INSERT INTO report_col_string VALUES('head_inv.blm_sc_inv_method', 2 , 'Peak-of-Month Size');

INSERT INTO report_col_string VALUES('event_log.type', 0 , 'Information');
INSERT INTO report_col_string VALUES('event_log.type', 1 , 'Warning');
INSERT INTO report_col_string VALUES('event_log.type', 2 , 'Error');

INSERT INTO report_col_string VALUES('backup_sets.set_type', 0, 'File System');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 1, 'SQL Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 2, 'NT Services');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 3, 'Exchange Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 4, 'Oracle Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 5, 'Permissions');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 6, 'Exchange Server Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 7, 'Microsoft Outlook Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 8, 'MS Office');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 9, 'AS400 Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',10, 'MySQL');
INSERT INTO report_col_string VALUES('backup_sets.set_type',11, 'PostgreSQL');
INSERT INTO report_col_string VALUES('backup_sets.set_type',12, 'Oracle Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',15, 'DB2 Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',16, 'Lotus Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type',17, 'Groupwise Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type',18, 'SharePoint Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',20, 'VM Ware');

INSERT INTO report_col_string VALUES('connection_log.session_type', 0 , 'Connection');
INSERT INTO report_col_string VALUES('connection_log.session_type', 1 , 'Backup');
INSERT INTO report_col_string VALUES('connection_log.session_type', 2 , 'Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type', 3 , 'Daily Admin');
INSERT INTO report_col_string VALUES('connection_log.session_type', 4 , 'Delete');
INSERT INTO report_col_string VALUES('connection_log.session_type', 5 , 'Weekly Admin');
INSERT INTO report_col_string VALUES('connection_log.session_type', 6 , 'Recovery');
INSERT INTO report_col_string VALUES('connection_log.session_type', 7 , 'Registration');
INSERT INTO report_col_string VALUES('connection_log.session_type', 8 , 'System Admin');
INSERT INTO report_col_string VALUES('connection_log.session_type', 9 , 'System Backup');
INSERT INTO report_col_string VALUES('connection_log.session_type',10 , 'Synchronization');
INSERT INTO report_col_string VALUES('connection_log.session_type',11 , 'Initial Backup');
INSERT INTO report_col_string VALUES('connection_log.session_type',12 , 'Disc/Tape');
INSERT INTO report_col_string VALUES('connection_log.session_type',13 , 'LAN Analyze Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',14 , 'Portable');
INSERT INTO report_col_string VALUES('connection_log.session_type',15 , 'Remove Orphaned Libraries');
INSERT INTO report_col_string VALUES('connection_log.session_type',16 , 'Empty Trash');
INSERT INTO report_col_string VALUES('connection_log.session_type',17 , 'OnLine File Summary');
INSERT INTO report_col_string VALUES('connection_log.session_type',18 , 'Synchronized Delete');
INSERT INTO report_col_string VALUES('connection_log.session_type',19 , 'Clean Libraries');
INSERT INTO report_col_string VALUES('connection_log.session_type',20 , 'SLA Monitor Check');
INSERT INTO report_col_string VALUES('connection_log.session_type',21 , 'SLA Monitor Register');
INSERT INTO report_col_string VALUES('connection_log.session_type',22 , 'SLA Monitor Unregister');
INSERT INTO report_col_string VALUES('connection_log.session_type',23 , 'Test Connection');
INSERT INTO report_col_string VALUES('connection_log.session_type',24 , 'Migration');
INSERT INTO report_col_string VALUES('connection_log.session_type',27 , 'LTS Process');
INSERT INTO report_col_string VALUES('connection_log.session_type',28 , 'LTS Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',29 , 'LTS Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type',30 , 'System Autonomic Healing');
INSERT INTO report_col_string VALUES('connection_log.session_type',32 , 'Disaster Recovery');
INSERT INTO report_col_string VALUES('connection_log.session_type',33 , 'Storage Scan');
INSERT INTO report_col_string VALUES('connection_log.session_type',34 , 'Validation');
INSERT INTO report_col_string VALUES('connection_log.session_type',35 , 'BLM Archiving');
INSERT INTO report_col_string VALUES('connection_log.session_type',36 , 'Auto Upgrade');
INSERT INTO report_col_string VALUES('connection_log.session_type',37 , 'Storage Statistics');
INSERT INTO report_col_string VALUES('connection_log.session_type',38 , 'BLM Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type',39 , 'BLM Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',40 , 'Retention');
INSERT INTO report_col_string VALUES('connection_log.session_type',41 , 'Disc/Tape Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',42 , 'Disc/Tape Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type',43 , 'Scheduled Report');
INSERT INTO report_col_string VALUES('connection_log.session_type',44 , 'File Optimization');
INSERT INTO report_col_string VALUES('connection_log.session_type',45 , 'Clean Logs');
INSERT INTO report_col_string VALUES('connection_log.session_type',46 , 'Tape Convert');
INSERT INTO report_col_string VALUES('connection_log.session_type',47 , 'Replication Send');
INSERT INTO report_col_string VALUES('connection_log.session_type',48 , 'Replication Receive');
INSERT INTO report_col_string VALUES('connection_log.session_type',49 , 'Replication Delete');

INSERT INTO report_col_string VALUES('event_log.category', 0 , 'Unknown');
INSERT INTO report_col_string VALUES('event_log.category', 1 , 'Application');
INSERT INTO report_col_string VALUES('event_log.category', 2 , 'Socket');
INSERT INTO report_col_string VALUES('event_log.category', 3 , 'Message');
INSERT INTO report_col_string VALUES('event_log.category', 4 , 'Database');
INSERT INTO report_col_string VALUES('event_log.category', 5 , 'Exception');
INSERT INTO report_col_string VALUES('event_log.category', 6 , 'I/O');
INSERT INTO report_col_string VALUES('event_log.category', 7,  'System');
INSERT INTO report_col_string VALUES('event_log.category', 8,  'Security');
INSERT INTO report_col_string VALUES('event_log.category', 9,  'MAPI');
INSERT INTO report_col_string VALUES('event_log.category',10,  'Netware');
INSERT INTO report_col_string VALUES('event_log.category',11,  'ORA');

INSERT INTO report_col_string VALUES('event_log.category',12,  'RMAN');
INSERT INTO report_col_string VALUES('event_log.category',14,  'XML Parsing');
INSERT INTO report_col_string VALUES('event_log.category',15,  'DB2');
INSERT INTO report_col_string VALUES('event_log.category',16,  'ORACLE');

INSERT INTO report_col_string VALUES('connection_log.client_stop', 0 , '');
INSERT INTO report_col_string VALUES('connection_log.client_stop', -1 , 'Unknown');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 1 , 'User Stop');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 2 , 'Time limit');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 3 , 'Error limit');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 4 , 'Storage limit');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 5 , 'Shutdown');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 6 , 'Disconnect');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 7 , 'No resource');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 8 , 'Exception');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 9 , 'No connect');
INSERT INTO report_col_string VALUES('connection_log.client_stop',10 , 'Pre/Post failure');
INSERT INTO report_col_string VALUES('connection_log.client_stop',11 , 'Synchronization');
INSERT INTO report_col_string VALUES('connection_log.client_stop',12 , 'No share');
INSERT INTO report_col_string VALUES('connection_log.client_stop',15 , 'Could not allocate space for database');
INSERT INTO report_col_string VALUES('connection_log.client_stop',18 , 'Locked');
INSERT INTO report_col_string VALUES('connection_log.client_stop',19 , 'Upgrade stop');
INSERT INTO report_col_string VALUES('connection_log.client_stop',20 , 'Quota reached');
INSERT INTO report_col_string VALUES('connection_log.client_stop',21 , 'Quota reached');
INSERT INTO report_col_string VALUES('connection_log.client_stop',22 , 'Failed');
INSERT INTO report_col_string VALUES('connection_log.client_stop',23 , 'Unexpected stop');
INSERT INTO report_col_string VALUES('connection_log.client_stop',24 , 'Not allowed');
INSERT INTO report_col_string VALUES('connection_log.client_stop',25 , 'No enough disk space');
INSERT INTO report_col_string VALUES('connection_log.client_stop',26 , 'No local storage path');
INSERT INTO report_col_string VALUES('connection_log.client_stop',27 , 'Fatal Error');
INSERT INTO report_col_string VALUES('connection_log.client_stop',30 , 'DS-System Requested Stop');

CREATE TABLE report_views(
    view_id      int PRIMARY KEY,
    view_name    varchar(100) NOT NULL UNIQUE,
    view_from    text
);

CREATE TABLE report_views_tables(
    view_id           int,
    table_alias       varchar(100) NOT NULL,
    table_realname    varchar(100) NOT NULL
);

CREATE TABLE report_views_columns(
    column_name      varchar(100)  NOT NULL,
    column_table     varchar(100) NOT NULL,
    column_define    text NOT NULL,
    column_type      varchar(100) NOT NULL,
    column_sortable  int  NOT NULL,
    column_filter    int  NOT NULL,
    column_desc      varchar(100) NOT NULL,
    column_id        SERIAL PRIMARY KEY
);

DELETE FROM report_views_columns;
DELETE FROM report_views_tables;
DELETE FROM report_views;

INSERT INTO report_views_columns VALUES('provider_name',        'var_data',   'var_data.company_name',   'string', 0, 0, 'Service Provider''s Company Name');
INSERT INTO report_views_columns VALUES('provider_addr1',       'var_data',   'var_data.addr1',          'string', 0, 0, 'Service Provider''s Address Line 1');
INSERT INTO report_views_columns VALUES('provider_addr2',       'var_data',   'var_data.addr2',          'string', 0, 0, 'Service Provider''s Address Line 2');
INSERT INTO report_views_columns VALUES('provider_city',        'var_data',   'var_data.city',           'string', 0, 0, 'Service Provider''s City');
INSERT INTO report_views_columns VALUES('provider_contact',     'var_data',   'var_data.contact',        'string', 0, 0, 'Service Provider''s Contact');
INSERT INTO report_views_columns VALUES('provider_country_code','var_data',   'var_data.country',        'string', 0, 0, 'Service Provider''s Country Code');
INSERT INTO report_views_columns VALUES('provider_country_name','var_data',   '(select country_name from countries where countries.country_code=var_data.country)',  'string', 0, 0, 'Service Provider''s Country Name');
INSERT INTO report_views_columns VALUES('provider_email',       'var_data',   'var_data.email_addr',     'string', 0, 0, 'Service Provider''s EMail Address');
INSERT INTO report_views_columns VALUES('provider_fax',         'var_data',   'var_data.fax',            'string', 0, 0, 'Service Provider''s Fax');
INSERT INTO report_views_columns VALUES('provider_phone',       'var_data',   'var_data.phone',          'string', 0, 0, 'Service Provider''s Phone');
INSERT INTO report_views_columns VALUES('provider_zipcode',     'var_data',   'var_data.postal_zip',     'string', 0, 0, 'Service Provider''s Zipcode');
INSERT INTO report_views_columns VALUES('provider_prov_code',   'var_data',   'var_data.prov_state',     'string', 0, 0, 'Service Provider''s Province/State Code');
INSERT INTO report_views_columns VALUES('provider_prov_name',   'var_data',   '(select province_name from provinces where provinces.province_code=var_data.prov_state and provinces.country_code=var_data.country)', 'string', 0, 0, 'Service Provider''s Province/State Name');
INSERT INTO report_views_columns VALUES('provider_computername','var_data',   ':ComputerName',           'string', 0, 0, 'DS-System Computer Name');
INSERT INTO report_views_columns VALUES('provider_brandingfile','var_data',   ':BrandingFile',           'string', 0, 0, 'Service Provider''s Branding File');

INSERT INTO report_views_columns VALUES('varref_id',            'sale_groups','sale_groups.group_id',    'int',    0, 2001, 'VAR/Referral''s ID');
INSERT INTO report_views_columns VALUES('varref_company_name',  'sale_groups','sale_groups.company_name','string', 1, 0, 'VAR/Referral''s Company Name');
INSERT INTO report_views_columns VALUES('varref_addr1',         'sale_groups','sale_groups.addr1',       'string', 0, 0, 'VAR/Referral''s Address Line 1');
INSERT INTO report_views_columns VALUES('varref_addr2',         'sale_groups','sale_groups.addr2',       'string', 0, 0, 'VAR/Referral''s Address Line 2');
INSERT INTO report_views_columns VALUES('varref_city',          'sale_groups','sale_groups.city',        'string', 0, 0, 'VAR/Referral''s City');
INSERT INTO report_views_columns VALUES('varref_contact',       'sale_groups','sale_groups.contact',     'string', 0, 0, 'VAR/Referral''s Contact');
INSERT INTO report_views_columns VALUES('varref_email',         'sale_groups','sale_groups.email_addr',  'string', 0, 0, 'VAR/Referral''s EMail Address');
INSERT INTO report_views_columns VALUES('varref_fax',           'sale_groups','sale_groups.fax',         'string', 0, 0, 'VAR/Referral''s Fax');
INSERT INTO report_views_columns VALUES('varref_phone',         'sale_groups','sale_groups.phone',       'string', 0, 0, 'VAR/Referral''s Phone');
INSERT INTO report_views_columns VALUES('varref_zipcode',       'sale_groups','sale_groups.postal_zip',  'string', 0, 0, 'VAR/Referral''s Zipcode');
INSERT INTO report_views_columns VALUES('varref_country_code',  'sale_groups','sale_groups.country',     'string', 0, 0, 'VAR/Referral''s Country Code');
INSERT INTO report_views_columns VALUES('varref_country_name',  'sale_groups','(select country_name from countries where countries.country_code=sale_groups.country)',  'string', 0, 0, 'VAR/Referral''s Country Name');
INSERT INTO report_views_columns VALUES('varref_prov_code',     'sale_groups','sale_groups.prov_state',  'string', 0, 0, 'VAR/Referral''s Province/State Code');
INSERT INTO report_views_columns VALUES('varref_prov_name',     'sale_groups','(select province_name from provinces where provinces.province_code=sale_groups.prov_state and provinces.country_code=sale_groups.country)', 'string', 0, 0, 'VAR/Referral''s Province/State Name');
INSERT INTO report_views_columns VALUES('varref_has_commission','sale_groups','( sale_groups.flag & 1 )','int',    0, 0, 'VAR/Referral has commission or not');
INSERT INTO report_views_columns VALUES('varref_type',          'sale_groups','sale_groups.stype',       'int',    0, 2002, 'VAR/Referral''s Type: VAR(0) or Referral(1)');
INSERT INTO report_views_columns VALUES('varref_type_name',     'sale_groups','(select column_string from report_col_string where column_name=''sale_groups.stype'' and column_value=sale_groups.stype)',  'string', 1, 0, 'VAR/Referral''s Type: ''VAR'' or ''Referral'' ');

INSERT INTO report_views_columns VALUES('varref_commission_rate','group_commission','group_commission.commission', 'double', 0, 0, 'VAR/Referral''s Commission Rate');

INSERT INTO report_views_columns VALUES('salesrep_id'   ,        'sale_reps',     'sale_reps.rep_id',     'int',    0, 2003, 'Sales Representative''s ID');
INSERT INTO report_views_columns VALUES('salesrep_name',         'sale_reps',     'sale_reps.name',       'string', 1, 0, 'Sales Representative''s Name');
INSERT INTO report_views_columns VALUES('salesrep_is_house_acc', 'sale_reps',     'sale_reps.sales_flag', 'int',    0, 0, 'Sales Representative Is House Account or not');

INSERT INTO report_views_columns VALUES('customer_account_id',   'customer',  'customer.account_id',         'int',    0, 0, 'Customer''s Account ID');
INSERT INTO report_views_columns VALUES('customer_account_num',  'customer',  'customer.account_num',        'string', 1, 2004, 'Customer''s Account Number');
INSERT INTO report_views_columns VALUES('customer_account_name', 'customer',  'customer.company_name',       'string', 1, 0, 'Customer''s Company Name');
INSERT INTO report_views_columns VALUES('customer_contact',      'customer',  'customer.contact',            'string', 0, 0, 'Customer''s Contact');
INSERT INTO report_views_columns VALUES('customer_consolidation','customer',  '(case when (customer.billing_location_id>0) then 1 else 0 end)',  'int', 0, 0, 'Customer allow consolidation invoice');
INSERT INTO report_views_columns VALUES('customer_loc_id',       'customer',  'customer.location_id',        'int',    0, 0, 'Customer''s location id');
INSERT INTO report_views_columns VALUES('customer_bill_loc_id',  'customer',  'customer.billing_location_id','int',    0, 0, 'Customer''s billing location id');

INSERT INTO report_views_columns VALUES('customer_loc_name',    'cust_loc',  'cust_loc.name',        'string', 0, 0, 'Customer''s location name');
INSERT INTO report_views_columns VALUES('customer_addr1',       'cust_loc',  'cust_loc.addr1',       'string', 0, 0, 'Customer''s addr line 1');
INSERT INTO report_views_columns VALUES('customer_addr2',       'cust_loc',  'cust_loc.addr2',       'string', 0, 0, 'Customer''s addr line 2');
INSERT INTO report_views_columns VALUES('customer_city',        'cust_loc',  'cust_loc.city',        'string', 0, 0, 'Customer''s city');
INSERT INTO report_views_columns VALUES('customer_phone',       'cust_loc',  'cust_loc.phone',       'string', 0, 0, 'Customer''s phone');
INSERT INTO report_views_columns VALUES('customer_fax',         'cust_loc',  'cust_loc.fax',         'string', 0, 0, 'Customer''s fax');
INSERT INTO report_views_columns VALUES('customer_email',       'cust_loc',  'cust_loc.email_addr',  'string', 0, 0, 'Customer''s E-Mail');
INSERT INTO report_views_columns VALUES('customer_prov_code',   'cust_loc',  'cust_loc.prov_state',  'string', 0, 0, 'Customer''s Province/State code');
INSERT INTO report_views_columns VALUES('customer_prov_name',   'cust_loc',  '(select province_name from provinces where provinces.province_code=cust_loc.prov_state and provinces.country_code=cust_loc.country)', 'string', 0, 0, 'Customer''s Province/State Name');
INSERT INTO report_views_columns VALUES('customer_zipcode',     'cust_loc',  'cust_loc.postal_zip',  'string', 0, 0, 'Customer''s postal code');
INSERT INTO report_views_columns VALUES('customer_country_code','cust_loc',  'cust_loc.country',     'string', 0, 0, 'Customer''s country code');
INSERT INTO report_views_columns VALUES('customer_country_name','cust_loc',  '(select country_name from countries where countries.country_code=cust_loc.country)',  'string', 0, 0, 'Customer''s Country Name');

INSERT INTO report_views_columns VALUES('customer_bill_loc_name',   'cust_billloc',  'cust_billloc.name',      'string', 0, 0, 'Customer''s billing location name');
INSERT INTO report_views_columns VALUES('customer_bill_addr1',      'cust_billloc',  'cust_billloc.addr1',     'string', 0, 0, 'Customer''s billing addr line 1');
INSERT INTO report_views_columns VALUES('customer_bill_addr2',      'cust_billloc',  'cust_billloc.addr2',     'string', 0, 0, 'Customer''s billing addr line 2');
INSERT INTO report_views_columns VALUES('customer_bill_city',       'cust_billloc',  'cust_billloc.city',      'string', 0, 0, 'Customer''s billing city');
INSERT INTO report_views_columns VALUES('customer_bill_phone',      'cust_billloc',  'cust_billloc.phone',     'string', 0, 0, 'Customer''s billing phone');
INSERT INTO report_views_columns VALUES('customer_bill_fax',        'cust_billloc',  'cust_billloc.fax',       'string', 0, 0, 'Customer''s billing fax');
INSERT INTO report_views_columns VALUES('customer_bill_email',      'cust_billloc',  'cust_billloc.email_addr','string', 0, 0, 'Customer''s billing E-Mail');
INSERT INTO report_views_columns VALUES('customer_bill_zipcode',    'cust_billloc',  'cust_billloc.postal_zip','string', 0, 0, 'Customer''s billing postal code');
INSERT INTO report_views_columns VALUES('customer_bill_prov_code',  'cust_billloc',  'cust_billloc.prov_state','string', 0, 0, 'Customer''s billing Province/State code');
INSERT INTO report_views_columns VALUES('customer_bill_prov_name',  'cust_billloc',  '(select province_name from provinces where provinces.province_code=cust_billloc.prov_state and provinces.country_code=cust_billloc.country)', 'string', 0, 0, 'Customer''s billing Province/State Name');
INSERT INTO report_views_columns VALUES('customer_bill_country_code','cust_billloc',  'cust_billloc.country',   'string', 0, 0, 'Customer''s billing country code');
INSERT INTO report_views_columns VALUES('customer_bill_country_name','cust_billloc',  '(select country_name from countries where countries.country_code=cust_billloc.country)',  'string', 0, 0, 'Customer''s billing Country Name');

INSERT INTO report_views_columns VALUES('customer_bill_plan',          'cust_billinfo',  'cust_billinfo.billing_plan',  'string', 0, 0, 'Customer''s billing plan id');
INSERT INTO report_views_columns VALUES('customer_bill_planname',      'cust_billinfo',  '(select plan_name from bill_plan where bill_plan.plan_num=cust_billinfo.billing_plan)',  'string', 0, 0, 'Customer''s billing plan name');
INSERT INTO report_views_columns VALUES('customer_bill_bankname',      'cust_billinfo',  'cust_billinfo.bank_name',     'string', 0, 0, 'Customer''s bank name');
INSERT INTO report_views_columns VALUES('customer_bill_bankaddr',      'cust_billinfo',  'cust_billinfo.bank_addr',     'string', 0, 0, 'Customer''s bank address');
INSERT INTO report_views_columns VALUES('customer_bill_bankaccount',   'cust_billinfo',  'cust_billinfo.bank_account',  'string', 0, 0, 'Customer''s bank account');
INSERT INTO report_views_columns VALUES('customer_bill_contact',       'cust_billinfo',  'cust_billinfo.contact',       'string', 0, 0, 'Customer''s billing contact');
INSERT INTO report_views_columns VALUES('customer_bill_tax1',          'cust_billinfo',  'cust_billinfo.tax1',          'int',    0, 0, 'Tax1 should be added to Customer or not');
INSERT INTO report_views_columns VALUES('customer_bill_tax2',          'cust_billinfo',  'cust_billinfo.tax2',          'int',    0, 0, 'Tax2 should be added to Customer or not');
INSERT INTO report_views_columns VALUES('customer_bill_tax1exemption', 'cust_billinfo',  'cust_billinfo.tax1_exemp',    'string', 0, 0, 'Tax1 expemption number is customer tax1 is exempted');
INSERT INTO report_views_columns VALUES('customer_bill_tax2exemption', 'cust_billinfo',  'cust_billinfo.tax2_exemp',    'string', 0, 0, 'Tax2 expemption number is customer tax2 is exempted');
INSERT INTO report_views_columns VALUES('customer_bill_ponum',         'cust_billinfo',  'cust_billinfo.po_num',        'string', 0, 0, 'Customer''s purchase order number');

INSERT INTO report_views_columns VALUES('customer_storage_quota',      'customer_quota',  '(case when ((customer_quota.flag & 1)!=0) then customer_quota.quota else 0 end)',  'int', 0, 0, 'Customer''s storage quota');
INSERT INTO report_views_columns VALUES('customer_quota_unit',         'customer_quota',  '(select column_string from report_col_string where column_name=''quota_unit'' and column_value=customer_quota.quota_unit)',  'string', 0, 0, 'Customer''s storage quota unit');
INSERT INTO report_views_columns VALUES('customer_quota_basedon',      'customer_quota',  '(select column_string from report_col_string where column_name=''customer_quota.flag2'' and column_value=(customer_quota.flag & 2))',  'string', 0, 0, 'Customer''s storage quota calculation method');

INSERT INTO report_views_columns VALUES('box_id',                'dsbox',  'dsbox.box_id',              'int',      0, 0, 'DS-Client ID');
INSERT INTO report_views_columns VALUES('box_number',            'dsbox',  'dsbox.dsbox_snum',          'string',   1, 2005, 'DS-Client Number');
INSERT INTO report_views_columns VALUES('box_description',       'dsbox',  'dsbox.description',         'string',   0, 0, 'DS-Client description');
INSERT INTO report_views_columns VALUES('box_contact',           'dsbox',  'dsbox.contact',             'string',   0, 0, 'DS-Client contact');
INSERT INTO report_views_columns VALUES('box_service_start_date','dsbox',  'dsbox.service_start_date',  'date',     0, 0, 'DS-Client service start date');
INSERT INTO report_views_columns VALUES('box_service_end_date',  'dsbox',  'dsbox.service_end_date',    'date',     0, 0, 'DS-Client service end date');
INSERT INTO report_views_columns VALUES('box_creation_date',     'dsbox',  'dsbox.creation_date',       'date',     1, 1, 'DS-Client creation date');
INSERT INTO report_views_columns VALUES('box_activation_date',   'dsbox',  'dsbox.activation_date',     'datetime', 0, 0, 'DS-Client activation date');
INSERT INTO report_views_columns VALUES('box_storage_group_id',  'dsbox',  'dsbox.ext_group_id',        'int',      0, 0, 'DS-Client storage group id.');
INSERT INTO report_views_columns VALUES('box_storage_group_name','dsbox',  '(select ext_group_name from storage_groups where storage_groups.ext_group_id = dsbox.ext_group_id)',  'string', 0, 0, 'DS-Client storage group name.');
INSERT INTO report_views_columns VALUES('box_loc_id',            'dsbox',  'dsbox.location_id',         'int',      0, 0, 'DS-Client location id');
INSERT INTO report_views_columns VALUES('box_bill_loc_id',       'dsbox',  'dsbox.billing_location_id', 'int',      0, 0, 'DS-client billing location id');
INSERT INTO report_views_columns VALUES('box_show_stored_size',  'dsbox',  '(case when ((dsbox.flags & 1048576)!=0) then 1 else 0 end)',  'int', 0, 0, 'Allow DS-Client show stored size on backup set report');
INSERT INTO report_views_columns VALUES('box_consolidation',     'dsbox',  'dsbox.consolidation',       'int',      0, 0, 'DS-Client uses consolidation invoice or not');
INSERT INTO report_views_columns VALUES('box_is_evaluation',     'dsbox',  'dsbox.type',                'int',      0, 2006, 'DS-Client is evaluation client or not');
INSERT INTO report_views_columns VALUES('box_bill_scale_id',     'dsbox',  'dsbox.billing_scale',       'int',      0, 2007, 'DS-Client billing scale id');
INSERT INTO report_views_columns VALUES('box_bill_scale_name',   'dsbox',  '(select name from billing_scale where billing_scale.scale_id=dsbox.billing_scale)',  'string', 0, 0, 'DS-Client billing scale name');
INSERT INTO report_views_columns VALUES('box_bscale_expire_date','dsbox',  'dsbox.billing_scale_due',   'date',     0, 0, 'DS-Client billing scale expire date');
INSERT INTO report_views_columns VALUES('box_bscale_replace',    'dsbox',  'dsbox.second_billing_scale','int',      0, 0, 'DS-Client replaced billing scale id');
INSERT INTO report_views_columns VALUES('box_bscale_name_replace',  'dsbox',  '(select name from billing_scale where billing_scale.scale_id=dsbox.second_billing_scale)',  'string', 0, 0, 'DS-Client replaced billing scale name');
INSERT INTO report_views_columns VALUES('box_sla_credit_scale',     'dsbox',  'dsbox.credit_scale',        'int',      0, 2008, 'DS-Client credit scale id');
INSERT INTO report_views_columns VALUES('box_sla_credit_scale_name','dsbox',  '(select scale_name from sla_credit_scale where sla_credit_scale.slascale_id=dsbox.credit_scale)',  'string', 0, 0, 'DS-Client credit scale name');
INSERT INTO report_views_columns VALUES('box_blm_scale_id',      'dsbox',  'dsbox.blm_scale_id',        'int',      0, 2009, 'DS-Client blm billing scale id');
INSERT INTO report_views_columns VALUES('box_blm_scale_name',    'dsbox',  '(select blm_scale_name from blm_billing_scale where blm_billing_scale.blm_scale_id=dsbox.blm_scale_id)',  'string', 0, 0, 'DS-Client BLM billing scale name');
INSERT INTO report_views_columns VALUES('box_status',            'dsbox',  'dsbox.status',              'int',      0, 2010, 'DS-Client status');
INSERT INTO report_views_columns VALUES('box_status_name',       'dsbox',  '(select column_string from report_col_string where column_name=''dsbox.status'' and column_value = dsbox.status)',  'string', 1, 0, 'DS-Client status name');
INSERT INTO report_views_columns VALUES('box_bandwidth_to_sys',  'dsbox',  '(select limit_tosystem from bandwidth where box_id = dsbox.box_id)',  'int', 0, 0, 'DS-Client bandwitdh limitation (to system)');
INSERT INTO report_views_columns VALUES('box_bandwidth_to_clnt', 'dsbox',  '(select limit_toclient from bandwidth where box_id = dsbox.box_id)',  'int', 0, 0, 'DS-Client bandwidth limitation (to client)');
INSERT INTO report_views_columns VALUES('box_req_registration',  'dsbox',  '(case when ((dsbox.flags & 2)!=0) then 1 else 0 end)',  'int', 0, 0, 'DS-Client require registration');

INSERT INTO report_views_columns VALUES('box_storage_quota', 'dsbox_quota',  '(case when ((dsbox_quota.flag & 256 )!=0) then dsbox_quota.quota else 0 end)',  'int', 0, 0, 'DS-Client storage quota');
INSERT INTO report_views_columns VALUES('box_quota_unit',    'dsbox_quota',  '(select column_string from report_col_string where column_name=''quota_unit'' and column_value=dsbox_quota.quota_unit)',  'string', 0, 0, 'DS-Client storage quota unit');
INSERT INTO report_views_columns VALUES('box_quota_basedon', 'dsbox_quota',  '(select column_string from report_col_string where column_name=''dsbox_quota.flag40'' and column_value=(dsbox_quota.flag & 64 ))',  'string', 0, 0, 'DS-Client storage quota calculation method');

INSERT INTO report_views_columns VALUES('box_protected_size',      'dsbox_size',  'dsbox_size.prot_size',    'double', 1, 0, 'DS-Client protected size');
INSERT INTO report_views_columns VALUES('box_stored_size',         'dsbox_size',  '(dsbox_size.ds_size+dsbox_size.lib_size)',  'double', 1, 0, 'DS-Client stored size');
INSERT INTO report_views_columns VALUES('box_ds_size',             'dsbox_size',  'dsbox_size.ds_size',      'double', 0, 0, 'DS-Client DS Size');
INSERT INTO report_views_columns VALUES('box_blm_protected_size',  'dsbox_size',  'dsbox_size.blm_prot_size','double', 0, 0, 'DS-Client BLM Protected Size');
INSERT INTO report_views_columns VALUES('box_blm_stored_size',     'dsbox_size',  'dsbox_size.blm_ds_size',  'double', 0, 0, 'DS-Client BLM stored size');
INSERT INTO report_views_columns VALUES('box_protected_size_avg',  'dsbox_size',  'dsbox_size.prot_avg',     'double', 0, 0, 'DS-Client protected size (average)');
INSERT INTO report_views_columns VALUES('box_stored_size_avg',     'dsbox_size',  'dsbox_size.ds_avg',       'double', 0, 0, 'DS-Client stored size (average)');
INSERT INTO report_views_columns VALUES('box_blm_protected_avg',   'dsbox_size',  'dsbox_size.blm_prot_size_avg',  'double', 0, 0, 'DS-Client BLM Protected Size (average)');
INSERT INTO report_views_columns VALUES('box_blm_stored_avg',      'dsbox_size',  'dsbox_size.blm_ds_size_avg',    'double', 0, 0, 'DS-Client BLM stored size (average)');
INSERT INTO report_views_columns VALUES('box_protected_size_peak', 'dsbox_size',  'dsbox_size.prot_max',           'double', 0, 0, 'DS-Client protected size (peak)');
INSERT INTO report_views_columns VALUES('box_stored_size_peak',    'dsbox_size',  'dsbox_size.ds_max',             'double', 0, 0, 'DS-Client stored size (peak)');
INSERT INTO report_views_columns VALUES('box_blm_protected_peak',  'dsbox_size',  'dsbox_size.blm_prot_size_max',  'double', 0, 0, 'DS-Client BLM Protected Size (peak)');
INSERT INTO report_views_columns VALUES('box_blm_stored_peak',     'dsbox_size',  'dsbox_size.blm_ds_size_max',    'double', 0, 0, 'DS-Client BLM stored size (peak)');

INSERT INTO report_views_columns VALUES('box_loc_name',    'box_loc',  'box_loc.name',       'string', 0, 0, 'DS-Client location name');
INSERT INTO report_views_columns VALUES('box_addr1',       'box_loc',  'box_loc.addr1',      'string', 0, 0, 'DS-Client addr line 1');
INSERT INTO report_views_columns VALUES('box_addr2',       'box_loc',  'box_loc.addr2',      'string', 0, 0, 'DS-Client addr line 2');
INSERT INTO report_views_columns VALUES('box_city',        'box_loc',  'box_loc.city',       'string', 0, 0, 'DS-Client city');
INSERT INTO report_views_columns VALUES('box_phone',       'box_loc',  'box_loc.phone',      'string', 0, 0, 'DS-Client phone');
INSERT INTO report_views_columns VALUES('box_fax',         'box_loc',  'box_loc.fax',        'string', 0, 0, 'DS-Client fax');
INSERT INTO report_views_columns VALUES('box_email',       'box_loc',  'box_loc.email_addr', 'string', 0, 0, 'DS-Client E-Mail');
INSERT INTO report_views_columns VALUES('box_prov_code',   'box_loc',  'box_loc.prov_state', 'string', 0, 0, 'DS-Client Province/State code');
INSERT INTO report_views_columns VALUES('box_prov_name',   'box_loc',  '(select province_name from provinces where provinces.province_code=box_loc.prov_state and provinces.country_code=box_loc.country)', 'string', 0, 0, 'DS-Client Province/State Name');
INSERT INTO report_views_columns VALUES('box_zipcode',     'box_loc',  'box_loc.postal_zip', 'string', 0, 0, 'DS-Client postal code');
INSERT INTO report_views_columns VALUES('box_country_code','box_loc',  'box_loc.country',    'string', 0, 0, 'DS-Client country code');
INSERT INTO report_views_columns VALUES('box_country_name','box_loc',  '(select country_name from countries where countries.country_code=box_loc.country)',  'string', 0, 0, 'DS-Client Country Name');

INSERT INTO report_views_columns VALUES('box_bill_locname',     'box_billloc',  'box_billloc.name',       'string', 0, 0, 'DS-Client billing location name');
INSERT INTO report_views_columns VALUES('box_bill_addr1',       'box_billloc',  'box_billloc.addr1',      'string', 0, 0, 'DS-Client billing addr line 1');
INSERT INTO report_views_columns VALUES('box_bill_addr2',       'box_billloc',  'box_billloc.addr2',      'string', 0, 0, 'DS-Client billing addr line 2');
INSERT INTO report_views_columns VALUES('box_bill_city',        'box_billloc',  'box_billloc.city',       'string', 0, 0, 'DS-Client billing city');
INSERT INTO report_views_columns VALUES('box_bill_phone',       'box_billloc',  'box_billloc.phone',      'string', 0, 0, 'DS-Client billing phone');
INSERT INTO report_views_columns VALUES('box_bill_fax',         'box_billloc',  'box_billloc.fax',        'string', 0, 0, 'DS-Client billing fax');
INSERT INTO report_views_columns VALUES('box_bill_email',       'box_billloc',  'box_billloc.email_addr', 'string', 0, 0, 'DS-Client billing E-Mail');
INSERT INTO report_views_columns VALUES('box_bill_zipcode',     'box_billloc',  'box_billloc.postal_zip', 'string', 0, 0, 'DS-Client billing postal code');
INSERT INTO report_views_columns VALUES('box_bill_prov_code',   'box_billloc',  'box_billloc.prov_state', 'string', 0, 0, 'DS-Client billing Province/State code');
INSERT INTO report_views_columns VALUES('box_bill_prov_name',   'box_billloc',  '(select province_name from provinces where provinces.province_code=box_billloc.prov_state and provinces.country_code=box_billloc.country)', 'string', 0, 0, 'DS-Client billing Province/State Name');
INSERT INTO report_views_columns VALUES('box_bill_countrycode', 'box_billloc',  'box_billloc.country',    'string', 0, 0, 'DS-Client billing country code');
INSERT INTO report_views_columns VALUES('box_bill_countryname', 'box_billloc',  '(select country_name from countries where countries.country_code=box_billloc.country)',  'string', 0, 0, 'DS-Client billing Country Name');

INSERT INTO report_views_columns VALUES('box_bill_plan',          'box_billinfo',  'box_billinfo.billing_plan',  'string', 0, 2011, 'DS-Client billing plan id');
INSERT INTO report_views_columns VALUES('box_bill_planname',      'box_billinfo',  '(select plan_name from bill_plan where bill_plan.plan_num=box_billinfo.billing_plan)',  'string', 1, 0, 'DS-Client billing plan name');
INSERT INTO report_views_columns VALUES('box_bill_bankname',      'box_billinfo',  'box_billinfo.bank_name',     'string', 0, 0, 'DS-Client bank name');
INSERT INTO report_views_columns VALUES('box_bill_bankaddr',      'box_billinfo',  'box_billinfo.bank_addr',     'string', 0, 0, 'DS-Client bank address');
INSERT INTO report_views_columns VALUES('box_bill_bankaccount',   'box_billinfo',  'box_billinfo.bank_account',  'string', 0, 0, 'DS-Client bank account');
INSERT INTO report_views_columns VALUES('box_bill_contact',       'box_billinfo',  'box_billinfo.contact',       'string', 0, 0, 'DS-Client billing contact');
INSERT INTO report_views_columns VALUES('box_bill_tax1',          'box_billinfo',  'box_billinfo.tax1',          'int',    0, 0, 'DS-Client Tax1 should be added to Customer or not');
INSERT INTO report_views_columns VALUES('box_bill_tax2',          'box_billinfo',  'box_billinfo.tax2',          'int',    0, 0, 'DS-Client Tax2 should be added to Customer or not');
INSERT INTO report_views_columns VALUES('box_bill_tax1exemption', 'box_billinfo',  'box_billinfo.tax1_exemp',    'string', 0, 0, 'DS-Client Tax1 expemption number is customer tax1 is exempted');
INSERT INTO report_views_columns VALUES('box_bill_tax2exemption', 'box_billinfo',  'box_billinfo.tax2_exemp',    'string', 0, 0, 'DS-Client Tax2 expemption number is customer tax2 is exempted');
INSERT INTO report_views_columns VALUES('box_bill_ponum',         'box_billinfo',  'box_billinfo.po_num',        'string', 0, 0, 'DS-Client purchase order number');

INSERT INTO report_views_columns VALUES('bset_id',            'backup_sets',  'backup_sets.set_id',        'int',     0, 2012, 'Backup set system side set id');
INSERT INTO report_views_columns VALUES('bset_req_id',        'backup_sets',  'backup_sets.req_id',        'int',     0, 0, 'Backup set req id (client side)');
INSERT INTO report_views_columns VALUES('bset_name',          'backup_sets',  'backup_sets.set_name',      'string',  1, 0, 'Backup set name (include computer name and user name)');
INSERT INTO report_views_columns VALUES('bset_last_backup_time','backup_sets',  'backup_sets.lastbkup_time', 'datetime',1, 0, 'Backup set last backup time');
INSERT INTO report_views_columns VALUES('bset_set_type',      'backup_sets',  'backup_sets.set_type',      'int',     0, 0, 'Backup set type');
INSERT INTO report_views_columns VALUES('bset_set_type_name', 'backup_sets',  '(select column_string from report_col_string where column_name=''backup_sets.set_type'' and column_value=backup_sets.set_type)',      'string',     1, 0, 'Backup set type');

INSERT INTO report_views_columns VALUES('bset_ds_size',           'dsset_size',  'dsset_size.ds_size',       'double', 0, 0, 'Backup set DS Size');
INSERT INTO report_views_columns VALUES('bset_protected_size',    'dsset_size',  'dsset_size.prot_size',     'double', 1, 0, 'Backup set Protected Size');
INSERT INTO report_views_columns VALUES('bset_stored_size',       'dsset_size',  '(dsset_size.ds_size+dsset_size.lib_size)','double', 1, 0, 'Backup set stored size');
INSERT INTO report_views_columns VALUES('bset_blm_stored_size',   'dsset_size',  'dsset_size.blm_ds_size',   'double', 0, 0, 'Backup set BLM stored size');
INSERT INTO report_views_columns VALUES('bset_blm_protected_size','dsset_size',  'dsset_size.blm_prot_size', 'double', 0, 0, 'Backup set BLM protected size');

INSERT INTO report_views_columns VALUES('log_connect_time',      'connection_log',   'connection_log.connect_time',      'datetime', 0, 0, 'Connection Log connect time');
INSERT INTO report_views_columns VALUES('log_start_session_time','connection_log',   'connection_log.start_session_time','datetime', 1, 3, 'Connection Log start session time');
INSERT INTO report_views_columns VALUES('log_end_session_time',  'connection_log',   'connection_log.end_session_time',  'datetime', 0, 0, 'Connection Log end session time');
INSERT INTO report_views_columns VALUES('log_files',             'connection_log',   'connection_log.files',             'int',      0, 0,      'Connection Log Files');
INSERT INTO report_views_columns VALUES('log_online_delta',      'connection_log',   'connection_log.online_delta',      'double',   0, 0, 'Connection Log Online Delta');
INSERT INTO report_views_columns VALUES('log_online_amount',     'connection_log',   'connection_log.online_amount',     'double',   0, 0, 'Connection Log Online Amount');
INSERT INTO report_views_columns VALUES('log_transmit_amount' ,  'connection_log',   'connection_log.transmit_amount',   'double',   0, 0, 'Connection Log Transmit Amount');
INSERT INTO report_views_columns VALUES('log_arch_amount',       'connection_log',   'connection_log.arch_amount',       'double',   0, 0, 'Connection Log Archive Amount');
INSERT INTO report_views_columns VALUES('log_session_type',      'connection_log',   'connection_log.session_type',      'int',      1, 2013, 'Connection Log Session Type');
INSERT INTO report_views_columns VALUES('log_session_type_name', 'connection_log',   '(select column_string from report_col_string where column_name=''connection_log.session_type'' and column_value=connection_log.session_type)',      'string',      1,0, 'Connection Log Session Type Name');
INSERT INTO report_views_columns VALUES('log_session_id',        'connection_log',   'connection_log.session_id',        'int',      0, 0, 'Connection Log Session ID');
INSERT INTO report_views_columns VALUES('log_description',       'connection_log',   'connection_log.description',       'string',   0, 0, 'Connection Log Description');
INSERT INTO report_views_columns VALUES('log_dsdelta_amount',    'connection_log',   'connection_log.dsdelta_amount',    'double',   0, 0, 'Connection Log DSDelta Amount');
INSERT INTO report_views_columns VALUES('log_lib_amount',        'connection_log',   'connection_log.lib_amount',        'double',   0, 0, 'Connection Log Lib Amount');
INSERT INTO report_views_columns VALUES('log_new_amount',        'connection_log',   'connection_log.new_amount',        'double',   0, 0, 'Connection Log New Amount');
INSERT INTO report_views_columns VALUES('log_new_files',         'connection_log',   'connection_log.new_files',         'int',      0, 0, 'Connection Log New Files');
INSERT INTO report_views_columns VALUES('log_cluster_id',        'connection_log',   'connection_log.cluster_id',        'int',      0, 2014, 'Connection Log Cluster ID');
INSERT INTO report_views_columns VALUES('log_system_addr',       'connection_log',   'connection_log.system_address',    'string',   0, 0, 'Connection Log Systm Address');
INSERT INTO report_views_columns VALUES('log_client_stop',       'connection_log',   'connection_log.client_stop',       'int',      0, 0, 'Connection Log Client Stop Reason');
INSERT INTO report_views_columns VALUES('log_client_stop_desc',  'connection_log',   '(select column_string from report_col_string where column_name=''connection_log.client_stop'' and column_value=connection_log.client_stop)',       'String',      0, 0, 'Connection Log Client Stop Reason String');
INSERT INTO report_views_columns VALUES('log_errors',            'connection_log',   'connection_log.status',            'int',      0, 0, 'Connection Log Status');
INSERT INTO report_views_columns VALUES('log_completion',        'connection_log',   'connection_log.completion',        'int',      0, 0, 'Connection Log Completion');

INSERT INTO report_views_columns VALUES('event_id',           'event_log',  'event_log.ev_id',    'int',      0, 0, 'Event ID');
INSERT INTO report_views_columns VALUES('event_type',         'event_log',  'event_log.type',     'int',      0, 5, 'Event Type');
INSERT INTO report_views_columns VALUES('event_type_name',    'event_log',  '(select column_string from report_col_string where column_name=''event_log.type'' and column_value=event_log.type)',     'string',      1,0, 'Event Type Name');
INSERT INTO report_views_columns VALUES('event_time',         'event_log',  'event_log.ev_time',  'datetime', 1, 3, 'Event Time');
INSERT INTO report_views_columns VALUES('event_category',     'event_log',  'event_log.category', 'int',      0, 6, 'Event Category');
INSERT INTO report_views_columns VALUES('event_category_name','event_log',  '(select column_string from report_col_string where column_name=''event_log.category'' and column_value=event_log.category)', 'string',   1, 0, 'Event Category Name');
INSERT INTO report_views_columns VALUES('event_error_num',    'event_log',  'event_log.error',    'int',      0, 0, 'Event Error Number');
INSERT INTO report_views_columns VALUES('event_text',         'event_log',  'event_log.ev_text',  'string',   0, 0, 'Event Description');
INSERT INTO report_views_columns VALUES('event_user',         'event_log',  'event_log.userid',   'string',   1, 7, 'Event User Name');
INSERT INTO report_views_columns VALUES('event_ex_text',      'event_log',  'event_log.ex_text',  'string',   0, 0, 'Event Extra Text');

INSERT INTO report_views_columns VALUES('invoice_num',            'head_inv',  'head_inv.invoice_num',    'int',      0, 2015, 'Invoice Number');
INSERT INTO report_views_columns VALUES('invoice_from_date',      'head_inv',  'head_inv.from_date',      'datetime', 1, 3, 'Invoice start time');
INSERT INTO report_views_columns VALUES('invoice_to_date',        'head_inv',  'head_inv.to_date',        'datetime', 0, 3, 'Invoice end time');
INSERT INTO report_views_columns VALUES('invoice_creation_date',  'head_inv',  'head_inv.creation_date',  'datetime', 0, 0, 'Invoice creation time');
INSERT INTO report_views_columns VALUES('invoice_due_date',       'head_inv',  'head_inv.due_date',       'datetime', 0, 0, 'Invoice due date');
INSERT INTO report_views_columns VALUES('invoice_sp_company_name','head_inv',  'head_inv.p_company_name', 'string',   0, 0, 'Service Provider name');
INSERT INTO report_views_columns VALUES('invoice_sp_addr1',       'head_inv',  'head_inv.p_addr1',        'string',   0, 0, 'Service Provider addr 1');
INSERT INTO report_views_columns VALUES('invoice_sp_city',        'head_inv',  'head_inv.p_city',         'string',   0, 0, 'Service Provider addr 2');
INSERT INTO report_views_columns VALUES('invoice_sp_province',    'head_inv',  'head_inv.p_prov_state',   'string',   0, 0, 'Service provider province');
INSERT INTO report_views_columns VALUES('invoice_sp_country_name','head_inv',  '(select country_name from var_data, countries where country=country_code)',   'string', 0, 0, 'Service Provider country name');
INSERT INTO report_views_columns VALUES('invoice_sp_zipcode',     'head_inv',  'head_inv.p_postal_zip',   'string',   0, 0, 'Service Provider Zip Code');
INSERT INTO report_views_columns VALUES('invoice_sp_phone',       'head_inv',  'head_inv.p_phone',        'string',   0, 0, 'Service provider Phone');
INSERT INTO report_views_columns VALUES('invoice_sp_fax',         'head_inv',  'head_inv.p_fax',          'string',   0, 0, 'Service provider Fax');
INSERT INTO report_views_columns VALUES('invoice_sp_email',       'head_inv',  'head_inv.sp_email_addr',  'string',   0, 0, 'Service provider EMail');
INSERT INTO report_views_columns VALUES('invoice_box_num',        'head_inv',  'head_inv.b_dsbox_snum',   'string',   1, 2016, 'Invoice DS-Client Number');
INSERT INTO report_views_columns VALUES('invoice_account_num',    'head_inv',  'head_inv.b_account_num',  'string',   1, 2017, 'Invoice Account Number');
INSERT INTO report_views_columns VALUES('invoice_account_id',     'head_inv',  'head_inv.c_account_id',   'int',      0, 0, 'Invoice Account ID');
INSERT INTO report_views_columns VALUES('invoice_company_name',   'head_inv',  'head_inv.c_company_name', 'string',   0, 0, 'Invoice Account Name');
INSERT INTO report_views_columns VALUES('invoice_varref_id',      'head_inv',  'head_inv.s_group_id',     'int',      0, 2018, 'Invoice Group ID');
INSERT INTO report_views_columns VALUES('invoice_varref_name',    'head_inv',  'head_inv.s_group_name',   'string',   1, 0, 'Invoice group Name');
INSERT INTO report_views_columns VALUES('invoice_sales_rep_id',   'head_inv',  'head_inv.s_rep_id',       'int',      0, 2019, 'Invoice Sales Rep ID');
INSERT INTO report_views_columns VALUES('invoice_sales_rep_name', 'head_inv',  'head_inv.s_name',         'string',   1, 0, 'Invoice Sales Rep Name');
INSERT INTO report_views_columns VALUES('invoice_consolidation',  'head_inv',  'head_inv.consolidation',  'int',      0, 0, 'Invoice is consolidation invoice');
INSERT INTO report_views_columns VALUES('invoice_loc_addr1',      'head_inv',  'head_inv.l_addr1',        'string',   0, 0, 'Invoice DS-Client Addr 1');
INSERT INTO report_views_columns VALUES('invoice_loc_addr2',      'head_inv',  'head_inv.l_addr2',        'string',   0, 0, 'Invoice DS-Client Addr 2');
INSERT INTO report_views_columns VALUES('invoice_loc_city',       'head_inv',  'head_inv.l_city',         'string',   0, 0, 'Invoice DS-Client City');
INSERT INTO report_views_columns VALUES('invoice_loc_province',   'head_inv',  'head_inv.l_prov_state',   'string',   0, 0, 'Invoice DS-Client province');
INSERT INTO report_views_columns VALUES('invoice_loc_country',    'head_inv',  'head_inv.l_country',      'string',   0, 0, 'Invoice DS-Client Country');
INSERT INTO report_views_columns VALUES('invoice_loc_zipcode',    'head_inv',  'head_inv.l_postal_zip',   'string',   0, 0, 'Invoice DS-Client Zip code');
INSERT INTO report_views_columns VALUES('invoice_loc_phone',      'head_inv',  'head_inv.l_phone',        'string',   0, 0, 'Invoice DS-Client Phone');
INSERT INTO report_views_columns VALUES('invoice_loc_fax',        'head_inv',  'head_inv.l_fax',          'string',   0, 0, 'Invoice DS-Client Fax');
INSERT INTO report_views_columns VALUES('invoice_bloc_addr1',     'head_inv',  'head_inv.bl_addr1',   'string',   0, 0, 'Invoice DS-Client Billing Addr1');
INSERT INTO report_views_columns VALUES('invoice_bloc_addr2',     'head_inv',  'head_inv.bl_addr2',   'string',   0, 0, 'Invoice DS-Client Billing Addr2');
INSERT INTO report_views_columns VALUES('invoice_bloc_city',      'head_inv',  'head_inv.bl_city',    'string',   0, 0, 'Invoice DS-Client Billing City');
INSERT INTO report_views_columns VALUES('invoice_bloc_province',  'head_inv',  'head_inv.bl_prov_state',     'string', 0, 0, 'Invoice DS-Client Billing province');
INSERT INTO report_views_columns VALUES('invoice_bloc_zipcode',   'head_inv',  'head_inv.bl_postal_zip',     'string', 0, 0, 'Invoice DS-Client Billing Zip Code');
INSERT INTO report_views_columns VALUES('invoice_bloc_country',   'head_inv',  'head_inv.bl_country',        'string', 0, 0, 'Invoice DS-Client Billing Country');
INSERT INTO report_views_columns VALUES('invoice_bloc_phone',     'head_inv',  'head_inv.bl_phone',          'string', 0, 0, 'Invoice DS-Client Billing Phone');
INSERT INTO report_views_columns VALUES('invoice_bloc_fax',       'head_inv',  'head_inv.bl_fax',            'string', 0, 0, 'Invoice DS-Client Billing Fax');
INSERT INTO report_views_columns VALUES('invoice_bloc_ponum',     'head_inv',  'head_inv.bl_po_num',         'string', 0, 0, 'Invoice DS-Client Billing PO Number');
INSERT INTO report_views_columns VALUES('invoice_bloc_bill_plan', 'head_inv',  'head_inv.bl_billing_plan',   'int',    0, 0, 'Invoice DS-Client Billing Plan');
INSERT INTO report_views_columns VALUES('invoice_bloc_plan_name', 'head_inv',  '(select plan_name from bill_plan where bill_plan.plan_num = head_inv.bl_billing_plan)',   'string',    0, 0, 'Invoice DS-Client Billing Plan Name');
INSERT INTO report_views_columns VALUES('invoice_bloc_bank_name', 'head_inv',  'head_inv.bl_bank_name',      'string', 0, 0, 'Invoice DS-Client Bank Name');
INSERT INTO report_views_columns VALUES('invoice_bloc_bank_account','head_inv',  'head_inv.bl_bank_account',   'string', 0, 0, 'Invoice DS-Client Bank Account');
INSERT INTO report_views_columns VALUES('invoice_bloc_expire_ate','head_inv',  'head_inv.bl_exp_date',       'date',   0, 0, 'Invoice DS-Client Credit Card Expire Date');
INSERT INTO report_views_columns VALUES('invoice_bloc_bank_addr', 'head_inv',  'head_inv.bl_bank_addr',      'string', 0, 0, 'Invoice DS-Client Bank Addr');
INSERT INTO report_views_columns VALUES('invoice_bloc_contact',   'head_inv',  'head_inv.bl_contact',        'string', 0, 0, 'Invoice DS-Client Contace');
INSERT INTO report_views_columns VALUES('invoice_bloc_tax1',      'head_inv',  'head_inv.bp_tax1',           'int',    0, 0, 'Invoice DS-Client Should Add Tax1');
INSERT INTO report_views_columns VALUES('invoice_bloc_tax1exemp', 'head_inv',  'head_inv.bl_tax1_exemp',     'string', 0, 0, 'Invoice DS-Client Tax1 Exemption number');
INSERT INTO report_views_columns VALUES('invoice_bloc_tax2',      'head_inv',  'head_inv.bp_tax2',           'int',    0, 0, 'Invoice DS-Client Should Add Tax2');
INSERT INTO report_views_columns VALUES('invoice_bloc_tax2exemp', 'head_inv',  'head_inv.bl_tax2_exemp',     'string', 0, 0, 'Invoice DS-Client Tax2 Exemption number');
INSERT INTO report_views_columns VALUES('invoice_cur_online',     'head_inv',  'head_inv.crt_online',        'double', 0, 0, 'DS-Client Online Size');
INSERT INTO report_views_columns VALUES('invoice_cur_archive_amt','head_inv',  'head_inv.crt_archive',       'double', 0, 0, 'DS-Client Archive Size');
INSERT INTO report_views_columns VALUES('invoice_bscale_id',      'head_inv',  'head_inv.sc_scale_id',       'int',    0, 0, 'Billing Scale ID');
INSERT INTO report_views_columns VALUES('invoice_bscale_name',    'head_inv',  'head_inv.sc_name',           'string', 0, 0, 'Billing Scale Name');
INSERT INTO report_views_columns VALUES('invoice_bscale_exp_date','head_inv',  'head_inv.sc_todate',         'date',   0, 0, 'Billing Scale Expire Date');
INSERT INTO report_views_columns VALUES('invoice_bscale_inv_method',     'head_inv',  'head_inv.sc_inv_method',     'int',    0, 0, 'Billing Scale Invoice Method');
INSERT INTO report_views_columns VALUES('invoice_bscale_inv_method_name','head_inv',  '(select column_string from report_col_string where column_name=''head_inv.sc_inv_method'' and column_value=head_inv.sc_inv_method)',     'string',    0, 0, 'Billing Scale Invoice Method Name');
INSERT INTO report_views_columns VALUES('invoice_bscale_cal_method',     'head_inv',  'head_inv.sc_cal_method',     'int',    0, 0, 'Billing Scale Invoice Calculation Method');
INSERT INTO report_views_columns VALUES('invoice_bscale_cal_method_name','head_inv',  '(select column_string from report_col_string where column_name=''head_inv.sc_cal_method'' and column_value=head_inv.sc_cal_method)',     'string',    0, 0, 'Billing Scale Invoice Calculation Method Name');
INSERT INTO report_views_columns VALUES('invoice_blm_scale_id',          'head_inv',  'head_inv.blm_scale_id',       'int',    0, 0, 'Invoice BLM Scale ID');
INSERT INTO report_views_columns VALUES('invoice_blm_scale_name',        'head_inv',  'head_inv.blm_sc_name',        'string', 0, 0, 'Invoicd BLM Scale Name');
INSERT INTO report_views_columns VALUES('invoice_blm_cal_method',        'head_inv',  'head_inv.blm_sc_cal_method',  'int',    0, 0, 'Invoice BLM Scale Calculation Method');
INSERT INTO report_views_columns VALUES('invoice_blm_cal_method_name',   'head_inv',  '(select column_string from report_col_string where column_name=''head_inv.blm_sc_cal_method'' and column_value=head_inv.blm_sc_cal_method)',  'string',    0, 0, 'Invoice BLM Scale Calculation Method Name');
INSERT INTO report_views_columns VALUES('invoice_blm_inv_method',        'head_inv',  'head_inv.blm_sc_inv_method',  'int',    0, 0, 'Invoice BLM Scale Invoice method');
INSERT INTO report_views_columns VALUES('invoice_blm_inv_method_name',   'head_inv',  '(select column_string from report_col_string where column_name=''head_inv.blm_sc_inv_method'' and column_value=head_inv.blm_sc_inv_method)',  'string',    0, 0, 'Invoice BLM Scale Invoice method Name');
INSERT INTO report_views_columns VALUES('invoice_blm_size',       'head_inv',  'head_inv.blm_size',           'double', 0, 0, 'Invoice BLM Size');
INSERT INTO report_views_columns VALUES('invoice_subtotal',       'head_inv',  'head_inv.subtotal',           'double', 0, 0, 'Invoice Subtotal');
INSERT INTO report_views_columns VALUES('invoice_tax1_amount',    'head_inv',  'head_inv.tax1_amount',        'double', 0, 0, 'Invoice Tax1 Amount');
INSERT INTO report_views_columns VALUES('invoice_tax2_amount',    'head_inv',  'head_inv.tax2_amount',        'double', 0, 0, 'Invoice Tax2 Amount');
INSERT INTO report_views_columns VALUES('invoice_grand_total',    'head_inv',  'head_inv.grand_total',        'double', 0, 0, 'Invoice Grand Total');
INSERT INTO report_views_columns VALUES('invoice_amount_unit',    'head_inv',  'head_inv.amount_unit',        'int',    0, 0, 'Invoice Amount Unit');
INSERT INTO report_views_columns VALUES('invoice_loc_name',       'head_inv',  'head_inv.l_name',             'string', 0, 0, 'Invoice DS-Client Location name');
INSERT INTO report_views_columns VALUES('invoice_loc_email',      'head_inv',  'head_inv.l_email_addr',       'string', 0, 0, 'Invoice DS-Client Email Addr');
INSERT INTO report_views_columns VALUES('invoice_currency_pos',   'head_inv',  'head_inv.currency_pos',      'int',     0, 0, 'Invoice Currency Position');
INSERT INTO report_views_columns VALUES('invoice_currency',       'head_inv',  'head_inv.currency',          'string',  0, 0, 'Invoice Used Currency');
INSERT INTO report_views_columns VALUES('invoice_consolidation_date','head_inv',  'head_inv.consolidation_date','date',    0, 0, 'Invoice Consolidation Date');
INSERT INTO report_views_columns VALUES('invoice_description',    'head_inv',  'head_inv.error_dscrpt',      'string',  0, 0, 'Invoice Special Description (Last Invoice, Migration Invoice etc)');
INSERT INTO report_views_columns VALUES('invoice_connection_time','head_inv',  'head_inv.crt_time',          'double',  0, 0, 'Invoice DS-Client Connection Time');
INSERT INTO report_views_columns VALUES('invoice_sp_brandingfile','head_inv',   ':BrandingFile',           'string', 0, 0, 'Service Provider''s Branding File');

INSERT INTO report_views_columns VALUES('inv_charge_id',           'addch_inv',  'addch_inv.aid',          'int',    0, 0, 'Invoice Charge ID');
INSERT INTO report_views_columns VALUES('inv_charge_service_id',   'addch_inv',  'addch_inv.service_id',   'int',    0, 0, 'Invoice Charge Service ID');
INSERT INTO report_views_columns VALUES('inv_charge_service_type', 'addch_inv',  'addch_inv.service_type', 'int',    0, 0, 'Invoice Service Type');
INSERT INTO report_views_columns VALUES('inv_charge_service_name', 'addch_inv',  'addch_inv.service_name', 'string', 0, 0, 'Invoice Service Name');
INSERT INTO report_views_columns VALUES('inv_charge_qty',          'addch_inv',  '(case when (addch_inv.qty<0) then 1 else addch_inv.qty end) ', 'double', 0, 0, 'Invoice Charge Quantity');
INSERT INTO report_views_columns VALUES('inv_charge_price',        'addch_inv',  '(case when (addch_inv.qty<0) then -1*addch_inv.price else addch_inv.price end) ', 'double', 0, 0, 'Invoice Charge price');
INSERT INTO report_views_columns VALUES('inv_charge_amount',       'addch_inv',  'addch_inv.amount',       'double', 0, 0, 'Invoice Charge Amount');

INSERT INTO report_views_columns VALUES('reference_num',            'client_reference',  'client_reference.invoice_num',    'int',      0, 0, 'Reference Number');
INSERT INTO report_views_columns VALUES('reference_from_date',      'client_reference',  'client_reference.from_date',      'datetime', 1, 0, 'Reference start time');
INSERT INTO report_views_columns VALUES('reference_to_date',        'client_reference',  'client_reference.to_date',        'datetime', 0, 0, 'Reference end time');
INSERT INTO report_views_columns VALUES('reference_creation_date',  'client_reference',  'client_reference.creation_date',  'datetime', 0, 0, 'Reference creation time');
INSERT INTO report_views_columns VALUES('reference_box_num',        'client_reference',  'client_reference.b_dsbox_snum',   'string',   1, 0, 'Reference DS-Client Number');
INSERT INTO report_views_columns VALUES('reference_cur_online',     'client_reference',  'client_reference.crt_online',        'double', 0, 0, 'DS-Client Online Size');
INSERT INTO report_views_columns VALUES('reference_cur_archive_amt','client_reference',  'client_reference.crt_archive',       'double', 0, 0, 'DS-Client Archive Size');
INSERT INTO report_views_columns VALUES('reference_bscale_id',      'client_reference',  'client_reference.sc_scale_id',       'int',    0, 0, 'Billing Scale ID');
INSERT INTO report_views_columns VALUES('reference_bscale_name',    'client_reference',  'client_reference.sc_name',           'string', 0, 0, 'Billing Scale Name');
INSERT INTO report_views_columns VALUES('reference_bscale_inv_method',     'client_reference',  'client_reference.sc_inv_method',     'int',    0, 0, 'Billing Scale Invoice Method');
INSERT INTO report_views_columns VALUES('reference_bscale_inv_method_name','client_reference',  '(select column_string from report_col_string where column_name=''head_inv.sc_inv_method'' and column_value=client_reference.sc_inv_method)',     'string',    0, 0, 'Billing Scale Invoice Method Name');
INSERT INTO report_views_columns VALUES('reference_bscale_cal_method',     'client_reference',  'client_reference.sc_cal_method',     'int',    0, 0, 'Billing Scale Invoice Calculation Method');
INSERT INTO report_views_columns VALUES('reference_bscale_cal_method_name','client_reference',  '(select column_string from report_col_string where column_name=''head_inv.sc_cal_method'' and column_value=client_reference.sc_cal_method)',     'string',    0, 0, 'Billing Scale Invoice Calculation Method Name');
INSERT INTO report_views_columns VALUES('reference_blm_scale_id',          'client_reference',  'client_reference.blm_scale_id',       'int',    0, 0, 'Reference BLM Scale ID');
INSERT INTO report_views_columns VALUES('reference_blm_scale_name',        'client_reference',  'client_reference.blm_sc_name',        'string', 0, 0, 'Reference BLM Scale Name');
INSERT INTO report_views_columns VALUES('reference_blm_cal_method',        'client_reference',  'client_reference.blm_sc_cal_method',  'int',    0, 0, 'Reference BLM Scale Calculation Method');
INSERT INTO report_views_columns VALUES('reference_blm_cal_method_name',   'client_reference',  '(select column_string from report_col_string where column_name=''head_inv.blm_sc_cal_method'' and column_value=client_reference.blm_sc_cal_method)',  'string',    0, 0, 'Reference BLM Scale Calculation Method Name');
INSERT INTO report_views_columns VALUES('reference_blm_inv_method',        'client_reference',  'client_reference.blm_sc_inv_method',  'int',    0, 0, 'Reference BLM Scale Invoice method');
INSERT INTO report_views_columns VALUES('reference_blm_inv_method_name',   'client_reference',  '(select column_string from report_col_string where column_name=''head_inv.blm_sc_inv_method'' and column_value=client_reference.blm_sc_inv_method)',  'string',    0, 0, 'Reference BLM Scale Invoice method Name');
INSERT INTO report_views_columns VALUES('reference_loc_name',       'client_reference',  'client_reference.l_name',             'string', 0, 0, 'Reference DS-Client Location name');
INSERT INTO report_views_columns VALUES('reference_blm_size',       'client_reference',  'client_reference.blm_size',           'double', 0, 0, 'Reference BLM Size');
INSERT INTO report_views_columns VALUES('reference_subtotal',       'client_reference',  'client_reference.subtotal',           'double', 0, 0, 'Reference Subtotal');
INSERT INTO report_views_columns VALUES('reference_tax1_amount',    'client_reference',  'client_reference.tax1_amount',        'double', 0, 0, 'Reference Tax1 Amount');
INSERT INTO report_views_columns VALUES('reference_tax2_amount',    'client_reference',  'client_reference.tax2_amount',        'double', 0, 0, 'Reference Tax2 Amount');
INSERT INTO report_views_columns VALUES('reference_grand_total',    'client_reference',  'client_reference.grand_total',        'double', 0, 0, 'Reference Grand Total');
INSERT INTO report_views_columns VALUES('reference_currency_pos',   'client_reference',  'client_reference.currency_pos',      'int',     0, 0, 'Reference Currency Position');
INSERT INTO report_views_columns VALUES('reference_currency',       'client_reference',  'client_reference.currency',          'string',  0, 0, 'Reference Used Currency');

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (1, 'var_referrals', 'var_data, sale_groups '
   ' left join ( SELECT group_id, commission FROM group_commission '
   '            WHERE group_commission.effective_date = '
   '                    ( SELECT max(cms.effective_date) '
   '                      FROM   group_commission cms '
   '                      WHERE  cms.group_id = group_commission.group_id '
   '                      AND    cms.effective_date < EXTRACT(EPOCH FROM now()) '
   '                    ) '
   '           ) group_commission ON group_commission.group_id = sale_groups.group_id '
 );

INSERT INTO report_views(view_id, view_name, view_from) 
VALUES (2, 'sales_representatives',     'var_data, sale_groups '
   ' left join ( SELECT group_id, commission FROM group_commission '
   '            WHERE group_commission.effective_date = '
   '                    ( SELECT max(cms.effective_date) '
   '                      FROM   group_commission cms '
   '                      WHERE  cms.group_id = group_commission.group_id '
   '                      AND    cms.effective_date < EXTRACT(EPOCH FROM now()) '
   '                    ) '
   '           ) group_commission ON group_commission.group_id = sale_groups.group_id '
   ' join      sale_reps        ON sale_groups.group_id=sale_reps.group_id' );

INSERT INTO report_views(view_id, view_name, view_from) 
VALUES (3, 'customers', 'var_data, customer '
   ' left join sale_reps                      ON customer.rep_id = sale_reps.rep_id '
   ' left join sale_groups                    ON sale_reps.group_id= sale_groups.group_id '
   ' left join ( SELECT group_id, commission FROM group_commission '
   '            WHERE group_commission.effective_date = '
   '                    ( SELECT max(cms.effective_date) '
   '                      FROM   group_commission cms '
   '                      WHERE  cms.group_id = group_commission.group_id '
   '                      AND    cms.effective_date < EXTRACT(EPOCH FROM now()) '
   '                    ) '
   '           ) group_commission ON group_commission.group_id = sale_groups.group_id '
   ' left join location cust_loc              ON cust_loc.id = customer.location_id '
   ' left join location cust_billloc          ON cust_billloc.id=customer.billing_location_id '
   ' left join location_billing cust_billinfo ON cust_billloc.location_billing_id = cust_billinfo.id '
   ' left join customer_quota                 ON customer.account_id = customer_quota.account_id '
);


INSERT INTO report_views(view_id, view_name, view_from)
VALUES (4, 'ds_clients', 'var_data, dsbox '
   ' left join customer                       ON dsbox.account_num = customer.account_num '
   ' left join sale_reps                      ON customer.rep_id = sale_reps.rep_id '
   ' left join sale_groups                    ON sale_reps.group_id= sale_groups.group_id '
   ' left join ( SELECT group_id, commission FROM group_commission '
   '            WHERE group_commission.effective_date = '
   '                    ( SELECT max(cms.effective_date) '
   '                      FROM   group_commission cms '
   '                      WHERE  cms.group_id = group_commission.group_id '
   '                      AND    cms.effective_date < EXTRACT(EPOCH FROM now()) '
   '                    ) '
   '           ) group_commission ON group_commission.group_id = sale_groups.group_id '
   ' left join location cust_loc              ON cust_loc.id = customer.location_id '
   ' left join location cust_billloc          ON cust_billloc.id=customer.billing_location_id '
   ' left join location_billing cust_billinfo ON cust_billloc.location_billing_id = cust_billinfo.id '
   ' left join customer_quota                 ON customer.account_id = customer_quota.account_id '
   ' left join dsbox_quota                    ON dsbox.box_id      = dsbox_quota.box_id '
   ' left join dsbox_size                     ON dsbox.box_id      = dsbox_size.box_id '
   ' left join location box_loc               ON dsbox.location_id = box_loc.id '
   ' left join location box_billloc           ON box_billloc.id = dsbox.billing_location_id '
   ' left join location_billing box_billinfo  ON box_billloc.location_billing_id = box_billinfo.id '
);

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (5, 'backup_sets', 'var_data, backup_sets '
   ' left join dsset_size         ON  (dsset_size.box_id = backup_sets.box_id and dsset_size.req_id = backup_sets.req_id) '
   ' left join dsbox              ON  dsbox.box_id = backup_sets.box_id '
   ' left join dsbox_quota        ON dsbox.box_id = dsbox_quota.box_id '
   ' left join customer           ON dsbox.account_num = customer.account_num '
   ' left join sale_reps          ON customer.rep_id = sale_reps.rep_id '
   ' left join sale_groups        ON sale_reps.group_id= sale_groups.group_id '
   ' left join ( SELECT group_id, commission FROM group_commission '
   '            WHERE group_commission.effective_date = '
   '                    ( SELECT max(cms.effective_date) '
   '                      FROM   group_commission cms '
   '                      WHERE  cms.group_id = group_commission.group_id '
   '                      AND    cms.effective_date < EXTRACT(EPOCH FROM now()) '
   '                    ) '
   '           ) group_commission ON group_commission.group_id = sale_groups.group_id '
   ' left join customer_quota     ON customer.account_id = customer_quota.account_id '
);

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (6, 'activity_logs', 'var_data, connection_log '
   ' left join backup_sets ON backup_sets.set_id = connection_log.set_id '
   ' left join dsbox       ON dsbox.dsbox_snum = connection_log.dsbox_snum '
   ' left join customer    ON dsbox.account_num = customer.account_num '
   ' left join sale_reps   ON customer.rep_id = sale_reps.rep_id '
   ' left join sale_groups ON sale_reps.group_id= sale_groups.group_id '
   ' left join ( SELECT group_id, commission FROM group_commission '
   '            WHERE group_commission.effective_date = '
   '                    ( SELECT max(cms.effective_date) '
   '                      FROM   group_commission cms '
   '                      WHERE  cms.group_id = group_commission.group_id '
   '                      AND    cms.effective_date < EXTRACT(EPOCH FROM now()) '
   '                    ) '
   '           ) group_commission ON group_commission.group_id = sale_groups.group_id '
);

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (7, 'event_logs', 'var_data, event_log '
   ' left join connection_log ON event_log.ex_long = connection_log.session_id '
   ' left join backup_sets on backup_sets.set_id = connection_log.set_id '
   ' left join dsbox on dsbox.dsbox_snum = connection_log.dsbox_snum '
   ' left join customer on dsbox.account_num = customer.account_num '
);

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (8, 'invoices', 'head_inv');

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (9, 'invoice_charges', 'head_inv left join addch_inv on head_inv.invoice_num = addch_inv.invoice_num');

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (10, 'customer_invoices', 'head_inv join head_inv client_reference \
      ON   ((head_inv.b_dsbox_snum is NULL or head_inv.b_dsbox_snum = '''') \
            AND  not (client_reference.b_dsbox_snum is NULL or client_reference.b_account_num = '''') \
            AND  (client_reference.consolidation = 1) \
            AND  (head_inv.b_account_num = client_reference.b_account_num) \
            AND  (head_inv.consolidation_date = client_reference.consolidation_date) \
           ) ');

INSERT INTO report_views_tables VALUES(1, 'var_data',    'var_data');
INSERT INTO report_views_tables VALUES(1, 'sale_groups', 'sale_groups');
INSERT INTO report_views_tables VALUES(1, 'group_commission', 'group_commission');

INSERT INTO report_views_tables VALUES(2, 'var_data',    'var_data');
INSERT INTO report_views_tables VALUES(2, 'sale_groups', 'sale_groups');
INSERT INTO report_views_tables VALUES(2, 'group_commission', 'group_commission');
INSERT INTO report_views_tables VALUES(2, 'sale_reps',   'sale_reps');

INSERT INTO report_views_tables VALUES(3, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(3, 'sale_groups',    'sale_groups');
INSERT INTO report_views_tables VALUES(3, 'group_commission', 'group_commission');
INSERT INTO report_views_tables VALUES(3, 'sale_reps',      'sale_reps');
INSERT INTO report_views_tables VALUES(3, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(3, 'cust_loc',       'location');
INSERT INTO report_views_tables VALUES(3, 'cust_billloc',   'location');
INSERT INTO report_views_tables VALUES(3, 'cust_billinfo',  'location_billing');
INSERT INTO report_views_tables VALUES(3, 'customer_quota', 'customer_quota');

INSERT INTO report_views_tables VALUES(4, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(4, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(4, 'sale_groups',    'sale_groups');
INSERT INTO report_views_tables VALUES(4, 'group_commission', 'group_commission');
INSERT INTO report_views_tables VALUES(4, 'sale_reps',      'sale_reps');
INSERT INTO report_views_tables VALUES(4, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(4, 'cust_loc',       'location');
INSERT INTO report_views_tables VALUES(4, 'cust_billloc',   'location');
INSERT INTO report_views_tables VALUES(4, 'cust_billinfo',  'location_billing');
INSERT INTO report_views_tables VALUES(4, 'customer_quota', 'customer_quota');
INSERT INTO report_views_tables VALUES(4, 'dsbox_quota',    'dsbox_quota');
INSERT INTO report_views_tables VALUES(4, 'dsbox_size',     'dsbox_size');
INSERT INTO report_views_tables VALUES(4, 'box_loc',        'location');
INSERT INTO report_views_tables VALUES(4, 'box_billloc',    'location');
INSERT INTO report_views_tables VALUES(4, 'box_billinfo',   'location_billing');

INSERT INTO report_views_tables VALUES(5, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(5, 'backup_sets',    'backup_sets');
INSERT INTO report_views_tables VALUES(5, 'dsset_size',     'dsset_size');
INSERT INTO report_views_tables VALUES(5, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(5, 'dsbox_quota',    'dsbox_quota');
INSERT INTO report_views_tables VALUES(5, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(5, 'sale_groups',    'sale_groups');
INSERT INTO report_views_tables VALUES(5, 'group_commission', 'group_commission');
INSERT INTO report_views_tables VALUES(5, 'sale_reps',      'sale_reps');
INSERT INTO report_views_tables VALUES(5, 'customer_quota', 'customer_quota');

INSERT INTO report_views_tables VALUES(6, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(6, 'connection_log', 'connection_log');
INSERT INTO report_views_tables VALUES(6, 'backup_sets',    'backup_sets');
INSERT INTO report_views_tables VALUES(6, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(6, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(6, 'sale_groups',    'sale_groups');
INSERT INTO report_views_tables VALUES(6, 'group_commission', 'group_commission');
INSERT INTO report_views_tables VALUES(6, 'sale_reps',      'sale_reps');

INSERT INTO report_views_tables VALUES(7, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(7, 'event_log',      'event_log');
INSERT INTO report_views_tables VALUES(7, 'connection_log', 'connection_log');
INSERT INTO report_views_tables VALUES(7, 'backup_sets',    'backup_sets');
INSERT INTO report_views_tables VALUES(7, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(7, 'customer',       'customer');

INSERT INTO report_views_tables VALUES(8, 'head_inv',       'head_inv');

INSERT INTO report_views_tables VALUES(9, 'head_inv',    'head_inv');
INSERT INTO report_views_tables VALUES(9, 'addch_inv',   'addch_inv');

INSERT INTO report_views_tables VALUES(10, 'head_inv',         'head_inv');
INSERT INTO report_views_tables VALUES(10, 'client_reference', 'head_inv');

UPDATE ds_data SET db_number = 100 WHERE db_number = 99;
