
CREATE TABLE billing_server(
    ip          varchar(16) NOT NULL, 
    status      int NOT NULL, 
    cookie      bytea
);

CREATE TABLE lan_discovery_req(
    id          SERIAL PRIMARY KEY,
    box_id      int NOT NULL, 
    req_time    int NOT NULL,
    price       float NOT NULL,
	foreign key (box_id) references dsbox(box_id) on delete cascade
);

CREATE TABLE cdrequests_history(
   id                   SERIAL PRIMARY KEY,
   old_id               int NOT NULL,
   set_id               int NOT NULL,
   media_name           varchar(100),
   username             varchar(100) NULL,
   receivedtime         varchar(100) NULL,
   producetime          varchar(100) NULL,
   state                smallint NULL,
   price                float NULL,
   disknums             smallint NULL,
   options              int NULL,
   mailing              varchar(100) NULL,
   telephone            varchar(100) NULL,
   person               varchar(100) NULL,
   numfiles             int NULL,
   fbytes               float NULL,
   vbytes               float NULL,
   failedfiles          int NULL,
   buf_dir              varchar(1024) NULL,
   writing_time_in_min  int NULL,
   requestfinishtime    int NULL, -- was datetime
   cluster_id           int,  --The cluster id who set the bufer (buf_dir)
   copies               int,
   unitprice            float,
   fixedprice           float
);

ALTER TABLE history_customer_num ADD old_acc_id int;
ALTER TABLE history_customer_num ADD new_acc_id int;

ALTER TABLE cdrequests ADD copies       int;
ALTER TABLE cdrequests ADD unitprice    float;
ALTER TABLE cdrequests ADD fixedprice   float;

ALTER TABLE var_data ADD lan_discovery_price  float;

UPDATE var_data 
SET  lan_discovery_price = ( 
    SELECT  price 
    FROM    charge_items 
    WHERE   item_num=100
    AND     effective_date = (SELECT max(effective_date) 
                              FROM   charge_items 
                              WHERE  item_num=100 
                              AND    effective_date < date_part('epoch',now())
                             )
);

DROP TABLE report_col_string;
CREATE TABLE report_col_string(
    column_name      varchar(100)  NOT NULL,
    column_value     int,
    column_string    varchar(100)
);

INSERT INTO report_col_string VALUES('quota_unit',           1 , 'MB');
INSERT INTO report_col_string VALUES('quota_unit',           2 , 'GB');
INSERT INTO report_col_string VALUES('customer_quota.flag2', 0 , 'Protected Size');
INSERT INTO report_col_string VALUES('customer_quota.flag2', 2 , 'Stored Size');
INSERT INTO report_col_string VALUES('dsbox.status',         0 , 'Unregistred');
INSERT INTO report_col_string VALUES('dsbox.status',         1 , 'Active');
INSERT INTO report_col_string VALUES('dsbox.status',         2 , 'Suspend');
INSERT INTO report_col_string VALUES('dsbox.status',         3 , 'Deactivate');
INSERT INTO report_col_string VALUES('dsbox.status',         4 , 'Deregistrated');
INSERT INTO report_col_string VALUES('dsbox_quota.flag40',   0 , 'Protected Size');
INSERT INTO report_col_string VALUES('dsbox_quota.flag40',   64, 'Stored Size');

INSERT INTO report_col_string VALUES('event_log.type', 0 , 'Information');
INSERT INTO report_col_string VALUES('event_log.type', 1 , 'Warning');
INSERT INTO report_col_string VALUES('event_log.type', 2 , 'Error');

INSERT INTO report_col_string VALUES('backup_sets.set_type', 0, 'File System');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 1, 'SQL Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 2, 'NT Services');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 3, 'Exchange Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 4, 'Oracle Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 5, 'Permissions');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 6, 'Exchange Server Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 7, 'Microsoft Outlook Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 8, 'MS Office');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 9, 'AS400 Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',10, 'MySQL');
INSERT INTO report_col_string VALUES('backup_sets.set_type',11, 'PostgreSQL');
INSERT INTO report_col_string VALUES('backup_sets.set_type',12, 'Oracle Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',15, 'DB2 Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',16, 'Lotus Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type',17, 'Groupwise Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type',18, 'SharePoint Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',20, 'VM Ware');

INSERT INTO report_col_string VALUES('connection_log.session_type', 0 , 'Connection');
INSERT INTO report_col_string VALUES('connection_log.session_type', 1 , 'Backup');
INSERT INTO report_col_string VALUES('connection_log.session_type', 2 , 'Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type', 3 , 'Daily Admin');
INSERT INTO report_col_string VALUES('connection_log.session_type', 4 , 'Delete');
INSERT INTO report_col_string VALUES('connection_log.session_type', 5 , 'Weekly Admin');
INSERT INTO report_col_string VALUES('connection_log.session_type', 6 , 'Recovery');
INSERT INTO report_col_string VALUES('connection_log.session_type', 7 , 'Registration');
INSERT INTO report_col_string VALUES('connection_log.session_type', 8 , 'System Admin');
INSERT INTO report_col_string VALUES('connection_log.session_type', 9 , 'System Backup');
INSERT INTO report_col_string VALUES('connection_log.session_type',10 , 'Synchronization');
INSERT INTO report_col_string VALUES('connection_log.session_type',11 , 'Initial Backup');
INSERT INTO report_col_string VALUES('connection_log.session_type',12 , 'Disc/Tape');
INSERT INTO report_col_string VALUES('connection_log.session_type',13 , 'LAN Analyze Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',14 , 'Portable');
INSERT INTO report_col_string VALUES('connection_log.session_type',15 , 'Remove Orphaned Libraries');
INSERT INTO report_col_string VALUES('connection_log.session_type',16 , 'Empty Trash');
INSERT INTO report_col_string VALUES('connection_log.session_type',17 , 'OnLine File Summary');
INSERT INTO report_col_string VALUES('connection_log.session_type',18 , 'Synchronized Delete');
INSERT INTO report_col_string VALUES('connection_log.session_type',19 , 'Clean Libraries');
INSERT INTO report_col_string VALUES('connection_log.session_type',20 , 'SLA Monitor Check');
INSERT INTO report_col_string VALUES('connection_log.session_type',21 , 'SLA Monitor Register');
INSERT INTO report_col_string VALUES('connection_log.session_type',22 , 'SLA Monitor Unregister');
INSERT INTO report_col_string VALUES('connection_log.session_type',23 , 'Test Connection');
INSERT INTO report_col_string VALUES('connection_log.session_type',24 , 'Migration');
INSERT INTO report_col_string VALUES('connection_log.session_type',27 , 'LTS Process');
INSERT INTO report_col_string VALUES('connection_log.session_type',28 , 'LTS Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',29 , 'LTS Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type',30 , 'System Autonomic Healing');
INSERT INTO report_col_string VALUES('connection_log.session_type',32 , 'Disaster Recovery');
INSERT INTO report_col_string VALUES('connection_log.session_type',33 , 'Storage Scan');
INSERT INTO report_col_string VALUES('connection_log.session_type',34 , 'Validation');
INSERT INTO report_col_string VALUES('connection_log.session_type',35 , 'BLM Archiving');
INSERT INTO report_col_string VALUES('connection_log.session_type',36 , 'Auto Upgrade');
INSERT INTO report_col_string VALUES('connection_log.session_type',37 , 'Storage Statistics');
INSERT INTO report_col_string VALUES('connection_log.session_type',38 , 'BLM Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type',39 , 'BLM Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',40 , 'Retention');
INSERT INTO report_col_string VALUES('connection_log.session_type',41 , 'Disc/Tape Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',42 , 'Disc/Tape Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type',43 , 'Scheduled Report');
INSERT INTO report_col_string VALUES('connection_log.session_type',44 , 'File Optimization');
INSERT INTO report_col_string VALUES('connection_log.session_type',45 , 'Clean Logs');
INSERT INTO report_col_string VALUES('connection_log.session_type',46 , 'Tape Convert');
INSERT INTO report_col_string VALUES('connection_log.session_type',47 , 'Replication Send');
INSERT INTO report_col_string VALUES('connection_log.session_type',48 , 'Replication Receive');
INSERT INTO report_col_string VALUES('connection_log.session_type',49 , 'Replication Delete');

INSERT INTO report_col_string VALUES('event_log.category', 0 , 'Unknown');
INSERT INTO report_col_string VALUES('event_log.category', 1 , 'Application');
INSERT INTO report_col_string VALUES('event_log.category', 2 , 'Socket');
INSERT INTO report_col_string VALUES('event_log.category', 3 , 'Message');
INSERT INTO report_col_string VALUES('event_log.category', 4 , 'Database');
INSERT INTO report_col_string VALUES('event_log.category', 5 , 'Exception');
INSERT INTO report_col_string VALUES('event_log.category', 6 , 'I/O');
INSERT INTO report_col_string VALUES('event_log.category', 7,  'System');
INSERT INTO report_col_string VALUES('event_log.category', 8,  'Security');
INSERT INTO report_col_string VALUES('event_log.category', 9,  'MAPI');
INSERT INTO report_col_string VALUES('event_log.category',10,  'Netware');
INSERT INTO report_col_string VALUES('event_log.category',11,  'ORA');

INSERT INTO report_col_string VALUES('event_log.category',12,  'RMAN');
INSERT INTO report_col_string VALUES('event_log.category',14,  'XML Parsing');
INSERT INTO report_col_string VALUES('event_log.category',15,  'DB2');
INSERT INTO report_col_string VALUES('event_log.category',16,  'ORACLE');

INSERT INTO report_col_string VALUES('connection_log.client_stop', 0 , '');
INSERT INTO report_col_string VALUES('connection_log.client_stop', -1 , 'Unknown');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 1 , 'User Stop');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 2 , 'Time limit');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 3 , 'Error limit');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 4 , 'Storage limit');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 5 , 'Shutdown');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 6 , 'Disconnect');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 7 , 'No resource');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 8 , 'Exception');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 9 , 'No connect');
INSERT INTO report_col_string VALUES('connection_log.client_stop',10 , 'Pre/Post failure');
INSERT INTO report_col_string VALUES('connection_log.client_stop',11 , 'Synchronization');
INSERT INTO report_col_string VALUES('connection_log.client_stop',12 , 'No share');
INSERT INTO report_col_string VALUES('connection_log.client_stop',15 , 'Could not allocate space for database');
INSERT INTO report_col_string VALUES('connection_log.client_stop',18 , 'Locked');
INSERT INTO report_col_string VALUES('connection_log.client_stop',19 , 'Upgrade stop');
INSERT INTO report_col_string VALUES('connection_log.client_stop',20 , 'Quota reached');
INSERT INTO report_col_string VALUES('connection_log.client_stop',21 , 'Quota reached');
INSERT INTO report_col_string VALUES('connection_log.client_stop',22 , 'Failed');
INSERT INTO report_col_string VALUES('connection_log.client_stop',23 , 'Unexpected stop');
INSERT INTO report_col_string VALUES('connection_log.client_stop',24 , 'Not allowed');
INSERT INTO report_col_string VALUES('connection_log.client_stop',25 , 'No enough disk space');
INSERT INTO report_col_string VALUES('connection_log.client_stop',26 , 'No local storage path');
INSERT INTO report_col_string VALUES('connection_log.client_stop',27 , 'Fatal Error');
INSERT INTO report_col_string VALUES('connection_log.client_stop',30 , 'DS-System Requested Stop');

DROP TABLE report_views_tables;
DROP TABLE report_views;
CREATE TABLE report_views(
    view_id      int PRIMARY KEY,
    view_name    varchar(100) NOT NULL UNIQUE,
    view_from    text
);

CREATE TABLE report_views_tables(
    view_id           int,
    table_alias       varchar(100) NOT NULL,
    table_realname    varchar(100) NOT NULL
);

DROP TABLE report_views_columns;
CREATE TABLE report_views_columns(
    column_name      varchar(100)  NOT NULL,
    column_table     varchar(100) NOT NULL,
    column_define    text NOT NULL,
    column_type      varchar(100) NOT NULL,
    column_sortable  int  NOT NULL,
    column_filter    int  NOT NULL,
    column_desc      varchar(100) NOT NULL,
    column_id        SERIAL PRIMARY KEY
);

-- table var-data, service provider info.
INSERT INTO report_views_columns VALUES('provider_name',        'var_data',   'var_data.company_name',   'string', 0, 0, 'Service Provider''s Company Name');
INSERT INTO report_views_columns VALUES('provider_addr1',       'var_data',   'var_data.addr1',          'string', 0, 0, 'Service Provider''s Address Line 1');
INSERT INTO report_views_columns VALUES('provider_addr2',       'var_data',   'var_data.addr2',          'string', 0, 0, 'Service Provider''s Address Line 2');
INSERT INTO report_views_columns VALUES('provider_city',        'var_data',   'var_data.city',           'string', 0, 0, 'Service Provider''s City');
INSERT INTO report_views_columns VALUES('provider_contact',     'var_data',   'var_data.contact',        'string', 0, 0, 'Service Provider''s Contact');
INSERT INTO report_views_columns VALUES('provider_country_code','var_data',   'var_data.country',        'string', 0, 0, 'Service Provider''s Country Code');
INSERT INTO report_views_columns VALUES('provider_country_name','var_data',   '(select country_name from countries where countries.country_code=var_data.country)',  'string', 0, 0, 'Service Provider''s Country Name');
INSERT INTO report_views_columns VALUES('provider_email',       'var_data',   'var_data.email_addr',     'string', 0, 0, 'Service Provider''s EMail Address');
INSERT INTO report_views_columns VALUES('provider_fax',         'var_data',   'var_data.fax',            'string', 0, 0, 'Service Provider''s Fax');
INSERT INTO report_views_columns VALUES('provider_phone',       'var_data',   'var_data.phone',          'string', 0, 0, 'Service Provider''s Phone');
INSERT INTO report_views_columns VALUES('provider_zipcode',     'var_data',   'var_data.postal_zip',     'string', 0, 0, 'Service Provider''s Zipcode');
INSERT INTO report_views_columns VALUES('provider_prov_code',   'var_data',   'var_data.prov_state',     'string', 0, 0, 'Service Provider''s Province/State Code');
INSERT INTO report_views_columns VALUES('provider_prov_name',   'var_data',   '(select province_name from provinces where provinces.province_code=var_data.prov_state and provinces.country_code=var_data.country)', 'string', 0, 0, 'Service Provider''s Province/State Name');
INSERT INTO report_views_columns VALUES('provider_computername','var_data',   ':ComputerName',           'string', 0, 0, 'DS-System Computer Name');
INSERT INTO report_views_columns VALUES('provider_brandingfile','var_data',   ':BrandingFile',           'string', 0, 0, 'Service Provider''s Branding File');

-- customer table
INSERT INTO report_views_columns VALUES('customer_account_id',   'customer',  'customer.account_id',         'int',    0, 0, 'Customer''s Account ID');
INSERT INTO report_views_columns VALUES('customer_account_num',  'customer',  'customer.account_num',        'string', 1, 2004, 'Customer''s Account Number');
INSERT INTO report_views_columns VALUES('customer_account_name', 'customer',  'customer.company_name',       'string', 1, 0, 'Customer''s Company Name');
INSERT INTO report_views_columns VALUES('customer_contact',      'customer',  'customer.contact',            'string', 0, 0, 'Customer''s Contact');
INSERT INTO report_views_columns VALUES('customer_loc_id',       'customer',  'customer.location_id',        'int',    0, 0, 'Customer''s location id');

-- customer's location
INSERT INTO report_views_columns VALUES('customer_loc_name',    'cust_loc',  'cust_loc.name',        'string', 0, 0, 'Customer''s location name');
INSERT INTO report_views_columns VALUES('customer_addr1',       'cust_loc',  'cust_loc.addr1',       'string', 0, 0, 'Customer''s addr line 1');
INSERT INTO report_views_columns VALUES('customer_addr2',       'cust_loc',  'cust_loc.addr2',       'string', 0, 0, 'Customer''s addr line 2');
INSERT INTO report_views_columns VALUES('customer_city',        'cust_loc',  'cust_loc.city',        'string', 0, 0, 'Customer''s city');
INSERT INTO report_views_columns VALUES('customer_phone',       'cust_loc',  'cust_loc.phone',       'string', 0, 0, 'Customer''s phone');
INSERT INTO report_views_columns VALUES('customer_fax',         'cust_loc',  'cust_loc.fax',         'string', 0, 0, 'Customer''s fax');
INSERT INTO report_views_columns VALUES('customer_email',       'cust_loc',  'cust_loc.email_addr',  'string', 0, 0, 'Customer''s E-Mail');
INSERT INTO report_views_columns VALUES('customer_prov_code',   'cust_loc',  'cust_loc.prov_state',  'string', 0, 0, 'Customer''s Province/State code');
INSERT INTO report_views_columns VALUES('customer_prov_name',   'cust_loc',  '(select province_name from provinces where provinces.province_code=cust_loc.prov_state and provinces.country_code=cust_loc.country)', 'string', 0, 0, 'Customer''s Province/State Name');
INSERT INTO report_views_columns VALUES('customer_zipcode',     'cust_loc',  'cust_loc.postal_zip',  'string', 0, 0, 'Customer''s postal code');
INSERT INTO report_views_columns VALUES('customer_country_code','cust_loc',  'cust_loc.country',     'string', 0, 0, 'Customer''s country code');
INSERT INTO report_views_columns VALUES('customer_country_name','cust_loc',  '(select country_name from countries where countries.country_code=cust_loc.country)',  'string', 0, 0, 'Customer''s Country Name');

-- customer quota
INSERT INTO report_views_columns VALUES('customer_storage_quota',      'customer_quota',  '(case when ((customer_quota.flag & 1)!=0) then customer_quota.quota else 0 end)',  'int', 0, 0, 'Customer''s storage quota');
INSERT INTO report_views_columns VALUES('customer_quota_unit',         'customer_quota',  '(select column_string from report_col_string where column_name=''quota_unit'' and column_value=customer_quota.quota_unit)',  'string', 0, 0, 'Customer''s storage quota unit');
INSERT INTO report_views_columns VALUES('customer_quota_basedon',      'customer_quota',  '(select column_string from report_col_string where column_name=''customer_quota.flag2'' and column_value=(customer_quota.flag & 2))',  'string', 0, 0, 'Customer''s storage quota calculation method');

-- ds- client table.
INSERT INTO report_views_columns VALUES('box_id',                'dsbox',  'dsbox.box_id',              'int',      0, 0, 'DS-Client ID');
INSERT INTO report_views_columns VALUES('box_number',            'dsbox',  'dsbox.dsbox_snum',          'string',   1, 2005, 'DS-Client Number');
INSERT INTO report_views_columns VALUES('box_description',       'dsbox',  'dsbox.description',         'string',   0, 0, 'DS-Client description');
INSERT INTO report_views_columns VALUES('box_contact',           'dsbox',  'dsbox.contact',             'string',   0, 0, 'DS-Client contact');
INSERT INTO report_views_columns VALUES('box_service_start_date','dsbox',  'dsbox.service_start_date',  'date',     0, 0, 'DS-Client service start date');
INSERT INTO report_views_columns VALUES('box_service_end_date',  'dsbox',  'dsbox.service_end_date',    'date',     0, 0, 'DS-Client service end date');
INSERT INTO report_views_columns VALUES('box_creation_date',     'dsbox',  'dsbox.creation_date',       'date',     1, 1, 'DS-Client creation date');
INSERT INTO report_views_columns VALUES('box_activation_date',   'dsbox',  'dsbox.activation_date',     'datetime', 0, 0, 'DS-Client activation date');
INSERT INTO report_views_columns VALUES('box_storage_group_id',  'dsbox',  'dsbox.ext_group_id',        'int',      0, 0, 'DS-Client storage group id.');
INSERT INTO report_views_columns VALUES('box_storage_group_name','dsbox',  '(select ext_group_name from storage_groups where storage_groups.ext_group_id = dsbox.ext_group_id)',  'string', 0, 0, 'DS-Client storage group name.');
INSERT INTO report_views_columns VALUES('box_loc_id',            'dsbox',  'dsbox.location_id',         'int',      0, 0, 'DS-Client location id');
INSERT INTO report_views_columns VALUES('box_show_stored_size',  'dsbox',  '(case when ((dsbox.flags & 1048576)!=0) then 1 else 0 end)',  'int', 0, 0, 'Allow DS-Client show stored size on backup set report');
INSERT INTO report_views_columns VALUES('box_status',            'dsbox',  'dsbox.status',              'int',      0, 2010, 'DS-Client status');
INSERT INTO report_views_columns VALUES('box_status_name',       'dsbox',  '(select column_string from report_col_string where column_name=''dsbox.status'' and column_value = dsbox.status)',  'string', 1, 0, 'DS-Client status name');
INSERT INTO report_views_columns VALUES('box_bandwidth_to_sys',  'dsbox',  '(select limit_tosystem from bandwidth where box_id = dsbox.box_id)',  'int', 0, 0, 'DS-Client bandwitdh limitation (to system)');
INSERT INTO report_views_columns VALUES('box_bandwidth_to_clnt', 'dsbox',  '(select limit_toclient from bandwidth where box_id = dsbox.box_id)',  'int', 0, 0, 'DS-Client bandwidth limitation (to client)');
INSERT INTO report_views_columns VALUES('box_req_registration',  'dsbox',  '(case when ((dsbox.flags & 2)!=0) then 1 else 0 end)',  'int', 0, 0, 'DS-Client require registration');

-- ds-client quota
INSERT INTO report_views_columns VALUES('box_storage_quota', 'dsbox_quota',  '(case when ((dsbox_quota.flag & 256)!=0) then dsbox_quota.quota else 0 end)',  'int', 0, 0, 'DS-Client storage quota');
INSERT INTO report_views_columns VALUES('box_quota_unit',    'dsbox_quota',  '(select column_string from report_col_string where column_name=''quota_unit'' and column_value=dsbox_quota.quota_unit)',  'string', 0, 0, 'DS-Client storage quota unit');
INSERT INTO report_views_columns VALUES('box_quota_basedon', 'dsbox_quota',  '(select column_string from report_col_string where column_name=''dsbox_quota.flag40'' and column_value=(dsbox_quota.flag & 64))',  'string', 0, 0, 'DS-Client storage quota calculation method');

-- ds-client size.
INSERT INTO report_views_columns VALUES('box_protected_size',      'dsbox_size',  'dsbox_size.prot_size',    'double', 1, 0, 'DS-Client protected size');
INSERT INTO report_views_columns VALUES('box_stored_size',         'dsbox_size',  '(dsbox_size.ds_size+dsbox_size.lib_size)',  'double', 1, 0, 'DS-Client stored size');
INSERT INTO report_views_columns VALUES('box_ds_size',             'dsbox_size',  'dsbox_size.ds_size',      'double', 0, 0, 'DS-Client DS Size');
INSERT INTO report_views_columns VALUES('box_blm_protected_size',  'dsbox_size',  'dsbox_size.blm_prot_size','double', 0, 0, 'DS-Client BLM Protected Size');
INSERT INTO report_views_columns VALUES('box_blm_stored_size',     'dsbox_size',  'dsbox_size.blm_ds_size',  'double', 0, 0, 'DS-Client BLM stored size');
INSERT INTO report_views_columns VALUES('box_protected_size_avg',  'dsbox_size',  'dsbox_size.prot_avg',     'double', 0, 0, 'DS-Client protected size (average)');
INSERT INTO report_views_columns VALUES('box_stored_size_avg',     'dsbox_size',  'dsbox_size.ds_avg',       'double', 0, 0, 'DS-Client stored size (average)');
INSERT INTO report_views_columns VALUES('box_blm_protected_avg',   'dsbox_size',  'dsbox_size.blm_prot_size_avg',  'double', 0, 0, 'DS-Client BLM Protected Size (average)');
INSERT INTO report_views_columns VALUES('box_blm_stored_avg',      'dsbox_size',  'dsbox_size.blm_ds_size_avg',    'double', 0, 0, 'DS-Client BLM stored size (average)');
INSERT INTO report_views_columns VALUES('box_protected_size_peak', 'dsbox_size',  'dsbox_size.prot_max',           'double', 0, 0, 'DS-Client protected size (peak)');
INSERT INTO report_views_columns VALUES('box_stored_size_peak',    'dsbox_size',  'dsbox_size.ds_max',             'double', 0, 0, 'DS-Client stored size (peak)');
INSERT INTO report_views_columns VALUES('box_blm_protected_peak',  'dsbox_size',  'dsbox_size.blm_prot_size_max',  'double', 0, 0, 'DS-Client BLM Protected Size (peak)');
INSERT INTO report_views_columns VALUES('box_blm_stored_peak',     'dsbox_size',  'dsbox_size.blm_ds_size_max',    'double', 0, 0, 'DS-Client BLM stored size (peak)');

-- ds-client location
INSERT INTO report_views_columns VALUES('box_loc_name',    'box_loc',  'box_loc.name',       'string', 0, 0, 'DS-Client location name');
INSERT INTO report_views_columns VALUES('box_addr1',       'box_loc',  'box_loc.addr1',      'string', 0, 0, 'DS-Client addr line 1');
INSERT INTO report_views_columns VALUES('box_addr2',       'box_loc',  'box_loc.addr2',      'string', 0, 0, 'DS-Client addr line 2');
INSERT INTO report_views_columns VALUES('box_city',        'box_loc',  'box_loc.city',       'string', 0, 0, 'DS-Client city');
INSERT INTO report_views_columns VALUES('box_phone',       'box_loc',  'box_loc.phone',      'string', 0, 0, 'DS-Client phone');
INSERT INTO report_views_columns VALUES('box_fax',         'box_loc',  'box_loc.fax',        'string', 0, 0, 'DS-Client fax');
INSERT INTO report_views_columns VALUES('box_email',       'box_loc',  'box_loc.email_addr', 'string', 0, 0, 'DS-Client E-Mail');
INSERT INTO report_views_columns VALUES('box_prov_code',   'box_loc',  'box_loc.prov_state', 'string', 0, 0, 'DS-Client Province/State code');
INSERT INTO report_views_columns VALUES('box_prov_name',   'box_loc',  '(select province_name from provinces where provinces.province_code=box_loc.prov_state and provinces.country_code=box_loc.country)', 'string', 0, 0, 'DS-Client Province/State Name');
INSERT INTO report_views_columns VALUES('box_zipcode',     'box_loc',  'box_loc.postal_zip', 'string', 0, 0, 'DS-Client postal code');
INSERT INTO report_views_columns VALUES('box_country_code','box_loc',  'box_loc.country',    'string', 0, 0, 'DS-Client country code');
INSERT INTO report_views_columns VALUES('box_country_name','box_loc',  '(select country_name from countries where countries.country_code=box_loc.country)',  'string', 0, 0, 'DS-Client Country Name');

-- backup set.
INSERT INTO report_views_columns VALUES('bset_id',            'backup_sets',  'backup_sets.set_id',        'int',     0, 2012, 'Backup set system side set id');
INSERT INTO report_views_columns VALUES('bset_req_id',        'backup_sets',  'backup_sets.req_id',        'int',     0, 0, 'Backup set req id (client side)');
INSERT INTO report_views_columns VALUES('bset_name',          'backup_sets',  'backup_sets.set_name',      'string',  1, 0, 'Backup set name (include computer name and user name)');
INSERT INTO report_views_columns VALUES('bset_last_backup_time','backup_sets',  'backup_sets.lastbkup_time', 'datetime',1, 0, 'Backup set last backup time');
INSERT INTO report_views_columns VALUES('bset_set_type',      'backup_sets',  'backup_sets.set_type',      'int',     0, 0, 'Backup set type');
INSERT INTO report_views_columns VALUES('bset_set_type_name', 'backup_sets',  '(select column_string from report_col_string where column_name=''backup_sets.set_type'' and column_value=backup_sets.set_type)',      'string',     1, 0, 'Backup set type');

-- backup set size
INSERT INTO report_views_columns VALUES('bset_ds_size',           'dsset_size',  'dsset_size.ds_size',       'double', 0, 0, 'Backup set DS Size');
INSERT INTO report_views_columns VALUES('bset_protected_size',    'dsset_size',  'dsset_size.prot_size',     'double', 1, 0, 'Backup set Protected Size');
INSERT INTO report_views_columns VALUES('bset_stored_size',       'dsset_size',  '(dsset_size.ds_size+dsset_size.lib_size)','double', 1, 0, 'Backup set stored size');
INSERT INTO report_views_columns VALUES('bset_blm_stored_size',   'dsset_size',  'dsset_size.blm_ds_size',   'double', 0, 0, 'Backup set BLM stored size');
INSERT INTO report_views_columns VALUES('bset_blm_protected_size','dsset_size',  'dsset_size.blm_prot_size', 'double', 0, 0, 'Backup set BLM protected size');

-- connection log.
INSERT INTO report_views_columns VALUES('log_connect_time',      'connection_log',   'connection_log.connect_time',      'datetime', 0, 0, 'Connection Log connect time');
INSERT INTO report_views_columns VALUES('log_start_session_time','connection_log',   'connection_log.start_session_time','datetime', 1, 3, 'Connection Log start session time');
INSERT INTO report_views_columns VALUES('log_end_session_time',  'connection_log',   'connection_log.end_session_time',  'datetime', 0, 0, 'Connection Log end session time');
INSERT INTO report_views_columns VALUES('log_files',             'connection_log',   'connection_log.files',             'int',      0, 0,      'Connection Log Files');
INSERT INTO report_views_columns VALUES('log_online_delta',      'connection_log',   'connection_log.online_delta',      'double',   0, 0, 'Connection Log Online Delta');
INSERT INTO report_views_columns VALUES('log_online_amount',     'connection_log',   'connection_log.online_amount',     'double',   0, 0, 'Connection Log Online Amount');
INSERT INTO report_views_columns VALUES('log_transmit_amount' ,  'connection_log',   'connection_log.transmit_amount',   'double',   0, 0, 'Connection Log Transmit Amount');
INSERT INTO report_views_columns VALUES('log_arch_amount',       'connection_log',   'connection_log.arch_amount',       'double',   0, 0, 'Connection Log Archive Amount');
INSERT INTO report_views_columns VALUES('log_session_type',      'connection_log',   'connection_log.session_type',      'int',      1, 2013, 'Connection Log Session Type');
INSERT INTO report_views_columns VALUES('log_session_type_name', 'connection_log',   '(select column_string from report_col_string where column_name=''connection_log.session_type'' and column_value=connection_log.session_type)',      'string',      1,0, 'Connection Log Session Type Name');
INSERT INTO report_views_columns VALUES('log_session_id',        'connection_log',   'connection_log.session_id',        'int',      0, 0, 'Connection Log Session ID');
INSERT INTO report_views_columns VALUES('log_description',       'connection_log',   'connection_log.description',       'string',   0, 0, 'Connection Log Description');
INSERT INTO report_views_columns VALUES('log_dsdelta_amount',    'connection_log',   'connection_log.dsdelta_amount',    'double',   0, 0, 'Connection Log DSDelta Amount');
INSERT INTO report_views_columns VALUES('log_lib_amount',        'connection_log',   'connection_log.lib_amount',        'double',   0, 0, 'Connection Log Lib Amount');
INSERT INTO report_views_columns VALUES('log_new_amount',        'connection_log',   'connection_log.new_amount',        'double',   0, 0, 'Connection Log New Amount');
INSERT INTO report_views_columns VALUES('log_new_files',         'connection_log',   'connection_log.new_files',         'int',      0, 0, 'Connection Log New Files');
INSERT INTO report_views_columns VALUES('log_cluster_id',        'connection_log',   'connection_log.cluster_id',        'int',      0, 2014, 'Connection Log Cluster ID');
INSERT INTO report_views_columns VALUES('log_system_addr',       'connection_log',   'connection_log.system_address',    'string',   0, 0, 'Connection Log Systm Address');
INSERT INTO report_views_columns VALUES('log_client_stop',       'connection_log',   'connection_log.client_stop',       'int',      0, 0, 'Connection Log Client Stop Reason');
INSERT INTO report_views_columns VALUES('log_client_stop_desc',  'connection_log',   '(select column_string from report_col_string where column_name=''connection_log.client_stop'' and column_value=connection_log.client_stop)',       'String',      0, 0, 'Connection Log Client Stop Reason String');
INSERT INTO report_views_columns VALUES('log_errors',            'connection_log',   'connection_log.status',            'int',      0, 0, 'Connection Log Status');
INSERT INTO report_views_columns VALUES('log_completion',        'connection_log',   'connection_log.completion',        'int',      0, 0, 'Connection Log Completion');

-- event log
INSERT INTO report_views_columns VALUES('event_id',           'event_log',  'event_log.ev_id',    'int',      0, 0, 'Event ID');
INSERT INTO report_views_columns VALUES('event_type',         'event_log',  'event_log.type',     'int',      0, 5, 'Event Type');
INSERT INTO report_views_columns VALUES('event_type_name',    'event_log',  '(select column_string from report_col_string where column_name=''event_log.type'' and column_value=event_log.type)',     'string',      1,0, 'Event Type Name');
INSERT INTO report_views_columns VALUES('event_time',         'event_log',  'event_log.ev_time',  'datetime', 1, 3, 'Event Time');
INSERT INTO report_views_columns VALUES('event_category',     'event_log',  'event_log.category', 'int',      0, 6, 'Event Category');
INSERT INTO report_views_columns VALUES('event_category_name','event_log',  '(select column_string from report_col_string where column_name=''event_log.category'' and column_value=event_log.category)', 'string',   1, 0, 'Event Category Name');
INSERT INTO report_views_columns VALUES('event_error_num',    'event_log',  'event_log.error',    'int',      0, 0, 'Event Error Number');
INSERT INTO report_views_columns VALUES('event_text',         'event_log',  'event_log.ev_text',  'string',   0, 0, 'Event Description');
INSERT INTO report_views_columns VALUES('event_user',         'event_log',  'event_log.userid',   'string',   1, 7, 'Event User Name');
INSERT INTO report_views_columns VALUES('event_ex_text',      'event_log',  'event_log.ex_text',  'string',   0, 0, 'Event Extra Text');

--Customers
INSERT INTO report_views(view_id, view_name, view_from) 
VALUES (3, 'customers', 'var_data, customer '
  ' left join location cust_loc              ON cust_loc.id = customer.location_id '
  ' left join customer_quota                 ON customer.account_id = customer_quota.account_id '
);

--DS-Client
INSERT INTO report_views(view_id, view_name, view_from)
VALUES (4, 'ds_clients', 'var_data, dsbox '
  ' left join customer                       ON dsbox.account_num = customer.account_num '
  ' left join location cust_loc              ON cust_loc.id = customer.location_id '
  ' left join customer_quota                 ON customer.account_id = customer_quota.account_id '
  ' left join dsbox_quota                    ON dsbox.box_id      = dsbox_quota.box_id '
  ' left join dsbox_size                     ON dsbox.box_id      = dsbox_size.box_id '
  ' left join location box_loc               ON dsbox.location_id = box_loc.id '
);
-- Backup Sets
INSERT INTO report_views(view_id, view_name, view_from)
VALUES (5, 'backup_sets', 'var_data, backup_sets '
  ' left join dsset_size         ON  (dsset_size.box_id = backup_sets.box_id and dsset_size.req_id = backup_sets.req_id) '
  ' left join dsbox              ON  dsbox.box_id = backup_sets.box_id '
  ' left join dsbox_quota        ON dsbox.box_id = dsbox_quota.box_id '
  ' left join customer           ON dsbox.account_num = customer.account_num '
  ' left join customer_quota     ON customer.account_id = customer_quota.account_id '
);
--Activity Log

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (6, 'activity_logs', 'var_data, connection_log '
  ' left join backup_sets ON backup_sets.set_id = connection_log.set_id '
  ' left join dsbox       ON dsbox.dsbox_snum = connection_log.dsbox_snum '
  ' left join customer    ON dsbox.account_num = customer.account_num '
);

--Event Log

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (7, 'event_logs', 'var_data, event_log '
  ' left join connection_log ON event_log.ex_long = connection_log.session_id '
  ' left join backup_sets on backup_sets.set_id = connection_log.set_id '
  ' left join dsbox on dsbox.dsbox_snum = connection_log.dsbox_snum '
  ' left join customer on dsbox.account_num = customer.account_num '
);

--The table report_views_tables determines what tables available for one view.
INSERT INTO report_views_tables VALUES(3, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(3, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(3, 'cust_loc',       'location');
INSERT INTO report_views_tables VALUES(3, 'customer_quota', 'customer_quota');

INSERT INTO report_views_tables VALUES(4, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(4, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(4, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(4, 'cust_loc',       'location');
INSERT INTO report_views_tables VALUES(4, 'customer_quota', 'customer_quota');
INSERT INTO report_views_tables VALUES(4, 'dsbox_quota',    'dsbox_quota');
INSERT INTO report_views_tables VALUES(4, 'dsbox_size',     'dsbox_size');
INSERT INTO report_views_tables VALUES(4, 'box_loc',        'location');

INSERT INTO report_views_tables VALUES(5, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(5, 'backup_sets',    'backup_sets');
INSERT INTO report_views_tables VALUES(5, 'dsset_size',     'dsset_size');
INSERT INTO report_views_tables VALUES(5, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(5, 'dsbox_quota',    'dsbox_quota');
INSERT INTO report_views_tables VALUES(5, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(5, 'customer_quota', 'customer_quota');

INSERT INTO report_views_tables VALUES(6, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(6, 'connection_log', 'connection_log');
INSERT INTO report_views_tables VALUES(6, 'backup_sets',    'backup_sets');
INSERT INTO report_views_tables VALUES(6, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(6, 'customer',       'customer');

INSERT INTO report_views_tables VALUES(7, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(7, 'event_log',      'event_log');
INSERT INTO report_views_tables VALUES(7, 'connection_log', 'connection_log');
INSERT INTO report_views_tables VALUES(7, 'backup_sets',    'backup_sets');
INSERT INTO report_views_tables VALUES(7, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(7, 'customer',       'customer');


ALTER TABLE ds_data ADD billing_option int;
-- billing_option is 0 if ds-system has billing data to import to ds-billing.
UPDATE ds_data SET billing_option = 0;

UPDATE ds_data SET db_number = 118 WHERE db_number = 117;

