-- Add new fields to table dsset_healing
ALTER TABLE dsset_healing ADD excluded int; -- non-zero - excluded from healing
ALTER TABLE dsset_healing ADD last_end int; -- last healing end time
ALTER TABLE dsset_healing ADD last_try int; -- last healing try time
ALTER TABLE dsset_healing ADD original_priority int;
ALTER TABLE dsset_healing ADD description varchar(1024);

ALTER TABLE dsset_healing ALTER COLUMN priority DROP NOT NULL;

-- Convert 0-99 priority levels to "Low-Medium-High" priority levels
UPDATE dsset_healing SET original_priority = 1, priority = 1 
       WHERE priority <> 0;

-- Initialize HealingDescription
UPDATE dsset_healing SET description = 'Healing process was interrupted.' 
       WHERE healing_start > healing_end;

-- Initialize last_end and last_try
UPDATE dsset_healing SET last_end = healing_end, last_try = healing_start;

-- AutoStart Self-healing configuration
ALTER TABLE ds_config ADD start_healing int;
UPDATE ds_config SET start_healing = 0;

UPDATE ds_data SET db_number = 12 WHERE db_number = 11;
