
CREATE TABLE lock_schedule (
  lock_sched_id   INT PRIMARY KEY,
  lock_sched_name VARCHAR(1024)
);

INSERT INTO lock_schedule (lock_sched_id, lock_sched_name) VALUES (0, '<DEFAULT>');

CREATE TABLE lock_sched_const (
  lock_sched_const_id INT PRIMARY KEY,
  lock_sched_id       INT CONSTRAINT lock_sched_id_belongs_lock_schedule REFERENCES lock_schedule,
  lock_flag           INT,
  from_time           INT,
  to_time             INT
);

-- Everyday, 0:00AM to 11:59PM
INSERT INTO lock_sched_const (lock_sched_const_id, lock_sched_id, lock_flag, from_time, to_time)
       VALUES (1, 0, 127, 0, 1439);

-- Weekday, 8:00AM to 6:00PM
INSERT INTO lock_sched_const (lock_sched_const_id, lock_sched_id, lock_flag, from_time, to_time)
       VALUES (2, 0, 31, 480, 1080);

CREATE TABLE lock_sched_detail (
  lock_sched_const_id INT CONSTRAINT lock_sched_const_id_belongs_lock_sched_const REFERENCES lock_sched_const,
  lock_type           INT,
  lock_priority       INT
);

-- default priority
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 1, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 2, 12);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 3, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 4, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 5, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 6, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 7, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 8, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 9, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 10, 10);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 11, 11);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 12, 1);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 13, 6);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 14, 6);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 15, 1);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 16, 4);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 17, 5);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 18, 14);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 19, 7);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 21, 3);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 22, 1);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 23, 1);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 25, 13);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 26, 15);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 28, 9);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 30, 16);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 31, 17);

-- give CDP backup priority during the business hours
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (2, 2, 2);

ALTER TABLE dsbox ADD lock_sched_id INT;

ALTER TABLE ds_sequences ADD lock_sched_id INT;
ALTER TABLE ds_sequences ADD lock_sched_const_id INT;

UPDATE ds_data SET db_number = 140 WHERE db_number = 139;
UPDATE ds_data SET db_number = -140 WHERE db_number = -139;
