/* Lock customers/clients for deletion (i.e. backup data is
 * in append-only, like for legal locking)
 */
CREATE TABLE delete_lock (
  account_id   INT NOT NULL,           -- locked account
  box_id       INT NULL,               -- locked ds-client (or NULL if all)
  opertime     INT NOT NULL,           -- time locking applied
  userid       VARCHAR(256) NOT NULL,  -- who locked/unlocked
  description  VARCHAR(1024) NOT NULL, -- reason for the action
  state        INT NOT NULL,           -- 0/1 - locked/unlocked (active), 2/3 (locked/unlocked) - inactive

  FOREIGN KEY (account_id) REFERENCES customer ON DELETE CASCADE
);

CREATE UNIQUE INDEX idx_del_lock_acc_box_id ON delete_lock(account_id, box_id, opertime);
CREATE INDEX idx_del_lock_acc_opertime ON delete_lock(account_id, opertime);

UPDATE ds_data SET db_number = 163  WHERE db_number = 162;
UPDATE ds_data SET db_number = -163 WHERE db_number = -162;
