CREATE TABLE deltachain_config (
    deltachain_cfg_id     INT PRIMARY KEY,
    cfg_name              VARCHAR(1024)
);

CREATE TABLE deltachain_detail (
    deltachain_detail_id  SERIAL PRIMARY KEY,
    deltachain_cfg_id     INT,
    backup_type           INT,
    chain_length          INT
);

ALTER TABLE ds_sequences ADD deltachain_cfg_id INT;
ALTER TABLE customer ADD deltachain_cfg_id INT;
ALTER TABLE dsbox    ADD deltachain_cfg_id INT;

CREATE TABLE deltachain_change_log (
    account_id            INT,
    box_id                INT,
    set_id                INT,
    appl_id               INT,
    dir_id                INT
);
CREATE INDEX idx_deltachain_change_log ON deltachain_change_log(account_id, box_id, set_id);

ALTER TABLE backup_sets ADD last_delta_fix INT;

INSERT INTO schedule_details (schedule_type, detail_id, category, type_every, type_para, from_time,
            end_time, end_after, para1, para2, para3, allow_speed_control)
       VALUES (10, 1, 1, 1, 0, extract(epoch from timestamp '1994-05-14 09:00:00'),
               0, 0, 3, 3, 0, 0);

UPDATE ds_data SET db_number =  167 WHERE db_number =  166;
UPDATE ds_data SET db_number = -167 WHERE db_number = -166;

