CREATE TABLE vdr_machines (
    vm_id  integer NOT NULL,
    acc_id integer NOT NULL,
    box_id integer NOT NULL,
    req_id integer NOT NULL,
    set_id integer NOT NULL,
    vdr_id integer NOT NULL,
    esx_id integer NOT NULL,
    dir_id integer NOT NULL,
    config_id integer,
    datacenter VARCHAR(765) NOT NULL,
    host VARCHAR(765) NOT NULL,
    folder VARCHAR(765) NOT NULL,
    name VARCHAR(255) NOT NULL,
    flags integer,
    last_gen integer
);

ALTER TABLE ONLY vdr_machines
    ADD CONSTRAINT vdr_machines_pkey PRIMARY KEY (vm_id);
ALTER TABLE ONLY vdr_machines
    ADD CONSTRAINT vdr_machines_set_id_fkey FOREIGN KEY (set_id) REFERENCES backup_sets(set_id) ON DELETE CASCADE;

CREATE TABLE vdr_disks (
    disk_id  integer NOT NULL,
    vm_id integer NOT NULL,
    file_id integer NOT NULL,
    datastore VARCHAR(765) NOT NULL,
    name VARCHAR(765) NOT NULL 
);
ALTER TABLE ONLY vdr_disks
    ADD CONSTRAINT vdr_disks_pkey PRIMARY KEY (disk_id);
ALTER TABLE ONLY vdr_disks
    ADD CONSTRAINT vdr_disk_vm_id_fkey FOREIGN KEY (vm_id) REFERENCES vdr_machines(vm_id) ON DELETE CASCADE;

CREATE TABLE vdr_servers (
    server_id integer NOT NULL,
    name VARCHAR(765) NOT NULL,
    description VARCHAR(765) NOT NULL,
    addr VARCHAR(765) NOT NULL,
    port integer NOT NULL    
);
CREATE UNIQUE INDEX uname ON vdr_servers ( name );
CREATE UNIQUE INDEX udest ON vdr_servers ( addr,port );
ALTER TABLE ONLY vdr_servers
    ADD CONSTRAINT vdr_servers_pkey PRIMARY KEY (server_id);

CREATE TABLE vdr_esx (
    esx_id  integer NOT NULL,
    addr VARCHAR(765) NOT NULL,
    username VARCHAR(765) NOT NULL,
    psw VARCHAR(765) NOT NULL,
    type integer    
);
ALTER TABLE ONLY vdr_esx
    ADD CONSTRAINT vdr_esx_pkey PRIMARY KEY (esx_id);

UPDATE ds_data SET db_number = 176  WHERE db_number = 175;
UPDATE ds_data SET db_number = -176 WHERE db_number = -175;
