CREATE TABLE vdr_vbs_tmp (
    vbs_id            INT,
    acc_id            INT,
    box_id            INT,
    req_id            INT,
    set_id            INT,
    flags             INT,
    poweronprio_delay INT
);

INSERT INTO vdr_vbs_tmp(vbs_id, acc_id, box_id, req_id, set_id, flags, poweronprio_delay)
       SELECT vbs_id, acc_id, box_id, req_id, set_id, flags, poweronprio_delay FROM vdr_vbs;

CREATE TABLE vdr_machines_tmp (
    vm_id             INT,
    vbs_id            INT,
    vdr_id            INT,
    esx_id            INT,
    appl_id           INT,
    dir_id            INT,
    config_id         INT,
    datacenter        VARCHAR(765),
    host              VARCHAR(765),
    folder            VARCHAR(765),
    name              VARCHAR(255),
    flags             INT,
    last_gen          INT,
    poweron_priority  INT
);

INSERT INTO vdr_machines_tmp(vm_id, vbs_id, vdr_id, esx_id, appl_id, dir_id, config_id, datacenter,
       host, folder, name, flags, last_gen, poweron_priority)
       SELECT vm_id, vbs_id, vdr_id, esx_id, appl_id, dir_id, config_id, datacenter,
       host, folder, name, flags, last_gen, poweron_priority FROM vdr_machines;

CREATE TABLE vdr_disks_tmp (
    disk_id           INT,
    vm_id             INT,
    file_id           INT,
    datastore         VARCHAR(765),
    name              VARCHAR(765),
    disk_key          INT,
    change_id         VARCHAR(128),
    last_gen          INT
);

INSERT INTO vdr_disks_tmp(disk_id, vm_id, file_id, datastore, name, disk_key, change_id, last_gen)
       SELECT disk_id, vm_id, file_id, datastore, name, disk_key, change_id, last_gen FROM vdr_disks;

CREATE TABLE vdr_servers_tmp (
    server_id         INT,
    name              VARCHAR(765),
    description       VARCHAR(765),
    addr              VARCHAR(765),
    port              INT
);

INSERT INTO vdr_servers_tmp(server_id, name, description, addr, port)
       SELECT server_id, name, description, addr, port FROM vdr_servers;

CREATE TABLE vdr_esx_tmp (
    esx_id            INT,
    addr              VARCHAR(765),
    username          VARCHAR(765),
    psw               VARCHAR(765),
    type              INT
);

INSERT INTO vdr_esx_tmp(esx_id, addr, username, psw, type)
       SELECT esx_id, addr, username, psw, type FROM vdr_esx;

DROP TABLE vdr_esx;
DROP TABLE vdr_servers;
DROP TABLE vdr_disks;
DROP TABLE vdr_machines;
DROP TABLE vdr_vbs;

CREATE TABLE vdr_vbs (
    vbs_id            SERIAL PRIMARY KEY,
    acc_id            INT NOT NULL,
    box_id            INT NOT NULL,
    req_id            INT NOT NULL,
    set_id            INT NOT NULL,
    flags             INT,
    poweronprio_delay INT,
    FOREIGN KEY (set_id) REFERENCES backup_sets(set_id) ON DELETE CASCADE
);

INSERT INTO vdr_vbs(vbs_id, acc_id, box_id, req_id, set_id, flags, poweronprio_delay)
       SELECT vbs_id, acc_id, box_id, req_id, set_id, flags, poweronprio_delay FROM vdr_vbs_tmp;
SELECT setval('vdr_vbs_vbs_id_seq', (SELECT MAX(vbs_id) FROM vdr_vbs));

CREATE TABLE vdr_machines (
    vm_id             SERIAL PRIMARY KEY,
    vbs_id            INT NOT NULL,
    vdr_id            INT NOT NULL,
    esx_id            INT NOT NULL,
    appl_id           INT NOT NULL,
    dir_id            INT NOT NULL,
    config_id         INT,
    datacenter        VARCHAR(765) NOT NULL,
    host              VARCHAR(765) NOT NULL,
    folder            VARCHAR(765) NOT NULL,
    name              VARCHAR(255) NOT NULL,
    flags             INT,
    last_gen          INT,
    poweron_priority  INT,
    FOREIGN KEY (vbs_id) REFERENCES vdr_vbs(vbs_id) ON DELETE CASCADE
);

INSERT INTO vdr_machines(vm_id, vbs_id, vdr_id, esx_id, appl_id, dir_id, config_id, datacenter,
       host, folder, name, flags, last_gen, poweron_priority)
       SELECT vm_id, vbs_id, vdr_id, esx_id, appl_id, dir_id, config_id, datacenter,
       host, folder, name, flags, last_gen, poweron_priority FROM vdr_machines_tmp;
SELECT setval('vdr_machines_vm_id_seq', (SELECT MAX(vm_id) FROM vdr_machines));

CREATE TABLE vdr_disks (
    disk_id           SERIAL PRIMARY KEY,
    vm_id             INT NOT NULL,
    file_id           INT NOT NULL,
    datastore         VARCHAR(765) NOT NULL,
    name              VARCHAR(765) NOT NULL,
    disk_key          INT,
    change_id         VARCHAR(128),
    last_gen          INT,
    FOREIGN KEY (vm_id) REFERENCES vdr_machines(vm_id) ON DELETE CASCADE
);

INSERT INTO vdr_disks(disk_id, vm_id, file_id, datastore, name, disk_key, change_id, last_gen)
       SELECT disk_id, vm_id, file_id, datastore, name, disk_key, change_id, last_gen
       FROM vdr_disks_tmp;
SELECT setval('vdr_disks_disk_id_seq', (SELECT MAX(disk_id) FROM vdr_disks));

CREATE TABLE vdr_servers (
    server_id         SERIAL PRIMARY KEY,
    name              VARCHAR(765) NOT NULL,
    description       VARCHAR(765) NOT NULL,
    addr              VARCHAR(765) NOT NULL,
    port              INT NOT NULL    
);
CREATE UNIQUE INDEX uname ON vdr_servers ( name );
CREATE UNIQUE INDEX udest ON vdr_servers ( addr,port );

INSERT INTO vdr_servers(server_id, name, description, addr, port)
       SELECT server_id, name, description, addr, port FROM vdr_servers_tmp;
SELECT setval('vdr_servers_server_id_seq', (SELECT MAX(server_id) FROM vdr_servers));

CREATE TABLE vdr_esx (
    esx_id            SERIAL PRIMARY KEY,
    addr              VARCHAR(765) NOT NULL,
    username          VARCHAR(765) NOT NULL,
    psw               VARCHAR(765) NOT NULL,
    type              INT
);

INSERT INTO vdr_esx(esx_id, addr, username, psw, type)
       SELECT esx_id, addr, username, psw, type FROM vdr_esx_tmp;
SELECT setval('vdr_esx_esx_id_seq', (SELECT MAX(esx_id) FROM vdr_esx));

DROP TABLE vdr_esx_tmp;
DROP TABLE vdr_servers_tmp;
DROP TABLE vdr_disks_tmp;
DROP TABLE vdr_machines_tmp;
DROP TABLE vdr_vbs_tmp;

UPDATE ds_data SET db_number = 192 WHERE db_number = 191;
UPDATE ds_data SET db_number = -192 WHERE db_number = -191;
