ALTER TABLE ds_sequences ADD drill_id INT;

UPDATE ds_sequences SET drill_id = 0;

CREATE TABLE drill_log(
   drill_id    INT NOT NULL UNIQUE,
   box_id      INT NOT NULL,
   req_id      INT NOT NULL,
   commit_date INT, 
   start_date  INT,
   end_date    INT,
   capacity_allocated float,
   capacity_used float,
   flags INT
);	   
CREATE INDEX drilllog_id                  ON drill_log(drill_id);
CREATE INDEX drilllog_start_time          ON drill_log(start_date, drill_id);
CREATE INDEX drilllog_box_req_start_time  ON drill_log(box_id, req_id, start_date, drill_id);

ALTER TABLE restore_log ADD flags int NULL;
ALTER TABLE restore_log ADD reason int NULL;
ALTER TABLE restore_log ADD term_end int NULL;

--Recovery Drill activated
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (14, 0, 0, 0, 0, 0, 0, 0, 0, 0);

UPDATE ds_data SET db_number = 197 WHERE db_number = 196;
UPDATE ds_data SET db_number = -197 WHERE db_number = -196;
