
-- drop the old pub_resume, we don't need to save the data
DROP TABLE pub_resume CASCADE;

-- create new pub_resume table
CREATE TABLE pub_resume (
       idx_id               SERIAL PRIMARY KEY,
       resume_type          int NOT NULL,
       resume_len           int NOT NULL,
       resume_buff          bytea
);

-- change first_sig and full_sig columns in table private_files and public_files
-- from varchar(120) to bytea

CREATE TABLE private_files1 (
       idx_id               int NOT NULL PRIMARY KEY,
       first_sig            bytea NOT NULL,
       full_sig             bytea NOT NULL,
       account_id           int NOT NULL,
       box_id               int NOT NULL,
       req_id               int NULL,
       bckappl_id           int NOT NULL,
       dir_id               int NOT NULL,
       file_id              int NOT NULL,
       gen_id               int NOT NULL,
       add_date             int NOT NULL,
       file_size            bigint NOT NULL,
       backup_time          int -- Backup Time
);

UPDATE private_files1 SET idx_id = nextval('private_files_idx_id_seq');
ALTER TABLE private_files1 ALTER COLUMN idx_id SET DEFAULT
            nextval('private_files_idx_id_seq');

INSERT INTO private_files1(first_sig, full_sig, account_id, box_id, req_id,
            bckappl_id, dir_id, file_id, gen_id, add_date, file_size,
            backup_time) SELECT decode(cast(first_sig as text),'escape'),
            decode(cast(full_sig as text),'escape'), account_id, box_id,
            req_id, bckappl_id, dir_id, file_id, gen_id, add_date, file_size,
            backup_time FROM private_files;

DROP TABLE private_files CASCADE;

ALTER TABLE private_files1 RENAME TO private_files;

CREATE INDEX idx_private_files_first ON private_files (first_sig, file_size);
CREATE INDEX idx_private_files_fulls ON private_files (full_sig);
CREATE INDEX idx_private_files_id ON private_files (account_id, box_id,
             req_id, dir_id, file_id);
CREATE INDEX idx_private_files_add_date ON private_files (add_date);

CREATE TABLE public_files1 (
       first_sig            bytea NOT NULL,
       full_sig             bytea NOT NULL,
       pub_id               INT NOT NULL PRIMARY KEY,
       pub_date             int NOT NULL,
       status               int NOT NULL,
       box_id               int NOT NULL,
       account_id           int NOT NULL,
       file_size            bigint NOT NULL,
       ds_size              bigint NULL
);

INSERT INTO public_files1(first_sig, full_sig, pub_id, pub_date, status,
            box_id, account_id, file_size, ds_size) SELECT 
            decode(cast(first_sig as text),'escape'),
            decode(cast(full_sig as text),'escape'), pub_id, pub_date,
            status, box_id, account_id, file_size, ds_size FROM public_files;

DROP TABLE public_files CASCADE;

ALTER TABLE public_files1 RENAME TO public_files;
CREATE INDEX idx_public_files_fulls ON public_files ( full_sig);
CREATE INDEX idx_public_files_first ON public_files ( first_sig, file_size);

-- Update the db version
UPDATE ds_data SET db_number = 24 WHERE db_number = 23;
