-- add lang in ds_data table
ALTER TABLE ds_data ADD COLUMN lang varchar(10);
UPDATE ds_data SET lang = 'en';

-- add sales_flag to sale_reps for InHouse Account
ALTER TABLE sale_reps ADD COLUMN sales_flag int;
UPDATE sale_reps SET sales_flag = 1 WHERE name = '-House Account-' OR name = '- Hauskonto -';

-- fix foreign key in dsset_size
CREATE TABLE tbl_tmp (
       box_id      int NOT NULL,
       req_id      int NOT NULL,
       ds_size     float NULL,
       prot_size   float NULL
);
INSERT INTO tbl_tmp(box_id, req_id, ds_size, prot_size) SELECT
       box_id, req_id, ds_size, prot_size FROM dsset_size;

DROP TABLE dsset_size;
ALTER TABLE tbl_tmp RENAME TO dsset_size;
ALTER TABLE dsset_size ADD PRIMARY KEY (box_id, req_id);
ALTER TABLE dsset_size ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;

-- Update the db version
UPDATE ds_data SET db_number = 28 WHERE db_number = 27;
