CREATE TABLE exp_history (
  idx_id   SERIAL PRIMARY KEY,
  tbl_name VARCHAR(1024) NOT NULL,
  col_type INT NOT NULL,
  col_name VARCHAR(1024) NOT NULL
);

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 6, 'dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 3, 'connect_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 3, 'start_session_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 3, 'end_session_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 2, 'files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'online_delta');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'online_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'transmit_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'arch_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 1, 'status');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 1, 'completion');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 1, 'session_type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 2, 'session_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 6, 'description');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'dsdelta_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'lib_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 2, 'owner_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'new_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 2, 'new_files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 0, 'dsbox_snum in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('event_log', 1, 'type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('event_log', 3, 'ev_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('event_log', 1, 'category');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('event_log', 2, 'error');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('event_log', 6, 'ev_text');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('event_log', 6, 'userid');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('event_log', 2, 'ex_long');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('event_log', 6, 'ex_text');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 1, 'type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 3, 'ev_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 1, 'category');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 2, 'error');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 6, 'ev_text');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 6, 'userid');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 2, 'ex_long');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 2, 'client_ex_long');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 6, 'ex_text');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 0, 'userid in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 3, 'st_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 6, 'dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'online_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 2, 'online_files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'new_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 2, 'new_files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'transmit_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'online_bck');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 2, 'backup_files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'ds_size');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 2, 'actual_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage', 0, 'dsbox_snum in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 2, 'charge_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 2, 'id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 6, 'dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 3, 'effective_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 2, 'item_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 2, 'quantity');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 5, 'amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 6, 'remark');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 0, 'dsbox_snum in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charge_items', 2, 'id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charge_items', 2, 'item_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charge_items', 6, 'item_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charge_items', 1, 'charge_type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charge_items', 5, 'price');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charge_items', 6, 'charge_unit');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charge_items', 6, 'c_u');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charge_items', 1, 'price_type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charge_items', 3, 'effective_date');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addons', 2, 'addon_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addons', 2, 'id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addons', 6, 'dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addons', 3, 'effective_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addons', 2, 'addon_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addons', 2, 'serial_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addons', 6, 'remark');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addons', 0, 'dsbox_snum in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 2, 'invoice_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 3, 'from_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 3, 'to_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 3, 'creation_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 3, 'due_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'p_company_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'p_addr1');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'p_city');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'p_prov_state');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'p_postal_zip');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'p_phone');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'p_fax');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'b_dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'b_account_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'c_company_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 2, 's_group_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 's_group_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 2, 's_rep_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 's_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 1, 'consolidation');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'l_addr1');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'l_addr2');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'l_city');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'l_prov_state');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'l_postal_zip');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'l_country');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'l_phone');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'l_fax');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_addr1');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_addr2');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_city');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_prov_state');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_postal_zip');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_country');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_phone');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_fax');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_po_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 2, 'bl_billing_plan');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_bank_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_bank_account');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 3, 'bl_exp_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_bank_addr');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_contact');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 5, 'bp_tax1');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 5, 'bp_tax2');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_tax1_exemp');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'bl_tax2_exemp');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 5, 'crt_online');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 5, 'crt_archive');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 3, 'crt_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 2, 'sc_scale_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'error_dscrpt');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'sp_email_addr');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, ' l_email_addr');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 3, 'consolidation_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 6, 'l_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('head_inv', 0, 'b_account_num = :AccountNum');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addch_inv', 2, 'aid');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addch_inv', 2, 'invoice_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addch_inv', 2, 'service_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addch_inv', 1, 'service_type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addch_inv', 6, 'service_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addch_inv', 2, 'qty');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addch_inv', 5, 'price');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addch_inv', 6, 'price_unit');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 2, 'box_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 3, 'record_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 4, 'protected_size');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 4, 'stored_size');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 5, 'protected_size_avg');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 5, 'stored_size_avg');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 4, 'protected_size_max');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 4, 'stored_size_max');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 0, 'box_id IN (SELECT box_id FROM dsbox WHERE account_num = :AccountNum)');

-- Update the db version
UPDATE ds_data SET db_number = 30 WHERE db_number = 29;
