CREATE TABLE dsbox_size_save (
       box_id            int,
       ds_size           float,
       prot_size         float,
       lib_size          float,
       reset_time        int,
       prot_update_time  int,
       ds_update_time    int,
       prot_avg          float,
       ds_avg            float,
       prot_max          float,
       ds_max            float
);

INSERT INTO dsbox_size_save (box_id, ds_size, prot_size, lib_size, 
            reset_time, prot_update_time, ds_update_time, prot_avg, 
            ds_avg, prot_max, ds_max) SELECT box_id, ds_size, prot_size, 
            lib_size, reset_time, prot_update_time, ds_update_time, 
            prot_avg, ds_avg, prot_max, ds_max FROM dsbox_size;

DROP TABLE dsbox_size;

CREATE TABLE dsbox_size (
       box_id            int NOT NULL PRIMARY KEY references dsbox on delete cascade,
       ds_size           float,
       prot_size         float,
       lib_size          float,
       reset_time        int,
       prot_update_time  int,
       ds_update_time    int,
       prot_avg          float,
       ds_avg            float,
       prot_max          float,
       ds_max            float,
       blm_update_time   int,
       blm_prot_size     float,
       blm_ds_size       float,
       blm_prot_size_max float,
       blm_ds_size_max   float,
       blm_prot_size_avg float,
       blm_ds_size_avg   float
);

INSERT INTO dsbox_size (box_id, ds_size, prot_size, lib_size, 
            reset_time, prot_update_time, ds_update_time, prot_avg, 
            ds_avg, prot_max, ds_max) SELECT box_id, ds_size, prot_size, 
            lib_size, reset_time, prot_update_time, ds_update_time, 
            prot_avg, ds_avg, prot_max, ds_max FROM dsbox_size_save;

DROP TABLE dsbox_size_save;

CREATE TABLE storage_history_save (
        box_id              int,
        record_time         int,
        protected_size      float,
        stored_size         float,
        protected_size_avg  float,
        stored_size_avg     float,
        protected_size_max  float,
        stored_size_max     float
);

INSERT INTO storage_history_save(box_id, record_time, protected_size, 
            stored_size, protected_size_avg, stored_size_avg, 
            protected_size_max, stored_size_max) SELECT box_id, record_time, 
            protected_size, stored_size, protected_size_avg, stored_size_avg, 
            protected_size_max, stored_size_max FROM storage_history;

DROP TABLE storage_history;

CREATE TABLE storage_history (
        box_id              int NOT NULL,
        record_time         int NOT NULL,
        protected_size      float NOT NULL,
        stored_size         float NOT NULL,
        protected_size_avg  float NOT NULL,
        stored_size_avg     float NOT NULL,
        protected_size_max  float NOT NULL,
        stored_size_max     float NOT NULL,
        blm_prot_size       float,
        blm_ds_size         float,
        blm_prot_size_max   float,
        blm_ds_size_max     float,
        blm_prot_size_avg   float,
        blm_ds_size_avg     float,
        PRIMARY KEY (box_id, record_time)
);

INSERT INTO storage_history(box_id, record_time, protected_size, 
            stored_size, protected_size_avg, stored_size_avg, 
            protected_size_max, stored_size_max) SELECT box_id, record_time, 
            protected_size, stored_size, protected_size_avg, stored_size_avg, 
            protected_size_max, stored_size_max FROM storage_history_save;

DROP TABLE storage_history_save;

ALTER TABLE customer ADD COLUMN blm_scale_id INT;

ALTER TABLE dsbox ADD COLUMN blm_scale_id INT;

ALTER TABLE ds_sequences ADD COLUMN blm_scale_id INT;

CREATE TABLE blm_billing_scale (
  blm_scale_id     INT NOT NULL PRIMARY KEY,
  blm_scale_name   VARCHAR(256) NOT NULL,
  invoice_method   INT,
  calculate_methon INT
);

CREATE TABLE blm_billing_option (
  blm_scale_id     INT NOT NULL REFERENCES blm_billing_scale ON DELETE CASCADE,
  max_amount       INT NOT NULL,
  base_price       FLOAT,
  extra_price      FLOAT,
  extra_price_unit INT,
  PRIMARY KEY (blm_scale_id, max_amount)
);

ALTER TABLE head_inv ADD COLUMN blm_scale_id INT;
ALTER TABLE head_inv ADD COLUMN blm_size FLOAT;

-- Update the db version
UPDATE ds_data SET db_number = 37 WHERE db_number = 36;
