
CREATE TABLE schedule_details
(
  schedule_type     int NOT NULL,
  detail_id         int NOT NULL,
  category          int,
  type_every        int,
  type_para         int,
  from_time         int,
  end_time          int,
  end_after         int,
  para1             int,
  para2             int,
  para3             int,
  allow_speed_control     int,
  PRIMARY KEY (schedule_type, detail_id)
);

INSERT INTO schedule_details (schedule_type, detail_id, category, type_every, type_para, from_time, end_time, end_after, para1, para2, para3, allow_speed_control)
       VALUES (2, 1, 2, 1, 127 , extract(epoch from timestamp '1994-05-14 08:00:00'), 0, 1, 64, 0, 0, 0);

UPDATE schedule_details SET type_para = (SELECT 127 - ((cfg_value & 63) * 2 + (cfg_value / 64)) FROM ds_config WHERE cfg_id = -5)
       WHERE schedule_type = 2 AND detail_id = 1;

UPDATE schedule_details SET from_time = (SELECT extract(epoch from timestamp '1994-04-14 00:00:00')+ (3600 * cfg_value) FROM ds_config WHERE cfg_id = 7)
       WHERE schedule_type = 2 AND detail_id = 1;

UPDATE schedule_details 
       SET end_time = COALESCE((SELECT extract(epoch from timestamp '1994-04-14 00:00:00')+ (3600 * cfg_value) 
                                       FROM ds_config 
                                       WHERE cfg_id = 8 AND (cfg_value > (SELECT cfg_value FROM ds_config WHERE cfg_id = 7))
                               ),
                               0
                              )
       WHERE schedule_type = 2 AND detail_id = 1;

INSERT INTO schedule_details (schedule_type, detail_id, category, type_every, type_para, from_time, end_time, end_after, para1, para2, para3, allow_speed_control)
       SELECT 1, 1, 4, 1, 0 , extract(epoch from timestamp '1994-04-14 00:00:00'), 0, 0, 0, 0, 0, 1 FROM ds_config WHERE cfg_id = 2 AND cfg_value = 1;

DELETE FROM ds_config WHERE cfg_id = -5;
DELETE FROM ds_config WHERE cfg_id = 2;
DELETE FROM ds_config WHERE cfg_id = 7;
DELETE FROM ds_config WHERE cfg_id = 8;

CREATE TABLE schedule_status
(
  schedule_type     int NOT NULL,
  detail_id         int NOT NULL,
  last_start_time   int DEFAULT 0,
  PRIMARY KEY (schedule_type, detail_id)
);

CREATE TABLE speed_control
(
  idx_id            SERIAL PRIMARY KEY,
  schedule_type     int NOT NULL,
  detail_id         int NOT NULL,
  start_time        int NOT NULL,
  end_time          int NOT NULL,
  speed             int NOT NULL
);

-- Update the db version
UPDATE ds_data SET db_number = 40 WHERE db_number = 39;
