CREATE TABLE storage_locations(
       id          SERIAL PRIMARY KEY,
       path        varchar(1024) NOT NULL,
       total_size  float NOT NULL,
       guard_size  float NOT NULL,
       used_size   float NOT NULL default 0,
       max_files   int,
       used_files  int
);

CREATE TABLE storage_levels(
       levellim       float NOT NULL
);
CREATE UNIQUE INDEX idx_stor_levels on storage_levels(levellim);

INSERT INTO storage_levels(levellim) VALUES (0.25);
INSERT INTO storage_levels(levellim) VALUES (0.50);
INSERT INTO storage_levels(levellim) VALUES (0.70);
INSERT INTO storage_levels(levellim) VALUES (0.85);
INSERT INTO storage_levels(levellim) VALUES (0.90);
INSERT INTO storage_levels(levellim) VALUES (0.93);
INSERT INTO storage_levels(levellim) VALUES (0.96);
INSERT INTO storage_levels(levellim) VALUES (0.98);
INSERT INTO storage_levels(levellim) VALUES (0.99);
INSERT INTO storage_levels(levellim) VALUES (0.995);
INSERT INTO storage_levels(levellim) VALUES (0.999);
INSERT INTO storage_levels(levellim) VALUES (0.9995);
INSERT INTO storage_levels(levellim) VALUES (0.9999);


UPDATE ds_data SET ds_build_no = 2 WHERE ds_build_no = 1;
UPDATE ds_data SET db_number = 6 WHERE db_number = 5;


