
ALTER TABLE ds_config RENAME TO ds_config_old;

-- Hold the configuration of DS-System
CREATE TABLE ds_config (
  cfg_id    INT NOT NULL,
  cfg_name  VARCHAR(256),
  cfg_value INT,
  min_value INT,
  max_value INT,
  cfg_text  VARCHAR(1024)
);

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (1, 1, 0, 1, 'RecycleSwitch', 'Recycle Master/Delta Switch');

-- 2 -> AutoHealing, not used anymore

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (3, 3, 1, 16, 'HealingProcess', 'Number of Autonomic Healing processes to start automatically');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (4, 0, 0, 1, 'DisasterRecoveryMode', 'DS-System mode: Regular / Disaster Recovery');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (5, 4, 1, 100, 'RecoveryProcess', 'Maximum number of concurrent Disaster Recovery processes on each node');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (6, 1, 0, 20, 'SysAdminProcess', 'Maximum number of concurrent System Admin processes on each node');

-- 7 -> SysAdmin Start, not used anymore
-- 8 -> SysAdmin End, not used anymore

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (9, -1, 0, 1, 'DirectorMode', 'DS-Director mode: DS-Director only / DS-Director & DS-System');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (10, 5, 1, 1000, 'DirScanLimit',
       'How many directories can be opened at the same time by DS-Client Synchronization Process');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (11, 0, 0, 1, 'FailBackupOnBLMError',
       'If the backup of a generation should fail in the case BLM infinite generations is configured and BLM movement of the old generation fails.');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (12, 0, 0, 1, 'UseClientSNAP',
       'Use 3rd party snapshot for DS-Client BLM Point in time copy requests.');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (13, 0, 0, 1, 'ExcludeRecycleDelta',
       'Exclude recycled delta generations for stored size');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (14, 0, 0, 1, 'AllowUnencryptedConnections',
       'Allow connections to be made using an unencrypted protocol');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (15, 4, 1, 16, 'RecoveryLibThreads',
       'How many library processing threads should be started for Disaster Recovery');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (16, 0, 0, 65536, 'MaxBlockSize',
       'The maximum block size for sends. (0 = No maximum)');

-- public library switch
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (17, 1, 0, 1, 'PubLibSwitch',
       'Global public library switch. (0=>disable,1=>enable public library)');

-- Read-only DS-System
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (18, 0, 0, 1, 'ReadOnly',
       'Read-only DS-System. (0=>normal, 1=>Read-only DS-System)');

-- Force DR scan during synchronization
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (19, 0, 0, 1, 'SyncDRScan',
       'Disaster recovery scan during synchronization.');

-- use cfg_id < 0 for special configuration
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-1,0,'recycle_option');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-2,0,'recycle_gens');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-3,0,'recycle_days');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-4,0,'recycle_size');
-- -5 -> Skip SysAdmin, not used anymore
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-6,15,'recycle_percentage');
-- set default LAN Discovery processes expire period as 2 Weeks
INSERT INTO ds_config(cfg_id, cfg_value, cfg_name) VALUES(-7, 131074, 'lan_discovery_expire_period');

INSERT INTO ds_config(cfg_id, cfg_value, cfg_name, cfg_text) VALUES (-8, 0, 'skip_delta_indexes', 'Skip delta indexes validation during Autonomic Healing');

INSERT INTO ds_config(cfg_id, cfg_value, cfg_name, cfg_text)
       VALUES (-9, 0, 'uncrypted_blm', 'Use uncrypted communication for BLM');

INSERT INTO ds_config(cfg_id, cfg_value, cfg_name, cfg_text)
       VALUES (-10, 2, 'blm_file_process_threads', 'BLM process threads');
INSERT INTO ds_config(cfg_id, cfg_value, cfg_name, cfg_text)
       VALUES (-11, 1, 'runtime_db_update', 'At what level of runtime DB update is the database');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (-12, 20, 0, 9999, 'MaxAdminActivityCount',
       'How many admin activities can be started concurrently');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (-13, 120, 0, 1440, 'MaxAdminWaitingTime',
       'Maximum time (in minutes) that DS-Client admin activities can be delayed.');
-- cfg_id # -14 is exclusively used for a Windows flag

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (-15, 0, 0, 1, 'PersistentLockCustomer',
       'Enable/Disable persistent lock when lock customer.');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (-16, 1, 0, 1, 'ExtFSCache',
       'Enable/Disable extensible storage cache.');

UPDATE ds_config SET cfg_value = (SELECT cfg_value FROM ds_config_old
       WHERE ds_config_old.cfg_id = ds_config.cfg_id) WHERE cfg_id IN
       (SELECT cfg_id FROM ds_config_old);

DROP TABLE ds_config_old;

ALTER TABLE ds_config ADD PRIMARY KEY (cfg_id);

UPDATE ds_data SET db_number = 74 WHERE db_number = 73;
