-- Maximum items in private_files
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (21, 1000000, 10000, 1000000000, 'MaxPrivateItems',
       'Maximum number of potential libraries to keep in DS-System database.');

-- Maximum days in private_files
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (22, 365, 60, 10000, 'MaxPrivateDays',
       'Maximum days to keep potential libraries in DS-System database.');

-- Online Warning Level
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (23, 500, 1, 10000, 'OLWarnLevel',
       'Online free space warning level (current value divided by 100 is the percentage).');

-- Online Emergency Level
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (24, 200, 1, 10000, 'OLEmerLevel',
       'Online free space emergency level (current value divided by 100 is the percentage).');

-- Online Stop Level
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (25, 50, 1, 10000, 'OLStopLevel',
       'Online free space stop level (current value divided by 100 is the percentage).');

-- Warning pop-up message frequency
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (26, 4, 1, 24, 'WarnPMFreq',
       'Warning message pop-up frequency (in hours).');

-- Emergency pop-up message frequency
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (27, 1, 1, 24, 'EmerPMFreq',
       'Emergency message pop-up frequency (in hours).');

-- Free memory warning level
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (28, 0, 0, 10000, 'MemWarnLevel',
       'Free memory warning level (0=no check).');

-- Free memory emergency level
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (29, 0, 0, 10000, 'MemEmerLevel',
       'Free memory emergency level (0=no check).');

-- DS-Client auto-upgrade
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (30, 1, 0, 1, 'AutoUpgrade', 'DS-Client auto-upgrade.');

-- auto-upgrade in silent mode
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (31, 1, 0, 1, 'SilentMode', 'Silent mode auto-upgrade.');

-- Clean orphaned library links
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (32, 0, 0, 1, 'CleanLibLink', 'Clean orphaned library links.');

-- Move bad files to BadFiles
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (33, 1, 0, 1, 'MoveBadFiles', 'Move to BadFiles directory.');

-- Force indexing database cache
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (34, 0, 0, 1, 'ForceCache',
       'Force to cache indexing database.');

-- Skip database backup
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (35, 0, 0, 1, 'SkipDBDump', 'Skip database backup.');

-- Database backup method
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (36, 0, 0, 2, 'DBDumpMethod',
       'Database dump format(0-custom, 1-tar, 2-plain text).');

-- Database backup window begin
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (37, 8, 0, 23, 'DBDumpStart',
       'Database backup window start hour.');

-- Database backup window end
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (38, 17, 0, 23, 'DBDumpEnd',
       'Database backup window end hour.');

-- How many days to keep database backup
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (39, 2, 1, 10000, 'DBDumpDays',
       'How many days to keep database backups.');

-- allow multiple storage on the same valume
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (-1000, 0, 0, 1, 'MultiStorage',
       'Allow multiple storage on the same volume.');

-- Debug level
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (-1001, 0, 0, 1, 'DebugLevel',
       'DS-System Debug Level.');

UPDATE ds_data SET db_number = 82 WHERE db_number = 81;

