
-- Change cookie type from varchar(1024) to bytea

ALTER TABLE blm_server ADD srvid_temp int4;
UPDATE blm_server SET srvid_temp = srvid;

ALTER TABLE blm_server ADD srvid_temp_seq int4;
UPDATE blm_server SET srvid_temp_seq = nextval('blm_server_srvid_seq');

ALTER TABLE blm_server DROP CONSTRAINT blm_server_pkey;
ALTER TABLE blm_server DROP COLUMN srvid;

ALTER TABLE blm_server RENAME TO blm_server_old;

CREATE TABLE blm_server(
	srvid         SERIAL PRIMARY KEY,
	blm_ip        varchar(256),
	blm_port      int NOT NULL,
	sys_id        int NOT NULL,
	cookie        bytea NOT NULL,
	blmactive     int
);

INSERT INTO blm_server 
(
   srvid,
   blm_ip, 
   blm_port, 
   sys_id, 
   cookie,
   blmactive
)
SELECT 
   srvid_temp,
   blm_ip, 
   blm_port, 
   sys_id, 
   DECODE(cookie,'escape'),
   blmactive
FROM blm_server_old;

SELECT setval('blm_server_srvid_seq',(select max(srvid_temp_seq)-1 from blm_server_old));

DROP TABLE blm_server_old;

UPDATE ds_data SET db_number = 86 WHERE db_number = 85;
