
-- re-index the business_param table
CREATE TEMPORARY TABLE tmp_bp (
  parm_id             SERIAL,
  effective_date      int  PRIMARY KEY,
  group_commission    float NOT NULL,
  broker_commission   float NOT NULL,
  tax1                float NOT NULL,
  tax2                float NOT NULL,
  no_connection_charge int, 
  last_user           varchar (20) NULL
);

INSERT INTO tmp_bp(effective_date, group_commission, broker_commission, tax1, tax2, no_connection_charge, last_user)
       SELECT  effective_date, group_commission, broker_commission, tax1, tax2, no_connection_charge, last_user
       FROM business_parms ORDER BY parm_id asc, effective_date asc;

-- re-create to force the param_id sequence to re-start
DROP TABLE business_parms;
CREATE TABLE business_parms (
  parm_id             SERIAL,
  effective_date      int  PRIMARY KEY,
  group_commission    float NOT NULL,
  broker_commission   float NOT NULL,
  tax1                float NOT NULL,
  tax2                float NOT NULL,
  no_connection_charge int, 
  last_user           varchar (20) NULL
);

INSERT INTO business_parms(effective_date, group_commission, broker_commission, tax1, tax2, no_connection_charge, last_user)
       SELECT  effective_date, group_commission, broker_commission, tax1, tax2, no_connection_charge, last_user
       FROM tmp_bp ORDER BY parm_id ASC;

DROP TABLE tmp_bp;
       
UPDATE ds_data SET db_number = 90 WHERE db_number = 89;
