
ALTER TABLE addch_inv ADD amount float;
UPDATE addch_inv SET amount = 0;
ALTER TABLE addch_inv ALTER COLUMN amount SET NOT NULL;
ALTER TABLE addch_inv ALTER COLUMN amount SET default 0;

UPDATE addch_inv 
SET amount = (CASE 
                  WHEN (qty<0) THEN round(cast(-price as numeric),2)
                  ELSE round( round(cast(qty*100 as numeric),0) * round(cast(price*1000 as numeric),0)/100000.0, 2)
              END);


ALTER TABLE head_inv ADD subtotal     float;
ALTER TABLE head_inv ADD tax1_amount  float;
ALTER TABLE head_inv ADD tax2_amount  float;
ALTER TABLE head_inv ADD grand_total  float;

UPDATE head_inv 
SET    subtotal = (
               SELECT round(cast(COALESCE(SUM(addch_inv.amount),0) as numeric),2) 
               FROM addch_inv
               WHERE head_inv.invoice_num = addch_inv.invoice_num );

UPDATE head_inv SET tax1_amount  = case when (bl_tax1_exemp is null or bl_tax1_exemp='') then round(cast(subtotal * bp_tax1/100 as numeric),2) else 0 end,
                    tax2_amount  = case when (bl_tax2_exemp is null or bl_tax2_exemp='') then round(cast(subtotal * bp_tax2/100 as numeric),2) else 0 end,
                    grand_total  = round(cast(subtotal as numeric) + 
                                         case when (bl_tax1_exemp is null or bl_tax1_exemp='') then round(cast(subtotal * bp_tax1/100 as numeric),2) else 0 end + 
                                         case when (bl_tax2_exemp is null or bl_tax2_exemp='') then round(cast(subtotal * bp_tax2/100 as numeric),2) else 0 end
                                         ,2);

UPDATE  head_inv 
SET     subtotal    = h1.subtotal,    tax1_amount = h1.tax1_amount, 
        tax2_amount = h1.tax2_amount, grand_total = h1.grand_total
FROM    (
         SELECT   b_account_num, 
                  consolidation_date, 
                  SUM(subtotal)    AS subtotal, 
                  SUM(tax1_amount) AS tax1_amount,
                  SUM(tax2_amount) AS tax2_amount,  
                  SUM(grand_total) AS grand_total
         FROM     head_inv
         WHERE    consolidation = 1
         AND      b_dsbox_snum is not null
         AND      b_dsbox_snum <> '' 
         GROUP BY b_account_num, consolidation_date
        ) h1
WHERE   head_inv.consolidation = 1
AND     (head_inv.b_dsbox_snum is null OR head_inv.b_dsbox_snum = '' )
AND     head_inv.b_account_num      = h1.b_account_num
AND     head_inv.consolidation_date = h1.consolidation_date;

UPDATE  head_inv 
SET     subtotal = 0, tax1_amount = 0, tax2_amount = 0, grand_total = 0
WHERE   subtotal is null;

UPDATE exp_history SET col_type=5 WHERE tbl_name='addch_inv' AND col_name='qty';
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 5, 'amount');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'subtotal');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'tax1_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'tax2_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'grand_total');

UPDATE ds_data SET db_number = 93 WHERE db_number = 92;
