CREATE TABLE dssys_group (
  idx_id   SERIAL PRIMARY KEY,
  grp_id   INT,
  ip_addr  varchar(1024)
);

CREATE TABLE history_customer_num (
  old_account_num  varchar(64) PRIMARY KEY,
  new_account_num  varchar(64),
  add_date         INT
);

CREATE TABLE history_box_num (
  old_box_num  varchar(64) PRIMARY KEY,
  new_box_num  varchar(64),
  add_date     INT
);

-- DS-System group
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (55, 0, 0, 1, 'DSSysGroup',
       'Allow DS-System group for multi-directional replication (0-disable).');

-- DS-System group port
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (56, 4409, 1024, 65536, 'GrpPort',
       'DS-System group communication port.');

-- Allow DS-System group encrypt communication
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (57, 1, 0, 1, 'GrpEncrypt',
       'Use encrypted communication for DS-System group.');

-- Maximum number of concurrent replication processes on each node
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (58, 4, 0, 100, 'ReplicationProcess',
       'Maximum number of concurrent replication processes on each node.');

-- Perform replication check for shared DS-Client interval
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (59, 6, 0, 360, 'ReplicationCheck',
       'Perform replication check for shared DS-Client interval (in hours, 0-disable).');

-- Replication send threads
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (60, 2, 1, 100, 'ReplicationSendThreads',
       'How many send threads should be started for replication.');

-- Replication recv threads
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (61, 4, 1, 100, 'ReplicationRecvThreads',
       'How many receive threads should be started for replication.');

-- Replication del threads
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (62, 2, 1, 100, 'ReplicationDelThreads',
       'How many delete threads should be started for replication.');

-- DS-System group owner ID
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (-19, 0, 0, 100, 'GrpOwnerID', 'DS-System group ID.');

-- DS-System group timestamp
INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text)
       VALUES (-20, 0, 0, 2147483647, 'GrpTimeStamp', 'DS-System group timestamp.');

UPDATE ds_data SET db_number = 97 WHERE db_number = 96;
