/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRRecordedValuesGenericPrintElement;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class JRFillGenericElement
extends JRFillElement
implements JRGenericElement {
    private JRGenericElementParameter[] parameters;
    private Map<String, Object> parameterValues = new HashMap<String, Object>();

    public JRFillGenericElement(JRBaseFiller filler, JRGenericElement element, JRFillObjectFactory factory) {
        super(filler, element, factory);
        this.parameters = element.getParameters();
    }

    public JRFillGenericElement(JRFillGenericElement element, JRFillCloneFactory factory) {
        super(element, factory);
        this.parameters = element.parameters;
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if ((this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.evaluateElement(evaluation);
        }
    }

    @Override
    protected void collectDelayedEvaluations() {
        super.collectDelayedEvaluations();
        for (int i = 0; i < this.parameters.length; ++i) {
            JRGenericElementParameter parameter = this.parameters[i];
            this.collectDelayedEvaluations(parameter.getValueExpression());
        }
    }

    protected void evaluateElement(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        this.parameterValues.clear();
        for (int i = 0; i < this.parameters.length; ++i) {
            JRGenericElementParameter parameter = this.parameters[i];
            Object value = null;
            JRExpression valueExpression = parameter.getValueExpression();
            if (valueExpression != null) {
                value = this.evaluateExpression(valueExpression, evaluation);
            }
            if (value == null && parameter.isSkipWhenEmpty()) continue;
            this.parameterValues.put(parameter.getName(), value);
        }
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
            isToPrint = false;
        }
        if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
            isToPrint = false;
            willOverflow = true;
        }
        if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isPrintRepeatedValues())) {
            isReprinted = true;
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplateGenericPrintElement printElement;
        if (this.isEvaluateAuto()) {
            JRRecordedValuesGenericPrintElement recordedValuesElement = new JRRecordedValuesGenericPrintElement(this.getTemplate(), this.elementId, this.parameters.length);
            this.copyBasicAttributes(recordedValuesElement);
            this.initDelayedEvaluationPrint(recordedValuesElement);
            printElement = recordedValuesElement;
        } else {
            printElement = new JRTemplateGenericPrintElement(this.getTemplate(), this.elementId, this.parameters.length);
            this.copyBasicAttributes(printElement);
            if (this.isEvaluateNow()) {
                this.copy(printElement);
            } else {
                this.filler.addBoundElement((JRFillElement)this, (JRPrintElement)printElement, this.getEvaluationTimeValue(), this.getEvaluationGroupName(), this.band);
            }
        }
        return printElement;
    }

    protected void copyBasicAttributes(JRGenericPrintElement printElement) {
        printElement.setUUID(this.getUUID());
        printElement.setX(this.getX());
        printElement.setY(this.getRelativeY());
        printElement.setWidth(this.getWidth());
        printElement.setHeight(this.getStretchHeight());
    }

    protected JRTemplateGenericElement getTemplate() {
        return (JRTemplateGenericElement)this.getElementTemplate();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        return new JRTemplateGenericElement(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
    }

    protected void copy(JRGenericPrintElement printElement) {
        for (Map.Entry<String, Object> entry : this.parameterValues.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            printElement.setParameterValue(name, value);
        }
        this.transferProperties(printElement);
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) throws JRException {
        JRGenericPrintElement genericElement = (JRGenericPrintElement)element;
        this.evaluateElement(evaluation);
        this.copy(genericElement);
    }

    @Override
    protected void rewind() throws JRException {
    }

    @Override
    public JRGenericElementType getGenericType() {
        return ((JRGenericElement)this.parent).getGenericType();
    }

    @Override
    public JRGenericElementParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitGenericElement(this);
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillGenericElement(this, factory);
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return ((JRGenericElement)this.parent).getEvaluationTimeValue();
    }

    @Override
    public String getEvaluationGroupName() {
        return ((JRGenericElement)this.parent).getEvaluationGroupName();
    }
}

