
-- the old scripts used to insert to blank duplicate blanc entries and this messes up 
-- the primary key creation ...
DELETE FROM provinces WHERE province_code = '  ' AND province_name = '  '; 
INSERT INTO provinces(province_code, province_name, country_code) 
            SELECT  '  ', '  ', country_code FROM countries WHERE country_code != '???';
 
-- old code failed to delete items from provinces, which causes duplication
-- when inserting new values (and primary key violations cause no countries to be added)
DELETE FROM provinces WHERE NOT EXISTS (SELECT * FROM countries c WHERE c.country_code = provinces.country_code);

UPDATE ltsconfig SET buffer='' WHERE buffer IS NULL;

-- indexes superseeded by the primary keys
DROP INDEX idx_stor_levels;
DROP INDEX idx_box_history_id;
DROP INDEX dsset_size_id;
DROP INDEX dsset_healing_id;
DROP INDEX idx_box_cust_id;

-- audit
CREATE SEQUENCE audit_idx_id_seq;
ALTER TABLE audit ADD idx_id INT;
UPDATE audit SET idx_id = nextval('audit_idx_id_seq');
ALTER TABLE audit ALTER COLUMN idx_id SET NOT NULL;
ALTER TABLE audit ALTER COLUMN idx_id SET DEFAULT nextval('audit_idx_id_seq');
ALTER TABLE audit ADD PRIMARY KEY (idx_id);
ALTER TABLE audit ALTER COLUMN userid SET NOT NULL;

-- dsclientinfo
CREATE SEQUENCE dsclientinfo_idx_id_seq;
ALTER TABLE dsclientinfo ADD idx_id INT;
UPDATE dsclientinfo SET idx_id = nextval('dsclientinfo_idx_id_seq');
ALTER TABLE dsclientinfo ALTER COLUMN idx_id SET NOT NULL;
ALTER TABLE dsclientinfo ALTER COLUMN idx_id SET DEFAULT nextval('dsclientinfo_idx_id_seq');
ALTER TABLE dsclientinfo ADD PRIMARY KEY (idx_id);

ALTER TABLE customer_arc ADD PRIMARY KEY (account_id);
ALTER TABLE dsbox_quota ADD PRIMARY KEY (box_id);
ALTER TABLE disaster_restore_path ADD PRIMARY KEY (box_id);
ALTER TABLE customer_quota ADD PRIMARY KEY (account_id);
ALTER TABLE connection_log ADD PRIMARY KEY (dsbox_snum, start_session_time, session_id, cluster_id);
ALTER TABLE statisticscan ADD PRIMARY KEY (type, "limit");
ALTER TABLE statisticscanstate ADD PRIMARY KEY (connecttime, text, endtime, autoresume, runtimepoint);
ALTER TABLE slahistory ADD PRIMARY KEY (from_date);
ALTER TABLE billing_options ADD PRIMARY KEY (scale_id, from_date, max_amount);
ALTER TABLE location_arc ADD PRIMARY KEY (id);
ALTER TABLE bandwidth ADD PRIMARY KEY (cust_id, box_id);
ALTER TABLE var_data ADD PRIMARY KEY (company_name);
ALTER TABLE ds_data ADD PRIMARY KEY (company_name);
ALTER TABLE group_commission ADD PRIMARY KEY (group_id, effective_date);
ALTER TABLE provinces ADD PRIMARY KEY (country_code, province_code);
ALTER TABLE clients_tools ADD PRIMARY KEY (box_id);
ALTER TABLE public_files ADD PRIMARY KEY (pub_id);
ALTER TABLE pub_resume ADD PRIMARY KEY (pub_id, acc_id, box_id, req_id, appl_id, dir_id, file_id, gen_id);
ALTER TABLE dsbox_size ADD PRIMARY KEY (box_id);
ALTER TABLE dsset_size ADD PRIMARY KEY (box_id, req_id);
ALTER TABLE ltsconfig ADD PRIMARY KEY (buffer);
ALTER TABLE persistent_locks ADD PRIMARY KEY (account_id, box_id, req_id, lock_type);
ALTER TABLE notification_settings ADD PRIMARY KEY (pager_nr, retry_int, mon_freq);
ALTER TABLE snmp_config ADD PRIMARY KEY (monitor_flag);
ALTER TABLE snmp_dest ADD PRIMARY KEY (community, destination);
ALTER TABLE sla_monitor_history ADD PRIMARY KEY (from_date, to_date, client, dsi_errors, ssp_errors, minutes);
ALTER TABLE storage ADD PRIMARY KEY (st_date, dsbox_snum);
ALTER TABLE load_summary ADD PRIMARY KEY (sum_time, clusterid);
ALTER TABLE sharedperm ADD PRIMARY KEY (account_id, box_id, set_id, client_id, permission);
ALTER TABLE attachedset ADD PRIMARY KEY (account_id, box_id, set_id, client_id, req_id);
ALTER TABLE sharedset ADD PRIMARY KEY (account_id, box_id, set_id);
ALTER TABLE slaconnectiontime ADD PRIMARY KEY (backupproblem, disctapetime, portablerequest, invalidfiles);
ALTER TABLE migration ADD PRIMARY KEY (mig_number, old_box_id, new_account_id, new_box_id);
ALTER TABLE storage_history ADD PRIMARY KEY (box_id, record_time);
ALTER TABLE storage_his_settings ADD PRIMARY KEY (cust_id, box_id);
ALTER TABLE storage_levels ADD PRIMARY KEY (levellim);
ALTER TABLE dsset_healing ADD PRIMARY KEY (box_id, req_id);
ALTER TABLE ds_config ADD PRIMARY KEY (recycle_switch);
ALTER TABLE exchange_session ADD PRIMARY KEY (acc_id, box_id, req_id, appl_id, dir_id, file_id, gen_id, flag, bktime);
ALTER TABLE dsset_recovery ADD PRIMARY KEY (acc_id, box_id, req_id);


/* The following tables do not really have unique indexes, and as such, we will have to create
 * one
 */

-- event log
CREATE SEQUENCE event_log_ev_id_seq;
ALTER TABLE event_log ADD ev_id int;
UPDATE event_log SET ev_id=nextval('event_log_ev_id_seq');
ALTER TABLE event_log ALTER COLUMN ev_id SET NOT NULL;
ALTER TABLE event_log ALTER COLUMN ev_id SET DEFAULT nextval('event_log_ev_id_seq');
ALTER TABLE event_log ADD PRIMARY KEY (ev_id);

-- ds-client event log
CREATE SEQUENCE clients_event_log_ev_id_seq;
ALTER TABLE clients_event_log ADD ev_id int;
UPDATE clients_event_log SET ev_id=nextval('clients_event_log_ev_id_seq');
ALTER TABLE clients_event_log ALTER COLUMN ev_id SET NOT NULL;
ALTER TABLE clients_event_log ALTER COLUMN ev_id SET DEFAULT nextval('clients_event_log_ev_id_seq');
ALTER TABLE clients_event_log ADD PRIMARY KEY (ev_id);

-- cluster events
CREATE SEQUENCE cluster_events_ev_id_seq;
ALTER TABLE cluster_events ADD ev_id int;
UPDATE cluster_events SET ev_id=nextval('cluster_events_ev_id_seq');
ALTER TABLE cluster_events ALTER COLUMN ev_id SET NOT NULL;
ALTER TABLE cluster_events ALTER COLUMN ev_id SET DEFAULT nextval('cluster_events_ev_id_seq');
ALTER TABLE cluster_events ADD PRIMARY KEY (ev_id);

-- library files
CREATE SEQUENCE lib_files_idx_id_seq;
ALTER TABLE lib_files ADD idx_id int;
UPDATE lib_files SET idx_id=nextval('lib_files_idx_id_seq');
ALTER TABLE lib_files ALTER COLUMN idx_id SET NOT NULL;
ALTER TABLE lib_files ALTER COLUMN idx_id SET DEFAULT nextval('lib_files_idx_id_seq');
ALTER TABLE lib_files ADD PRIMARY KEY (idx_id);

-- private files
CREATE SEQUENCE private_files_idx_id_seq;
ALTER TABLE private_files ADD idx_id int;
UPDATE private_files SET idx_id=nextval('private_files_idx_id_seq');
ALTER TABLE private_files ALTER COLUMN idx_id SET NOT NULL;
ALTER TABLE private_files ALTER COLUMN idx_id SET DEFAULT nextval('private_files_idx_id_seq');
ALTER TABLE private_files ADD PRIMARY KEY (idx_id);

-- sla event
CREATE SEQUENCE sla_event_idx_id_seq;
ALTER TABLE sla_event ADD idx_id int;
UPDATE sla_event SET idx_id=nextval('sla_event_idx_id_seq');
ALTER TABLE sla_event ALTER COLUMN idx_id SET NOT NULL;
ALTER TABLE sla_event ALTER COLUMN idx_id SET DEFAULT nextval('sla_event_idx_id_seq');
ALTER TABLE sla_event ADD PRIMARY KEY (idx_id);

UPDATE ds_data SET db_number = 14 WHERE db_number = 13;
