DROP INDEX idx_customer_id;

ALTER TABLE connection_log DROP CONSTRAINT connection_log_pkey;
ALTER TABLE connection_log ADD PRIMARY KEY (session_id);
ALTER TABLE connection_log ALTER COLUMN start_session_time DROP NOT NULL;
ALTER TABLE connection_log ALTER COLUMN cluster_id DROP NOT NULL;

CREATE TABLE ds_sequences (
  idx_id	SERIAL PRIMARY KEY,
  account_id	INT DEFAULT 0,
  box_id	INT DEFAULT 0,
  pub_id	INT DEFAULT 0,
  loc_id	INT DEFAULT 0,
  bloc_id	INT DEFAULT 0,
  rep_id	INT DEFAULT 0,
  group_id	INT DEFAULT 0,
  activity_id	INT DEFAULT 0,
  cd_id		INT DEFAULT 0,
  lts_id	INT DEFAULT 0,
  disaster_id	INT DEFAULT 0,
  charge_id	INT DEFAULT 0,
  scale_id	INT DEFAULT 0,
  slascale_id	INT DEFAULT 0,
  bplan_id	INT DEFAULT 0,
  message_id	INT DEFAULT 0,
  invoice_id	INT DEFAULT 0,
  credit_id	INT DEFAULT 0,
  addon_id	INT DEFAULT 0
);

INSERT INTO ds_sequences (account_id, box_id, pub_id, loc_id, bloc_id, rep_id,
                          group_id, activity_id, cd_id, lts_id, disaster_id,
                          charge_id, scale_id, slascale_id, bplan_id,
                          message_id, invoice_id, credit_id, addon_id) 
            VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- Try to drop old sequences used by SERIAL column
ALTER TABLE customer ADD COLUMN tmp_id INT;
UPDATE customer SET tmp_id = account_id;
ALTER TABLE customer ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE customer DROP COLUMN account_id CASCADE;
ALTER TABLE customer RENAME COLUMN tmp_id TO account_id;
ALTER TABLE customer ADD PRIMARY KEY(account_id);
ALTER TABLE persistent_locks ADD FOREIGN KEY (account_id) REFERENCES customer(account_id) ON DELETE CASCADE;
ALTER TABLE sharedperm ADD FOREIGN KEY (account_id) REFERENCES customer(account_id) ON DELETE CASCADE;
ALTER TABLE attachedset ADD FOREIGN KEY (account_id) REFERENCES customer(account_id) ON DELETE CASCADE;
ALTER TABLE sharedset ADD FOREIGN KEY (account_id) REFERENCES customer(account_id) ON DELETE CASCADE;

ALTER TABLE dsbox ADD COLUMN tmp_id INT;
UPDATE dsbox SET tmp_id = box_id;
ALTER TABLE dsbox ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE dsbox DROP COLUMN box_id CASCADE;
ALTER TABLE dsbox RENAME COLUMN tmp_id TO box_id;
ALTER TABLE dsbox ADD PRIMARY KEY(box_id);
ALTER TABLE dsbox_quota ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE disaster_restore_path ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE clients_tools ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE dsbox_size ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE persistent_locks ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE sharedperm ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE attachedset ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE sharedset ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE process_time ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE portable_noscale ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;
ALTER TABLE dsclientinfo ADD FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE;

ALTER TABLE sale_reps ADD COLUMN tmp_id INT;
UPDATE sale_reps SET tmp_id = rep_id;
ALTER TABLE sale_reps ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE sale_reps DROP COLUMN rep_id CASCADE;
ALTER TABLE sale_reps RENAME COLUMN tmp_id TO rep_id;
ALTER TABLE sale_reps ADD PRIMARY KEY(rep_id);

ALTER TABLE sale_groups ADD COLUMN tmp_id INT;
UPDATE sale_groups SET tmp_id = group_id;
ALTER TABLE sale_groups ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE sale_groups DROP COLUMN group_id CASCADE;
ALTER TABLE sale_groups RENAME COLUMN tmp_id TO group_id;
ALTER TABLE sale_groups ADD PRIMARY KEY(group_id);

ALTER TABLE location ADD COLUMN tmp_id INT;
UPDATE location SET tmp_id = id;
ALTER TABLE location ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE location DROP COLUMN id CASCADE;
ALTER TABLE location RENAME COLUMN tmp_id TO id;
ALTER TABLE location ADD PRIMARY KEY(id);

ALTER TABLE location_billing ADD COLUMN tmp_id INT;
UPDATE location_billing SET tmp_id = id;
ALTER TABLE location_billing ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE location_billing DROP COLUMN id CASCADE;
ALTER TABLE location_billing RENAME COLUMN tmp_id TO id;
ALTER TABLE location_billing ADD PRIMARY KEY(id);

ALTER TABLE billing_scale ADD COLUMN tmp_id INT;
UPDATE billing_scale SET tmp_id = scale_id;
ALTER TABLE billing_scale ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE billing_scale DROP COLUMN scale_id CASCADE;
ALTER TABLE billing_scale RENAME COLUMN tmp_id TO scale_id;
ALTER TABLE billing_scale ADD PRIMARY KEY(scale_id);
ALTER TABLE billing_options ADD FOREIGN KEY (scale_id) REFERENCES billing_scale(scale_id) ON DELETE CASCADE;

ALTER TABLE sla_credit_scale ADD COLUMN tmp_id INT;
UPDATE sla_credit_scale SET tmp_id = slascale_id;
ALTER TABLE sla_credit_scale ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE sla_credit_scale DROP COLUMN slascale_id CASCADE;
ALTER TABLE sla_credit_scale RENAME COLUMN tmp_id TO slascale_id;
ALTER TABLE sla_credit_scale ADD PRIMARY KEY(slascale_id);

ALTER TABLE bill_plan ADD COLUMN tmp_id INT;
UPDATE bill_plan SET tmp_id = plan_num;
ALTER TABLE bill_plan ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE bill_plan DROP COLUMN plan_num CASCADE;
ALTER TABLE bill_plan RENAME COLUMN tmp_id TO plan_num;
ALTER TABLE bill_plan ADD PRIMARY KEY(plan_num);

ALTER TABLE maintenance_message ADD COLUMN tmp_id INT;
UPDATE maintenance_message SET tmp_id = message_id;
ALTER TABLE maintenance_message ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE maintenance_message DROP COLUMN message_id CASCADE;
ALTER TABLE maintenance_message RENAME COLUMN tmp_id TO message_id;
ALTER TABLE maintenance_message ADD PRIMARY KEY(message_id);

ALTER TABLE head_inv ADD COLUMN tmp_id INT;
UPDATE head_inv SET tmp_id = invoice_num;
ALTER TABLE head_inv ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE head_inv DROP COLUMN invoice_num CASCADE;
ALTER TABLE head_inv RENAME COLUMN tmp_id TO invoice_num;
ALTER TABLE head_inv ADD PRIMARY KEY(invoice_num);
ALTER TABLE addch_inv ADD FOREIGN KEY (invoice_num) REFERENCES head_inv(invoice_num) ON DELETE CASCADE;

ALTER TABLE ds_credit ADD COLUMN tmp_id INT;
UPDATE ds_credit SET tmp_id = credit_id;
ALTER TABLE ds_credit ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE ds_credit DROP COLUMN credit_id CASCADE;
ALTER TABLE ds_credit RENAME COLUMN tmp_id TO credit_id;
ALTER TABLE ds_credit ADD PRIMARY KEY(credit_id);

ALTER TABLE addons ADD COLUMN tmp_id INT;
UPDATE addons SET tmp_id = addon_id;
ALTER TABLE addons ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE addons DROP COLUMN addon_id CASCADE;
ALTER TABLE addons RENAME COLUMN tmp_id TO addon_id;
ALTER TABLE addons ADD PRIMARY KEY(addon_id);

ALTER TABLE charges ADD COLUMN tmp_id INT;
UPDATE charges SET tmp_id = charge_id;
ALTER TABLE charges ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE charges DROP COLUMN charge_id CASCADE;
ALTER TABLE charges RENAME COLUMN tmp_id TO charge_id;
ALTER TABLE charges ADD PRIMARY KEY(charge_id);

ALTER TABLE cdrequests ADD COLUMN tmp_id INT;
UPDATE cdrequests SET tmp_id = id;
ALTER TABLE cdrequests ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE cdrequests DROP COLUMN id CASCADE;
ALTER TABLE cdrequests RENAME COLUMN tmp_id TO id;
ALTER TABLE cdrequests ADD PRIMARY KEY(id);

ALTER TABLE ltsresume ADD COLUMN tmp_id INT;
UPDATE ltsresume SET tmp_id = ltsid;
ALTER TABLE ltsresume ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE ltsresume DROP COLUMN ltsid CASCADE;
ALTER TABLE ltsresume RENAME COLUMN tmp_id TO ltsid;
ALTER TABLE ltsresume ADD PRIMARY KEY(ltsid);

ALTER TABLE process_time ADD COLUMN tmp_id INT;
UPDATE process_time SET tmp_id = id;
ALTER TABLE process_time ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE process_time DROP COLUMN id CASCADE;
ALTER TABLE process_time RENAME COLUMN tmp_id TO id;
ALTER TABLE process_time ADD PRIMARY KEY(id);

ALTER TABLE portable_noscale ADD COLUMN tmp_id INT;
UPDATE portable_noscale SET tmp_id = id;
ALTER TABLE portable_noscale ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE portable_noscale DROP COLUMN id CASCADE;
ALTER TABLE portable_noscale RENAME COLUMN tmp_id TO id;
ALTER TABLE portable_noscale ADD PRIMARY KEY(id);

ALTER TABLE public_files ADD COLUMN tmp_id INT;
UPDATE public_files SET tmp_id = pub_id;
ALTER TABLE public_files ALTER COLUMN tmp_id SET NOT NULL;
ALTER TABLE public_files DROP COLUMN pub_id CASCADE;
ALTER TABLE public_files RENAME COLUMN tmp_id TO pub_id;
ALTER TABLE public_files ADD PRIMARY KEY(pub_id);

ALTER TABLE ds_data DROP COLUMN max_box_id;

-- Update the db version
UPDATE ds_data SET db_number = 17 WHERE db_number = 16;
