
CREATE TABLE client_geo_location(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  box_id                  int NOT NULL,
  trace_device            int,
  geo_interval            int,
  geo_time                int, -- was datetime
  geo_type                int,
  geo_latitude            float,
  geo_longitude           float,
  geo_country             varchar(100),
  geo_region              varchar(100),
  geo_city                varchar(100),
  geo_zipcode             varchar(100),
  geo_accuracy            int,
  geo_computer_name       varchar(100),
  geo_ip_address          varchar(100),
  status_date             int, -- was datetime
  FOREIGN KEY  (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY  (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_geo_location_noc ON client_geo_location(noc_id,box_id);
CREATE INDEX idx_client_geo_location_box ON client_geo_location(box_id);

CREATE TABLE client_trace_config(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  account_id              int NULL,
  trace_device            int DEFAULT 0,
  geo_interval            int DEFAULT 30,
  FOREIGN KEY (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY (account_id) REFERENCES customer(account_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_trace_config_acc ON client_trace_config(account_id);
CREATE INDEX idx_client_trace_config_noc ON client_trace_config(noc_id,account_id);


CREATE TABLE client_lock_config(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  box_id                  int NOT NULL,
  lock_device             int,
  lock_password           varchar(100),
  status                  int,
  status_date             int, -- was datetime
  FOREIGN KEY (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_lock_config_box ON client_lock_config(box_id);
CREATE INDEX idx_client_lock_config_noc ON client_lock_config(noc_id,box_id);


CREATE TABLE client_remote_wipe(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  box_id                  int NOT NULL,
  remote_wipe             int,
  req_time                int, -- was datetime
  command                 int,
  req_id                  int,
  path                    varchar(256),
  status                  int,
  status_date             int, -- was datetime
  FOREIGN KEY (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY  (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_remote_wipe_box ON client_remote_wipe(box_id);
CREATE INDEX idx_client_remote_wipe_noc ON client_remote_wipe(noc_id,box_id);

CREATE TABLE client_wipe_config(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  account_id              int NULL,
  remote_wipe             int DEFAULT 0,
  FOREIGN KEY (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY (account_id) REFERENCES customer(account_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_wipe_config_acc ON client_wipe_config(account_id);
CREATE INDEX idx_client_wipe_config_noc ON client_wipe_config(noc_id,account_id);

UPDATE ds_data SET db_number = 204 WHERE db_number = 203;
UPDATE ds_data SET db_number = -204 WHERE db_number = -203;
