
DROP TABLE IF EXISTS ldap_dsbox;
DROP TABLE IF EXISTS ldap_customer;
DROP TABLE IF EXISTS ldap_dssys;

CREATE TABLE ldap_dssys (
    ldap_id     SERIAL PRIMARY KEY,
    ldap_guid   varchar(1024),
    address     varchar(1024),
    description varchar(1024),
    domain      varchar(1024),
    username    varchar(1024),
    password    varchar(1024),
    flag        int,
    last_update int
);

CREATE TABLE ldap_customer (
    account_id     int NOT NULL,
    ldap_id        int NULL,
    domain         varchar(1024),
    flag           int,
    last_update    int,
    foreign key    (account_id) references customer(account_id) on delete cascade,
    foreign key    (ldap_id)    references ldap_dssys(ldap_id) on delete set null
);

CREATE TABLE ldap_dsbox (
    box_id         int NOT NULL,
    domain         varchar(1024),
    username       varchar(1024),
    flag           int,
    last_update    int,
    foreign key    (box_id)  references dsbox(box_id) on delete cascade
);

UPDATE ds_data SET db_number = 228 WHERE db_number = 227;
UPDATE ds_data SET db_number = -228 WHERE db_number = -227;
