CREATE TABLE file_delete_logs (
    idx_id         SERIAL PRIMARY KEY,
    delete_time    INT,
    delete_type    INT,
    bset_type      INT,
    dsbox_snum     varchar(24),
    bset_name      varchar(1024),
    dir_name       varchar(1024),
    file_name      varchar(1024),
    user_name      varchar(256),
    backup_time    INT,
    modify_time    INT,
    file_size      BIGINT
);
CREATE INDEX idx_file_delete_logs_del_time ON file_delete_logs(delete_time);
CREATE INDEX idx_file_delete_logs_client ON file_delete_logs(dsbox_snum);
CREATE INDEX idx_file_delete_logs_extra_idx ON file_delete_logs(dsbox_snum, bset_name, bset_type, delete_type, user_name);

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs', -1, 'delete_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'delete_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'delete_type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'user_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'dsbox_snum');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'bset_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'bset_type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'dir_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'file_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'backup_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'modify_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  4, 'file_size');

-- delete_logs
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (100, '1', 'I0;360', 'CleanDeleteLogs',
       'Archive and clean GDPR delete logs older than pre-defined months.(0-disable)');

UPDATE ds_data SET db_number =  233 WHERE db_number =  232;
UPDATE ds_data SET db_number = -233 WHERE db_number = -232;
