DROP INDEX idx_audit;
ALTER TABLE audit RENAME TO ds_audit;
CREATE INDEX idx_audit ON ds_audit(time, table_id);

CREATE TABLE tbl_tmp ( 
  ds_type       int NOT NULL, 
  ds_limit      float NOT NULL, 
  files         int NOT NULL, 
  prot_size     float NOT NULL, 
  dssize        float NOT NULL, 
  generations   float NOT NULL, 
  libraries     int NOT NULL, 
  masters       int NOT NULL, 
  mastersdssize float NOT NULL, 
  deltas        int NOT NULL, 
  deltasdssize  float NOT NULL, 
  blocks        int NOT NULL, 
  dltnewblocks  int NOT NULL, 
  dltclusters   int NOT NULL, 
  twins         int NOT NULL, 
  avdeltasize   float NOT NULL, 
  avmastersize  float NOT NULL
);
INSERT INTO tbl_tmp(ds_type, ds_limit, files, prot_size, dssize, 
            generations, libraries, masters, mastersdssize, deltas, 
            deltasdssize, blocks, dltnewblocks, dltclusters, twins, 
            avdeltasize, avmastersize) SELECT type, "limit", files, 
            size, dssize, generations, libraries, masters, mastersdssize, 
            deltas, deltasdssize, blocks, dltnewblocks, dltclusters, 
            twins, avdeltasize, avmastersize FROM statisticscan;
DROP TABLE statisticscan;
ALTER TABLE tbl_tmp RENAME TO statisticscan;
ALTER TABLE statisticscan ADD PRIMARY KEY (ds_type, ds_limit);

CREATE TABLE tbl_tmp ( 
        charge_id            INT NOT NULL, 
        id                   int NOT NULL, 
        dsbox_snum           varchar(24) NOT NULL, 
        effective_date       int NOT NULL, 
        item_num             int NOT NULL, 
        quantity             int NOT NULL, 
        amount               float NOT NULL, 
        remark               varchar(100) 
);
INSERT INTO tbl_tmp(charge_id, id, dsbox_snum, effective_date, item_num, 
            quantity, amount, remark) SELECT charge_id, id, dsbox_snum, 
            date, item_num, quantity, amount, remark FROM charges;
DROP INDEX idx_andcharge;
DROP TABLE charges;
ALTER TABLE tbl_tmp RENAME TO charges;
ALTER TABLE charges ADD PRIMARY KEY (charge_id);
CREATE INDEX idx_andcharge ON charges (dsbox_snum, effective_date);

CREATE TABLE tbl_tmp ( 
    id                   INT NOT NULL, 
    item_num             int NOT NULL, 
    item_name            varchar(50) NOT NULL, 
    charge_type          smallint NOT NULL, 
    price                float NOT NULL, 
    charge_unit          varchar(20), 
    c_u                  varchar(7), 
    price_type           int, 
    effective_date       int NOT NULL 
);
INSERT INTO tbl_tmp(id, item_num, item_name, charge_type, price, 
            charge_unit, c_u, price_type, effective_date) SELECT id, 
            item_num, item_name, charge_type, price, charge_unit, 
            c_u, price_type, date FROM charge_items;
DROP INDEX idx_charge_time;
DROP TABLE charge_items;
ALTER TABLE tbl_tmp RENAME TO charge_items;
CREATE SEQUENCE charge_items_id_seq;
SELECT setval('charge_items_id_seq', (SELECT MAX(id) FROM charge_items));
ALTER TABLE charge_items ALTER COLUMN id SET DEFAULT nextval('charge_items_id_seq');
ALTER TABLE charge_items ADD PRIMARY KEY (id);
CREATE INDEX idx_charge_time ON charge_items(item_num,effective_date);

ALTER TABLE charges ADD FOREIGN KEY(id) REFERENCES charge_items ON DELETE CASCADE;
ALTER TABLE charges ADD FOREIGN KEY(dsbox_snum) REFERENCES dsbox(dsbox_snum) ON DELETE CASCADE;

CREATE TABLE tbl_tmp ( 
       addon_id        INT NOT NULL, 
       id              int NOT NULL, 
       dsbox_snum      varchar(24) NOT NULL, 
       effective_date  int NOT NULL, 
       addon_num       int NOT NULL, 
       serial_num      varchar(20) NOT NULL, 
       remark          varchar(50), 
       last_user       varchar(20) 
);
INSERT INTO tbl_tmp(addon_id, id, dsbox_snum, effective_date, addon_num, 
            serial_num, remark, last_user) SELECT addon_id, id, dsbox_snum, 
            date, addon_num, serial_num, remark, last_user FROM addons;
DROP INDEX SerialNo;
DROP INDEX andaddon;
DROP TABLE addons;
ALTER TABLE tbl_tmp RENAME TO addons;
ALTER TABLE addons ADD PRIMARY KEY (addon_id);
CREATE UNIQUE INDEX SerialNo ON addons (addon_num, serial_num);
CREATE INDEX andaddon ON addons (dsbox_snum, effective_date);
ALTER TABLE addons ADD FOREIGN KEY(dsbox_snum) REFERENCES dsbox(dsbox_snum) ON DELETE CASCADE;

-- Update the db version
UPDATE ds_data SET db_number = 29 WHERE db_number = 28;
