-- save the old table at first
ALTER TABLE ds_config RENAME TO ds_config1;

-- Hold the configuration of DS-System
CREATE TABLE ds_config (
  cfg_id    INT NOT NULL,
  cfg_name  VARCHAR(256),
  cfg_value INT,
  min_value INT,
  max_value INT,
  cfg_text  VARCHAR(1024)
);

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (1, 1, 0, 1, 'RecycleSwitch', 'Recycle Master/Delta Switch');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (2, 0, 0, 1, 'AutoHealing', 'Automatically start Autonomic Healing');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (3, 3, 1, 16, 'HealingProcess', 'Number of Autonomic Healing processes to start automatically');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (4, 0, 0, 1, 'DisasterRecoveryMode', 'DS-System mode: Regular / Disaster Recovery');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (5, 4, 1, 100, 'RecoveryProcess', 'Maximum number of concurrent Disaster Recovery processes on each node');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (6, 1, 0, 20, 'SysAdminProcess', 'Maximum number of concurrent System Admin processes on each node');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (7, 8, 0, 23, 'SysAdminStart', 'Schedule System Admin process to start at this time (24-hour format)');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (8, -1, 0, 24, 'SysAdminEnd', 'Force scheduled System Admin process to end at this time (24-hour format, 24=no end time)');

INSERT INTO ds_config(cfg_id,cfg_value,min_value,max_value,cfg_name,cfg_text) 
       VALUES (9, -1, 0, 1, 'DirectorMode', 'DS-Director mode: DS-Director only / DS-Director & DS-System');

-- use cfg_id < 0 for special configuration
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-1,0,'recycle_option');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-2,0,'recycle_gens');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-3,0,'recycle_days');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-4,0,'recycle_size');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-5,0,'skip_sysadm');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_name) VALUES (-6,15,'recycle_percentage');

-- update the new ds_config using old data
UPDATE ds_config SET cfg_value = (SELECT recycle_switch FROM ds_config1) WHERE cfg_id = 1;
UPDATE ds_config SET cfg_value = (SELECT start_healing FROM ds_config1) WHERE cfg_id = 2;
UPDATE ds_config SET cfg_value = (SELECT healing_process FROM ds_config1) WHERE cfg_id = 3;
UPDATE ds_config SET cfg_value = (SELECT disaster_recovery FROM ds_config1) WHERE cfg_id = 4;
UPDATE ds_config SET cfg_value = (SELECT disaster_process FROM ds_config1) WHERE cfg_id = 5;
UPDATE ds_config SET cfg_value = (SELECT max_sysadm FROM ds_config1) WHERE cfg_id = 6;
UPDATE ds_config SET cfg_value = (SELECT start_sysadm FROM ds_config1) WHERE cfg_id = 7;
UPDATE ds_config SET cfg_value = (SELECT end_sysadm FROM ds_config1) WHERE cfg_id = 8;
UPDATE ds_config SET cfg_value = (SELECT director_type FROM ds_config1) WHERE cfg_id = 9;
UPDATE ds_config SET cfg_value = (SELECT recycle_option FROM ds_config1) WHERE cfg_id = -1;
UPDATE ds_config SET cfg_value = (SELECT recycle_gens FROM ds_config1) WHERE cfg_id = -2;
UPDATE ds_config SET cfg_value = (SELECT recycle_days FROM ds_config1) WHERE cfg_id = -3;
UPDATE ds_config SET cfg_value = (SELECT recycle_size FROM ds_config1) WHERE cfg_id = -4;
UPDATE ds_config SET cfg_value = (SELECT skip_sysadm FROM ds_config1) WHERE cfg_id = -5;

-- remove old table
DROP TABLE ds_config1;
ALTER TABLE ds_config ADD PRIMARY KEY (cfg_id);

-- Update the db version
UPDATE ds_data SET db_number = 33 WHERE db_number = 32;
