CREATE TABLE storage_history (
        box_id              int NOT NULL,
        record_time         int NOT NULL, -- datetime
        protected_size      float NOT NULL,-- current protected size
        stored_size         float NOT NULL,-- current stored size
        protected_size_avg  float NOT NULL,-- average protected size from beginning of the month to current time
        stored_size_avg     float NOT NULL,-- average stored size from beginning of the month to current time
        protected_size_max  float NOT NULL,-- maximum protected size from beginning of the month to current time
        stored_size_max     float NOT NULL -- maximun stored size from beginning of the month to current time
);

CREATE INDEX idx_box_history_id on storage_history
(
        box_id,  -- box_id first
        record_time
);

CREATE TABLE storage_his_settings (
        cust_id     int      not null ,
        box_id      int      not null ,
        interval    int      not null ,  -- unit: minute
        keeplog     int      not null    -- unit: month
);

CREATE UNIQUE INDEX idx_box_cust_id on storage_his_settings
(
        box_id,  -- box_id first
        cust_id
);

ALTER TABLE dsbox_size ADD lib_size float;
ALTER TABLE dsbox_size ADD reset_time int;
ALTER TABLE dsbox_size ADD prot_update_time int;
ALTER TABLE dsbox_size ADD ds_update_time int;
ALTER TABLE dsbox_size ADD prot_avg float;
ALTER TABLE dsbox_size ADD ds_avg float;
ALTER TABLE dsbox_size ADD prot_max float;
ALTER TABLE dsbox_size ADD ds_max float;

ALTER TABLE billing_scale ADD last_user varchar(20);
ALTER TABLE billing_scale ADD calculate_method int;

ALTER TABLE private_files ADD backup_time int;

INSERT INTO storage_his_settings(cust_id, box_id, interval, keeplog)
       VALUES (0,0,1440,3);

INSERT INTO storage_his_settings(cust_id, box_id, interval, keeplog)
       ( SELECT a.account_id, b.box_id, 1440, 3
         FROM dsbox b, customer a WHERE a.account_num=b.account_num);

INSERT INTO storage_his_settings(cust_id, box_id, interval, keeplog)
       ( SELECT a.account_id, 0, 1440, 3 FROM customer a );

UPDATE ds_data SET db_number = 4 WHERE db_number = 3;
