-- PostgreSQL is faster to completely re-create the table than adding a column and updating (because of row size increases)
-- ALTER TABLE connection_log ADD account_num varchar(20);
-- ALTER TABLE connection_log ADD set_id INT;
-- UPDATE connection_log SET account_num = (SELECT max(b.account_num) FROM dsbox b WHERE b.dsbox_snum = connection_log.dsbox_snum);

CREATE TABLE connection_log_new(
      dsbox_snum              varchar(24) NOT NULL ,
      account_num             varchar(20),
      set_id                  int,
      connect_time            int, --datetime
      start_session_time      int, --datetime
      end_session_time        int, --datetime
      files                   int,
      online_delta            float,
      online_amount           float,
      transmit_amount         float,
      arch_amount             float,
      status                  int,
      completion              int,
      session_type            int,
      session_id              INT NOT NULL PRIMARY KEY,
      description             varchar(1024),
      dsdelta_amount          float,
      lib_amount              float,
      owner_id                int,
      new_amount              float,
      new_files               int,
      cluster_id 	            int,
      system_address          varchar(128)
);

INSERT INTO connection_log_new (dsbox_snum, account_num, set_id, connect_time, start_session_time, end_session_time,
      files, online_delta, online_amount, transmit_amount, arch_amount, status, completion, session_type, session_id,
      description, dsdelta_amount, lib_amount, owner_id, new_amount, new_files, cluster_id, system_address)
SELECT c.dsbox_snum, b.account_num, NULL, c.connect_time, c.start_session_time, c.end_session_time,
      c.files, c.online_delta, c.online_amount, c.transmit_amount, c.arch_amount, c.status, c.completion, c.session_type, c.session_id,
      c.description, c.dsdelta_amount, c.lib_amount, c.owner_id, c.new_amount, c.new_files, c.cluster_id, c.system_address
FROM connection_log c LEFT JOIN dsbox b ON c.dsbox_snum = b.dsbox_snum;

DROP TABLE connection_log;
ALTER TABLE connection_log_new RENAME TO connection_log;

-- re-create indexes lost after re-creation
CREATE INDEX connlog_box_type ON connection_log(dsbox_snum, session_type);
CREATE INDEX connlog_start ON connection_log(start_session_time);

-- speed up the backup status report
CREATE INDEX connlog_type_and_start ON connection_log(session_type, start_session_time);
CREATE INDEX connlog_type ON connection_log(session_type);

-- startup speedup on ds-system stop, specific for postgresql
CREATE INDEX connlog_no_end_act ON connection_log(cluster_id) WHERE end_session_time IS NULL;

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 6, 'account_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 2, 'set_id');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'set_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'box_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'req_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 6, 'set_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'active');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES 
      ('backup_sets', 0, 'box_id IN (SELECT box_id FROM dsbox WHERE account_num = :AccountNum)');


CREATE TABLE backup_sets (
  set_id       SERIAL PRIMARY KEY,
  box_id       INT NOT NULL,
  req_id       INT NOT NULL,
  set_name     varchar(765) NOT NULL,
  active       INT NOT NULL
);

CREATE INDEX idx_bsets_box_id ON backup_sets(box_id);

INSERT INTO ds_config(cfg_id, cfg_value, cfg_name, cfg_text)
       VALUES (-11, 0, 'runtime_db_update', 'At what level of runtime DB update is the database');

-- this would update the existing connection_log once the backup sets are inserted (not yet)
-- and this is likely to be VERY SLOW
-- UPDATE connection_log SET set_id = s.set_id FROM backup_sets s, dsbox b WHERE b.box_id = s.box_id 
-- AND connection_log.dsbox_snum = b.dsbox_snum and connection_log.description LIKE '%' || replace(s.set_name, '\\', '\\\\') || '%';

UPDATE ds_data SET db_number = 59 WHERE db_number = 58;
