-- create database dssystem;
-- use dssystem;

/* Holds the event log
 */
CREATE TABLE event_log(
  ev_id    SERIAL PRIMARY KEY,
  type     int,
  ev_time  int,
  category int,
  error    int,
  ev_text  varchar(1024),
  userid   varchar(20),
  ex_long  int,
  ex_text  varchar(1024)
);

CREATE INDEX idx_ev_time ON event_log(ev_time);
CREATE INDEX idx_ex_long ON event_log(ex_long);

/* Our audit table
 */
CREATE TABLE ds_audit(
        idx_id               SERIAL PRIMARY KEY,
        time                 int not null, -- datetime
        userid               varchar(256) not null,
        type                 int not null,
        table_id             int not null,
        table_name           varchar(50) not null,
        remark               varchar(1024) null
);
 
CREATE INDEX idx_audit ON ds_audit(time, table_id);

CREATE TABLE customer(
        account_id           INT NOT NULL PRIMARY KEY,
        account_num          varchar(20) NOT NULL UNIQUE,
        company_name         varchar(50),
        contact              varchar(30),
        rep_id               int,
        location_id          int,
        status               int,
        enc_cookie           bytea,
        status_date          int, --was datetime
        email                varchar(50),
        billing_location_id  int,
        last_invoice         int, --was datetime
        export_path          varchar(1024),
        bill_scale1          int,
        bill_scale2          int,
        bill_expire          int, -- was datetime
        sla_scale            int,
        blm_scale_id         int,
        flag                 int NOT NULL default 0,
        customer_sid         varchar(12) NULL,
        ext_group_id         INT,
        deltachain_cfg_id    INT,
        branding_dir         varchar(100) NULL
);

CREATE INDEX idx_customer_num ON customer(account_num);

/* The client information database
 */
CREATE TABLE dsbox(
        box_id               INT NOT NULL PRIMARY KEY,
        dsbox_snum           varchar(24) NOT NULL UNIQUE,
        account_num          varchar(20) ,
        status               int,
        status_date          int, -- datetime
        type                 int,
        connect_type         int,
        ip_phone             varchar(20),
        flags                int,
        service_start_date   int, --datetime
        service_end_date     int, --datetime
        contact              varchar(30),
        location_id          int,
        billing_location_id  int,
        billing_scale        int,
        billing_scale_due    int, -- datetime
        second_billing_scale int,
        enc_cookie           bytea,
        creation_date        int, --datetime
        last_invoice         int, --datetime
        consolidation        int,
        scan_flag            float,
        last_sysadm          int,
        backup_status        int,
        clear_date           int, --datetime
        credit_scale         int,
        blm_scale_id         int,
        new_system_ip        TEXT,
        new_dsbox_snum       varchar(24),
        description          varchar(1024),
        new_account_num      varchar(20),
        foreign key (account_num)  references customer(account_num) on delete CASCADE,
        ext_group_id         INT,
        activation_date      int, --datetime
        multiple             int NOT NULL default 0,  -- number of clients allowed
        lock_sched_id        INT,
        deltachain_cfg_id    INT,
        upgrade_priority     INT,
        template_dsbox_snum  varchar(24),
        enc_settings         int
);

CREATE TABLE dsbox_address (
	box_id            int,
	from_addr         varchar(32),
	to_addr           varchar(32),
	foreign key  (box_id) references dsbox(box_id) on delete cascade
);

CREATE INDEX dsbox_address_idx ON dsbox_address(box_id);

CREATE TABLE dsbox_cluster (
    box_id            int,
    box_cluster_id    int,
    name              varchar(256),
    reg_no            bytea,
    client_version    TEXT,
    client_type       INT,
    last_upgrade      INT,
    upgrade_status    INT,
    primary key  (box_id, box_cluster_id),
    foreign key  (box_id) references dsbox(box_id) on delete cascade
);

CREATE TABLE dsbox_quota (
        box_id             int PRIMARY KEY references dsbox on delete CASCADE,
        account_id         int NOT NULL,
        quota              int NOT NULL ,
        quota_unit         int NOT NULL ,
        method             int NOT NULL ,
        flag               int NOT NULL,
        warning_level1     int NOT NULL ,
        warning_level2     int NOT NULL ,
        warning_level3     int NOT NULL ,
        stop_level         int NOT NULL,
        last_warning_level int NOT NULL,
        last_warning_time  int NULL
); 


CREATE TABLE disaster_restore_path (
	box_id          int PRIMARY KEY references dsbox on delete cascade,
	restore_path    varchar (1024)
);

CREATE TABLE customer_quota (
         account_id          int PRIMARY KEY,
         flag                int NOT NULL ,
         quota               int NOT NULL ,
         quota_unit          int NOT NULL ,
         method              int NOT NULL ,
         warning_level1      int NOT NULL ,
         warning_level2      int NOT NULL ,
         warning_level3      int NOT NULL ,
         stop_level          int NOT NULL,
         box_quota           int NOT NULL ,
         box_quota_unit      int NOT NULL ,
         box_method          int NOT NULL ,
         box_warning_level1  int NOT NULL ,
         box_warning_level2  int NOT NULL ,
         box_warning_level3  int NOT NULL ,
         box_stop_level      int NOT NULL,
         last_warning_level  int NOT NULL,
         last_warning_time   int NULL
 );


INSERT INTO customer_quota (account_id,flag,quota,quota_unit,method,warning_level1,
	warning_level2,warning_level3,stop_level, box_quota,box_quota_unit,box_method,
	box_warning_level1,box_warning_level2,box_warning_level3,
	box_stop_level,last_warning_level,last_warning_time)
        VALUES(0,0,0,2,0,75,85,95,10,0,2,0,75,85,95,10,0,
	date_part('epoch',cast('2000-01-01'as timestamp)));        
INSERT INTO customer_quota (account_id,flag,quota,quota_unit,method,warning_level1,
	warning_level2,warning_level3,stop_level, box_quota,box_quota_unit,box_method,
	box_warning_level1,box_warning_level2,box_warning_level3,
	box_stop_level,last_warning_level,last_warning_time)
        VALUES(-1,0,0,2,0,75,85,95,10,0,2,0,75,85,95,10,0,
	date_part('epoch',cast('2000-01-01'as timestamp)));        
INSERT INTO customer_quota (account_id,flag,quota,quota_unit,method,warning_level1,
	warning_level2,warning_level3,stop_level, box_quota,box_quota_unit,box_method,
	box_warning_level1,box_warning_level2,box_warning_level3,
	box_stop_level,last_warning_level,last_warning_time)
        VALUES(-2,0,0,2,0,75,85,95,10,0,2,0,75,85,95,10,0,
	date_part('epoch',cast('2000-01-01'as timestamp)));        


/* Holds the activity log
 */
CREATE TABLE connection_log(
      dsbox_snum              varchar(24) NOT NULL ,
      account_num             varchar(20),
      set_id                  int,
      connect_time            int, --datetime
      start_session_time      int, --datetime
      end_session_time        int, --datetime
      files                   int,
      online_delta            float,
      online_amount           float,
      transmit_amount         float,
      arch_amount             float,
      status                  int,
      warning                 int,
      completion              int,
      session_type            int,
      session_id              INT NOT NULL PRIMARY KEY,
      description             varchar(1024),
      dsdelta_amount          float,
      lib_amount              float,
      owner_id                int,
      new_amount              float,
      new_files               int,
      cluster_id              int,
      system_address          varchar(128),
      sub_type                int,
      client_sessid           int,
      client_stop             int,
      client_errors           int,
      client_warnings         int
);

CREATE INDEX connlog_box_type ON connection_log(dsbox_snum, session_type);
CREATE INDEX connlog_start ON connection_log(start_session_time);
CREATE INDEX connlog_type_and_start ON connection_log(session_type, start_session_time);
CREATE INDEX connlog_type ON connection_log(session_type);

-- startup speedup on ds-system stop, specific for postgresql
CREATE INDEX connlog_no_end_act ON connection_log(cluster_id) WHERE end_session_time IS NULL;

CREATE TABLE backup_sets (
  set_id            SERIAL PRIMARY KEY,
  box_id            INT NOT NULL,
  req_id            INT NOT NULL,
  set_name          varchar(765) NOT NULL,
  active            INT NOT NULL,
  lastbkup_comp     INT NULL,
  lastbkup_time     INT NULL,
  lastbkup_sys_sess INT NULL,
  lastbkup_sys_err  INT NULL,
  lastbkup_sys_warn INT NULL,
  lastbkup_clt_sess INT NULL,
  lastbkup_clt_err  INT NULL,
  lastbkup_clt_warn INT NULL,
  lastbkup_clt_stop INT NULL,
  last_validation   INT,
  delete_time       INT,
  last_delta_fix    INT,
  set_type          INT,
  files             INT,
  prot_size         bigint,
  ds_size           bigint
);

CREATE INDEX idx_bsets_box_id ON backup_sets(box_id);

CREATE TABLE dsset_sysadmin_req (
   set_id        int   NOT NULL,
   flags         int,
   request_time  int,
   FOREIGN KEY (set_id) REFERENCES backup_sets(set_id) ON DELETE CASCADE
);

/* create cdspecs table */
CREATE TABLE cdspecs (
  media varchar (15)    NOT NULL PRIMARY KEY,
  type                  int NULL ,
  capacity              int NULL ,
  guardsize             int NULL ,
  fixedoh               int NULL ,
  filefixedoh           int NULL ,
  filevaroh             int NULL ,
  blocksize             int NULL ,
  unitprice             float NULL ,
  fixedprice            float NULL 
);

CREATE TABLE statisticscan (
  ds_type       int NOT NULL,
  ds_limit      float NOT NULL,
  files         int NOT NULL,
  prot_size     float NOT NULL,
  dssize        float NOT NULL,
  generations   float NOT NULL,
  libraries     int NOT NULL,
  masters       int NOT NULL,
  mastersdssize float NOT NULL,
  deltas        int NOT NULL,
  deltasdssize  float NOT NULL,
  blocks        int NOT NULL,
  dltnewblocks  int NOT NULL,
  dltclusters   int NOT NULL,
  twins         int NOT NULL,
  avdeltasize   float NOT NULL,
  avmastersize  float NOT NULL,
  PRIMARY KEY (ds_type, ds_limit)
);


CREATE TABLE statisticscanstate (
  connecttime   int  NULL,
  text          varchar (1024) NULL,
  endtime       int  NULL,
  autoresume    int  NULL,
  runtimepoint  varchar (1024) NULL,
  PRIMARY KEY (connecttime, text, endtime, autoresume, runtimepoint)
);


INSERT INTO statisticscanstate VALUES (0,'',0,0,'');


CREATE TABLE charge_items (
    id                   SERIAL PRIMARY KEY,
    item_num             int NOT NULL,
    item_name            varchar(50) NOT NULL,
    charge_type          smallint NOT NULL,
    price                float NOT NULL,
    charge_unit          varchar(20) NULL,
    c_u                  varchar(7) NULL,
    price_type           int,
    effective_date       int NOT NULL --datetime
);

CREATE INDEX idx_charge_time ON charge_items(item_num,effective_date);

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -12, 'Connect Time for Internet', 0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -11, 'Connect Time for ATM', 0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -10, 'Connect Time for ISDN/T1', 0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -9, 'Connect Time for ISDN/PRI 21-23 channels',0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -8, 'Connect Time for ISDN/PRI 17-20 channels',0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -7, 'Connect Time for ISDN/PRI 13-16 channels',0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -6, 'Connect Time for ISDN/PRI 9-12 channels',0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -5, 'Connect Time for ISDN/PRI 5-8 channels',0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -4, 'Connect Time for ISDN/PRI 4 channels',0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -3, 'Connect Time for ISDN/BRI',0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -2, 'Connect Time for SW56',    0, 0, 'per minute','/min', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( -1, 'Connect Time for LAN',    0, 0.0, 'N/A','', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 20, '* LTS CD  Restore Charge', 1, 0, 'LTS CD  Restore','', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 21, '* LTS DVD Restore Charge', 1, 0, 'LTS DVD Restore','', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 22, '* LTS DLT Restore Charge', 1, 0, 'LTS DLT Restore','', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 23, '* LTS UNC Sub Sys Charge', 1, 0, 'LTS UNC Sub Sys','', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 81, '* Installation Charge', 1, 0, 'DS-Client','', 0, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 30, '* Non Repudiation Storage Charge', 1, 0, 'Transaction','', 1, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 24, '* LTS CD  Service Charge', 1, 0, 'LTS CD  Service','', 0, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 25, '* LTS DVD Service Charge', 1, 0, 'LTS DVD Service','', 0, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 26, '* LTS DLT Service Charge', 1, 0, 'LTS DLT Service','', 0, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 27, '* LTS UNC Service Charge', 1, 0, 'LTS UNC Service','', 0, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 160, '* SLA Credit - Unavailability', 1, 0, 'SLA Unavailability','', 0, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 161, '* SLA Credit - Portable', 1, 0, 'SLA Portable','', 0, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 162, '* SLA Credit - Disc/Tape', 1, 0, 'SLA Disc/Tape','', 0, date_part('epoch',cast('1996-01-01'as timestamp)));

INSERT INTO charge_items (item_num, item_name, charge_type,price,charge_unit,c_u,price_type,effective_date) 
       VALUES ( 100, '* LAN Storage Discovery Charge', 1, 0, 'Process','', 0, date_part('epoch',cast('1996-01-01'as timestamp)));

/* create charges table */
CREATE TABLE charges (
        charge_id            INT NOT NULL PRIMARY KEY,
        id                   int NOT NULL,
        dsbox_snum           varchar(24) NOT NULL,
        effective_date       int NOT NULL,
        item_num             int NOT NULL,
        quantity             int NOT NULL,
        amount               float NOT NULL,
        remark               varchar(100) NULL,
        foreign key (id) references charge_items on delete cascade, 
        foreign key (dsbox_snum) references dsbox(dsbox_snum) on delete cascade
 );

CREATE INDEX idx_andcharge ON charges (dsbox_snum, effective_date);

CREATE TABLE slahistory (
        idx_id               SERIAL PRIMARY KEY,
        from_date            int NOT NULL,
        to_date              int  NULL,
        client               varchar(24) null,
        dsi_errors           int NULL DEFAULT 0,
        ssp_errors           int NULL DEFAULT 0,
        minutes              int NULL DEFAULT 0,  -- for runing tag now 
        min_credit           int NULL DEFAULT 0,
        status               int NULL DEFAULT 0,
        reboot               int NULL DEFAULT 0
);

CREATE TABLE location_billing (
        id                   INT NOT NULL PRIMARY KEY,
        po_num               varchar(20) NULL,
        billing_plan         int NOT NULL,
        bank_name            varchar(50) NULL,
        bank_account         varchar(20) NULL,
        exp_date             int NULL, -- datetime
        bank_addr            varchar(50) NULL,
        tax1                 int,
        tax2                 int,
        tax1_exemp           varchar(30) NULL,
        tax2_exemp           varchar(30) NULL,
        contact              varchar(30) NOT NULL,
        bill_on              int NOT NULL
 );

CREATE TABLE billing_scale (
        scale_id           INT NOT NULL PRIMARY KEY,
        name               varchar(30) NOT NULL,
        from_date          int NOT NULL, -- was datetime
        to_date            int NULL,     -- was datetime
        invoice_method     int NOT NULL,
        last_user          varchar(20),
        calculate_method   int NOT NULL default 0
);

CREATE INDEX idx_bill_scale_name ON billing_scale(name);

INSERT INTO billing_scale(scale_id, name, from_date, to_date, invoice_method,
                          calculate_method) 
                   VALUES (1, 'System', date_part('epoch',cast('1996-01-01'as timestamp)), NULL, 0 , 0);

CREATE TABLE billing_options (
        scale_id             int NOT NULL references billing_scale on delete cascade,
        from_date            int NOT NULL, -- was datetime
        max_amount           int NOT NULL,
        base_price           float NOT NULL,
        extra_price          float NOT NULL,
        extra_price_unit     int   NOT NULL default 0,
        PRIMARY KEY (scale_id, from_date, max_amount)
);

CREATE INDEX idx_billing_opt_pk ON billing_options(scale_id, from_date, max_amount);

INSERT INTO billing_options VALUES (1, date_part('epoch',cast('1996-01-01'as timestamp)),  50, 10, 0.32, 0);
INSERT INTO billing_options VALUES (1, date_part('epoch',cast('1996-01-01'as timestamp)), 100, 18, 0.16, 0);
INSERT INTO billing_options VALUES (1, date_part('epoch',cast('1996-01-01'as timestamp)), 250, 30, 0.08, 0);
INSERT INTO billing_options VALUES (1, date_part('epoch',cast('1996-01-01'as timestamp)), 500, 40, 0.08, 0);
INSERT INTO billing_options VALUES (1, date_part('epoch',cast('1996-01-01'as timestamp)),1000, 60, 0.08, 0);
INSERT INTO billing_options VALUES (1, date_part('epoch',cast('1996-01-01'as timestamp)),2000,100, 0.06, 0);
INSERT INTO billing_options VALUES (1, date_part('epoch',cast('1996-01-01'as timestamp)),3000,130, 0.06, 0);
INSERT INTO billing_options VALUES (1, date_part('epoch',cast('1996-01-01'as timestamp)),4000,160, 0.06, 0);

CREATE TABLE blm_billing_scale (
  blm_scale_id     INT NOT NULL PRIMARY KEY,
  blm_scale_name   VARCHAR(256) NOT NULL,
  invoice_method   INT,
  calculate_methon INT
);

CREATE TABLE blm_billing_option (
  blm_scale_id     INT NOT NULL REFERENCES blm_billing_scale ON DELETE CASCADE,
  max_amount       INT NOT NULL,
  base_price       FLOAT,
  extra_price      FLOAT,
  extra_price_unit INT,
  PRIMARY KEY (blm_scale_id, max_amount)
);

create table business_parms (
  parm_id             SERIAL,
  effective_date      int  PRIMARY KEY,
  group_commission    float NOT NULL,
  broker_commission   float NOT NULL,
  tax1                float NOT NULL,
  tax2                float NOT NULL,
  no_connection_charge int, 
  last_user           varchar (20) NULL
);

INSERT INTO business_parms(effective_date, group_commission, broker_commission, tax1, tax2, no_connection_charge, last_user)
       VALUES(date_part('epoch',cast('2006-07-01'as timestamp)),25,5,6,0,0,'dssys');

CREATE TABLE location (
        id                   INT NOT NULL PRIMARY KEY,
        name                 varchar(90) NOT NULL,
        addr1                varchar(90) NOT NULL,
        addr2                varchar(90) NULL,
        city                 varchar(90) NOT NULL,
        prov_state           varchar(5) NOT NULL,
        postal_zip           varchar(10) NOT NULL,
        country              varchar(3) NOT NULL,
        phone                varchar(20) NOT NULL,
        fax                  varchar(20) NULL,
        location_billing_id  int NULL ,
        email_addr           varchar(50) NULL
);


CREATE TABLE bandwidth (
        cust_id           int,
        box_id            int,
        limit_tosystem    int,
        limit_toclient    int,
        schedid_tosystem  int NOT NULL default 0,
        schedid_toclient  int NOT NULL default 0,
        PRIMARY KEY (cust_id, box_id)
);

CREATE INDEX idx_bandwidth ON bandwidth(cust_id, box_id);

CREATE TABLE bandwidth_schedule(
   bw_sched_id    SERIAL PRIMARY KEY,
   name           varchar(50)
);

CREATE TABLE bandwidth_schedule_details(
   bw_sched_id    int NOT NULL,
   week_minute    int,
   bw_limit       int,
   foreign key  (bw_sched_id) references bandwidth_schedule(bw_sched_id) on delete cascade
);

CREATE TABLE report_branding (
  brand_id         SERIAL NOT NULL PRIMARY KEY,
  description      varchar(80) NOT NULL UNIQUE,
  logo_type        int NOT NULL,
  update_time      int NULL,
  is_default       int NULL,
  logo             bytea NOT NULL
);

CREATE TABLE var_data(
        company_name         varchar(50) PRIMARY KEY,
        addr1                varchar(30) NOT NULL,
        addr2                varchar(30) NULL,
        city                 varchar(30) NOT NULL,
        prov_state           varchar(5) NOT NULL,
        postal_zip           varchar(10) NULL,
        country              varchar(3) NOT NULL,
        phone                varchar(20) NULL,
        fax                  varchar(20) NULL,
        contact              varchar(30) NULL,
        sys_id               varchar(12) NOT NULL,
        email_addr           varchar(50) NULL,
        mon_name             varchar(20) NULL,
        mon_ip               varchar(32) NULL,
        last_sla_connecttime int NULL, --datetime
        system_time          int NULL, --datetime
        system_status        smallint NOT NULL default 0,
        stop_type            smallint NOT NULL default 0,
        clear_client_inv     smallint NOT NULL default 1,
        last_clear_client    int, --datetime default now
        currency             varchar(30) NULL default '$',
        currency_pos         int NULL,
        notif_email          varchar(250) NULL,
        lan_discovery_price  float,
        portal_ext_group_id  int
);

DELETE FROM var_data;

/* default sp values. forced to be changed afterwards */
insert into var_data values (' ',' ','',' ',' ',' ',' ',' ',' ' ,' ','XXXX','','','',
            date_part('epoch',now()),date_part('epoch',now()),0,0,1,
            date_part('epoch',now()), '$', 0, '', 0, 0);

CREATE TABLE sale_reps (
        rep_id               INT NOT NULL PRIMARY KEY,
        group_id             int NOT NULL,
        name                 varchar(30) NOT NULL,
        sales_flag           int
);

CREATE UNIQUE INDEX idx_sale_grpid ON sale_reps(group_id, name);

CREATE TABLE sale_groups (
        group_id             INT NOT NULL PRIMARY KEY,
        company_name         varchar(50) NOT NULL,
        addr1                varchar(30) NOT NULL,
        addr2                varchar(30) NULL,
        city                 varchar(30) NOT NULL,
        prov_state           varchar(5) NOT NULL,
        postal_zip           varchar(10) NULL,
        country              varchar(3) NOT NULL,
        phone                varchar(20) NULL,
        fax                  varchar(20) NULL,
        contact              varchar(30) NULL,
        stype                smallint NOT NULL,
        email_addr           varchar(50) NULL,
        scale_id             int NULL,
        flag                 int NULL default 0,
        web_sid              varchar(12) NULL,
        branding             varchar(128) NULL
);

CREATE UNIQUE INDEX idx_sale_grp_nam on sale_groups(company_name);

CREATE TABLE group_commission (
       group_id              int NOT NULL,
       effective_date        int NOT NULL, --datetime NOT NULL,
       commission            float NOT NULL,
       last_user             varchar(20) NULL,
       stype                 smallint NOT NULL,
       PRIMARY KEY (group_id, effective_date)
);

DELETE FROM sale_groups;

INSERT INTO sale_groups (group_id, company_name, addr1, addr2, city,
                         prov_state, postal_zip, country, phone, fax,
                         contact, stype, email_addr)
       VALUES (1, 'In House','N/A','N/A','N/A','??','N/A','???',' ',
               ' ', ' ',0,'');
INSERT INTO sale_reps(rep_id, group_id, name, sales_flag) 
            VALUES (1, 1, '-House Account-', 1);
INSERT INTO group_commission values(1, date_part('epoch',cast('1997-01-02'as timestamp)),25,'dssys', 0);

/* SLA Items
 */
CREATE TABLE sla_credit_scale (
        slascale_id          INT NOT NULL PRIMARY KEY,
        scale_name           varchar(100) NOT NULL,
        unavailable_time     smallint NULL,
        unavailable_price    float NULL,
        portable_time        smallint NULL,
        portable_price       float NULL,
        portable_time2       smallint NULL,
        portable_price2      float NULL,
        disctape_time        smallint NULL,
        disctape_price       float NULL
);


CREATE TABLE bill_plan (
        plan_num             INT NOT NULL PRIMARY KEY,
        plan_name            varchar(30) NOT NULL,
        company_name         varchar(50) NULL,
        addr1                varchar(30) NULL,
        addr2                varchar(30) NULL,
        city                 varchar(30) NULL,
        prov_state           varchar(5) NULL,
        postal_zip           varchar(10) NULL,
        country              varchar(3) NULL,
        phone                varchar(20) NULL,
        fax                  varchar(20) NULL,
        contact              varchar(30) NULL,
        last_user            varchar(20) NULL
);

DELETE FROM bill_plan;

INSERT INTO bill_plan 
       VALUES(0,'Cheque',null,null,null,null,null,null,null,null,null,null,'dssys');
INSERT INTO bill_plan 
       VALUES(1,'Pre-Authorized Draw',null,null,null,null,null,null,null,null,null,null,'dssys');
INSERT INTO bill_plan 
       VALUES(2,'VISA','VISA Accounting Head Office','VISA office address',null,
                'City','ON','ZIPCODE','CAN','0000000000',null,'VISA contact','dssys');
INSERT INTO bill_plan 
       VALUES(3,'MASTERCARD','MASTERCARD Accounting Head Office','MC office address',null,
                'City','ON','ZIPCODE','CAN','0000000000',null,'MC contact','dssys');
INSERT INTO bill_plan 
       VALUES(4,'AMEX','AMEX Accounting Head Office','AMEX office address',null,
                'City','ON','ZIPCODE','CAN','0000000000',null,'AMEX contact','dssys');


/* Contains known provinces for the GUI  */
CREATE TABLE provinces(
        province_code varchar(5),
        province_name varchar(30),
        country_code  varchar(3),
        PRIMARY KEY (country_code, province_code)
);

/* Values taken from the win32 version */
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('??','<unknown>','???');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('  ','  ','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('  ','  ','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('AB','Alberta','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('AK','Alaska','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('AL','Alabama','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('AR','Arkansas','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('AZ','Arizona','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('BC','British Columbia','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('CA','California','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('CO','Colorado','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('CT','Connecticut','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('DC','District of Columbia','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('DE','Delaware','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('FL','Florida','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('GA','Georgia','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('HI','Hawaii','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('IA','Iowa','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('ID','Idaho','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('IL','Illinois','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('IN','Indiana','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('KS','Kansas','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('KY','Kentucky','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('LA','Louisiana','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('MA','Massachusetts','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('MB','Manitoba','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('MD','Maryland','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('ME','Maine','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('MI','Michigan','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('MN','Minnesota','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('MO','Missouri','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('MS','Mississippi','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('MT','Montana','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NB','New Brunswick','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NC','North Carolina','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('ND','North Dakota','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NE','Nebraska','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NL','Newfoundland and Labrador','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NH','New Hampshire','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NJ','New Jersey','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NM','New Mexico','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NS','Nova Scotia','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NT','Northwest Territories','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NV','Nevada','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NY','New York','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('OH','Ohio','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('OK','Oklahoma','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('ON','Ontario','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('OR','Oregon','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('PA','Pennsylvania','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('PE','Prince Edward Island','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('QC','Quebec','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('RI','Rhode Island','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('SC','South Carolina','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('SD','South Dakota','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('SK','Saskatchewan','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('TN','Tennessee','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('TX','Texas','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('UT','Utah','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('VA','Virginia','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('VT','Vermont','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('WA','Washington','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('WI','Wisconsin','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('WV','West Virginia','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('WY','Wyoming','USA');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('YT','Yukon','CAN');
INSERT INTO provinces(province_code, province_name, country_code) VALUES ('NU','Nunavut','CAN');

CREATE TABLE clients_tools (
  box_id                  int PRIMARY KEY references dsbox on delete cascade,
  tools                   bytea,
  tool_detail             bytea,
  last_users_update       INT,
  local_type              int,
  local_capacity          float,
  local_renew             int,
  vdr_local_cnt           int,
  vdr_remote_cnt          int,
  vm_rep_native_quota     float,
  vm_rep_native_size      float,
  vm_rep_count_quota      int,
  vm_rep_count_used       int,
  native_size             float,
  virtual_native_size     float,
  saas_native_size        float,
  machine_used            int,
  virtual_vm_used         int,
  virtual_host_used       int,
  virtual_cpu_used        int,
  saas_user_used          int,
  cyber_used              int
);

CREATE TABLE clients_users (
  box_id                  INT,
  user_name               VARCHAR(256),
  email_addr              TEXT
);

CREATE INDEX idx_clients_users_name ON clients_users(box_id,user_name);

/* Contains a list of DS-Client information
 * (OS / DB / ... )
 */
CREATE TABLE dsclientinfo(
        idx_id         SERIAL PRIMARY KEY,
        box_id         int,
        box_cluster_id int,
        attr_id        int,
        attrname       varchar(50),
        attrvalue      varchar(1024)
);

CREATE INDEX idx_cln_info_boxid ON dsclientinfo(box_id,attr_id);


CREATE TABLE lib_files (
       idx_id               SERIAL PRIMARY KEY,
       pub_id               int NOT NULL,
       account_id           int NOT NULL,
       box_id               int NOT NULL,
       req_id               int NULL,
       bckappl_id           int NULL,
       dir_id               int NOT NULL,
       file_id              int NOT NULL,
       gen_id               int NOT NULL,
       add_date             int NOT NULL
);

CREATE INDEX idx_lib_files_big ON lib_files (account_id, box_id, req_id, dir_id);
CREATE INDEX idx_lib_files_bid ON lib_files (box_id, req_id, dir_id, file_id, gen_id);
CREATE INDEX idx_lib_files_id ON lib_files(pub_id);
CREATE INDEX idx_lib_files_box_id ON lib_files(box_id, req_id, pub_id);
 
CREATE TABLE private_files (
       idx_id               SERIAL PRIMARY KEY,
       first_sig            bytea NOT NULL,
       full_sig             bytea NOT NULL,
       account_id           int NOT NULL,
       box_id               int NOT NULL,
       req_id               int NULL,
       bckappl_id           int NOT NULL,
       dir_id               int NOT NULL,
       file_id              int NOT NULL,
       gen_id               int NOT NULL,
       add_date             int NOT NULL,
       file_size            bigint NOT NULL,
       backup_time          int -- Backup Time
);
 
CREATE INDEX idx_private_files_first ON private_files (first_sig, file_size);
CREATE INDEX idx_private_files_fulls ON private_files (full_sig);
CREATE INDEX idx_private_files_id ON private_files (account_id, box_id, req_id, dir_id, file_id);
CREATE INDEX idx_private_files_add_date ON private_files (add_date);
CREATE INDEX idx_privfil_set ON private_files (box_id, req_id);
CREATE INDEX idx_privfil_lib ON private_files(full_sig, account_id, box_id);
 
CREATE TABLE public_files (
       first_sig            bytea NOT NULL,
       full_sig             bytea NOT NULL,
       pub_id               INT NOT NULL PRIMARY KEY,
       pub_date             int NOT NULL,
       status               int NOT NULL,
       box_id               int NOT NULL,
       account_id           int NOT NULL,
       file_size            bigint NOT NULL,
       ds_size              bigint NULL
);

CREATE INDEX idx_public_files_fulls ON public_files ( full_sig);
CREATE INDEX idx_public_files_first ON public_files ( first_sig, file_size);

CREATE TABLE pub_resume (
       idx_id               SERIAL PRIMARY KEY,
       resume_type          int NOT NULL,
       resume_len           int NOT NULL,
       resume_buff          bytea
);
CREATE INDEX idx_pub_resume_t ON pub_resume(resume_type);

CREATE TABLE maintenance_message (
       message_id           INT NOT NULL PRIMARY KEY,
       message_text         varchar(1024) NULL,
       expiry_date          int NULL, -- datetime DEFAULT getdate(),
       main_interval        smallint NULL,
       message_type         smallint NULL
);

CREATE TABLE clients_event_log (
       ev_id                SERIAL PRIMARY KEY,
       type                 smallint NOT NULL,
       ev_time              int NOT NULL, --datetime NOT NULL,
       category             smallint NOT NULL,
       error                int NOT NULL,
       ev_text              varchar(1024) NULL,
       userid               varchar(20) NULL,
       ex_long              int NULL,
       client_ex_long       int NULL,
       ex_text              varchar(1024) NULL
);

CREATE INDEX idx_cli_ev_userid ON clients_event_log(userid);
CREATE INDEX idx_cli_ev_exlong ON clients_event_log(ex_long);
CREATE INDEX idx_cli_ev_evtime ON clients_event_log(ev_time);

CREATE TABLE cdrequests (
       id                   INT NOT NULL PRIMARY KEY,
       username             varchar (20) NULL ,
       accountid            int NULL ,
       accountnum           varchar (20) NULL ,
       boxid                int NULL ,
       dsboxnumber          varchar (24) NULL ,
       setid                int NULL ,
       settype              smallint NULL ,
       bsetname             varchar (1024) NULL ,
       receivedtime         varchar (20) NULL ,
       producetime          varchar (20) NULL ,
       state                smallint NULL ,
       price                float NULL ,
       disknums             smallint NULL ,
       media                varchar (15) NULL ,
       options              int NULL ,
       mailing              varchar (80) NULL ,
       telephone            varchar (20) NULL ,
       person               varchar (30) NULL ,
       numfiles             int NULL ,
       fbytes               float NULL ,
       vbytes               float NULL ,
       failedfiles          int NULL, 
       buf_dir              varchar (1024) NULL,
       writing_time_in_min  int NULL,
       requestfinishtime    int NULL, -- datetime
       cluster_id           int,  --The cluster id who set the bufer (buf_dir)
	   copies               int,
	   unitprice			float,
	   fixedprice			float
);

CREATE TABLE cd_buffer_path (
  cluster_id      INT,
  buffer_path     VARCHAR(1024)
);

CREATE TABLE dsbox_size (
       box_id            int NOT NULL PRIMARY KEY references dsbox on delete cascade,
       ds_size           float,
       prot_size         float,
       lib_size          float,
       reset_time        int, -- reset average and maximum value time
       prot_update_time  int, -- last update protect average value time
       ds_update_time    int, -- last update stored average value time
       prot_avg          float,    -- average protected size from beginning of the month to current time
       ds_avg            float,    -- average stored size from beginning of the month to current time
       prot_max          float,    -- maximum protected size from beginning of the month to current time
       ds_max            float,    -- maximum stored size from beginning of the month to current time
       blm_update_time   int,
       blm_prot_size     float,
       blm_ds_size       float,
       blm_prot_size_max float,
       blm_ds_size_max   float,
       blm_prot_size_avg float,
       blm_ds_size_avg   float,
       native_upd_time   int,
       native_size       float,
       native_max        float,
       native_avg        float,
       local_prot_size   float,
       local_stored_size float,
       local_native_size float,
	   used_vdr_local_cnt int
);

CREATE TABLE dsset_size (
       box_id            int   NOT NULL REFERENCES dsbox ON DELETE CASCADE,
       req_id            int   NOT NULL,
       ds_size           float NULL,
       prot_size         float NULL,
       blm_ds_size       float NULL,
       blm_prot_size     float NULL,
       lib_size          float NULL,
       native_size       float,
       deleted_size      float,
       max_generations   int,
       min_generations   int,
       curr_generations  int,
       native_upd_time   int,
       cookie            VARCHAR(1024),
       PRIMARY KEY (box_id, req_id)
);

CREATE TABLE persistent_locks(
        add_date       int, -- datetime
        account_id     int NOT NULL,
        box_id         int NOT NULL,
        req_id         int NOT NULL,
        lock_type      int NOT NULL,
        status         int,
        message        varchar(1024),
        PRIMARY KEY (account_id, box_id, req_id, lock_type)
);

CREATE TABLE notification_settings (
        pager_nr                varchar(20),
        retry_int               smallint,
        mon_freq                smallint NOT NULL,
        last_user               varchar(20),
        start_monitor           int,
        email_addr              varchar(255),
        retrytimes              smallint NOT NULL,
        maxdialsec              smallint not null,
        flag                    smallint NOT NULL,
        mail_account            varchar(256),
        mail_psw                varchar(256),
        smtp_addr               varchar (256),
        smtp_user               varchar (64),
        smtp_pwd                varchar (256),
        phonebook_entry         varchar (256),
        modem                   varchar (64),
        smtpdialuser            varchar(64),
        smtpdialpwd             varchar(64),
        PRIMARY KEY (pager_nr, retry_int, mon_freq) -- very small primary key since this is a one-row table
);

insert into notification_settings values ('', 5, 5,'',0,'',3,30,0,'','','','','', '','','','');

CREATE TABLE snmp_config (
        monitor_flag            int NOT NULL,
        time_interval           int NOT NULL,
        heartbeat_interval      int NOT NULL,
        maxmemoryload           int not null,
        maxdiskload             int not null,
        lic_expire              int,
        lic_storage             int,
        lan_process             int,
        PRIMARY KEY (monitor_flag) -- small primary key for one-row table
);
INSERT INTO snmp_config(monitor_flag, time_interval, heartbeat_interval,
                        maxmemoryload, maxdiskload, lic_expire, lic_storage,
                        lan_process) VALUES(0,0,0,90,90,0,0,0);

CREATE TABLE snmp_dest (
        community       varchar(32),
        destination     varchar(32),
        PRIMARY KEY (community, destination)
);


CREATE TABLE head_inv (
       invoice_num          INT NOT NULL PRIMARY KEY,
       from_date            int NOT NULL,
       to_date              int NOT NULL,
       creation_date        int NOT NULL,
       due_date             int NOT NULL,
       p_company_name       varchar(50) NOT NULL,
       p_addr1              varchar(61) NOT NULL,
       p_city               varchar(30) NOT NULL,
       p_prov_state         varchar(5) NOT NULL,
       p_postal_zip         varchar(10) NOT NULL,
       p_phone              varchar(20) NOT NULL,
       p_fax                varchar(20) NOT NULL,
       b_dsbox_snum         varchar(24),
       b_account_num        varchar(20) NOT NULL,
       c_account_id         int NOT NULL,
       c_company_name       varchar(50) NOT NULL,
       s_group_id           int NOT NULL,
       s_group_name         varchar(30) NOT NULL,
       s_rep_id             int NOT NULL,
       s_name               varchar(30) NOT NULL,
       consolidation        smallint NOT NULL,
       l_addr1              varchar(30) NOT NULL,
       l_addr2              varchar(30) NULL,
       l_city               varchar(30) NOT NULL,
       l_prov_state         varchar(5) NOT NULL,
       l_postal_zip         varchar(10) NOT NULL,
       l_country            varchar(20) NOT NULL,
       l_phone              varchar(20) NOT NULL,
       l_fax                varchar(20) NULL,
       bl_addr1             varchar(30) NOT NULL,
       bl_addr2             varchar(30) NULL,
       bl_city              varchar(30) NOT NULL,
       bl_prov_state        varchar(5) NOT NULL,
       bl_postal_zip        varchar(10) NOT NULL,
       bl_country           varchar(20) NOT NULL,
       bl_phone             varchar(20) NOT NULL,
       bl_fax               varchar(20) NULL,
       bl_po_num            varchar(20) NULL,
       bl_billing_plan      smallint NOT NULL,
       bl_bank_name         varchar(50) NULL,
       bl_bank_account      varchar(20) NULL,
       bl_exp_date          int NULL,
       bl_bank_addr         varchar(50) NULL,
       bl_contact           varchar(30) NULL,
       bp_tax1              float NOT NULL,
       bp_tax2              float NOT NULL,
       bl_tax1_exemp        varchar(30) NULL,
       bl_tax2_exemp        varchar(30) NULL,
       crt_online           float NOT NULL,
       crt_archive          float NOT NULL,
       crt_time             float NOT NULL,
       sc_scale_id          int NOT NULL,
       sc_name              varchar(256) NULL,
       sc_todate            int          NULL,
       sc_inv_method        int          NULL,
       sc_cal_method        int          NULL,
       error_dscrpt         varchar(1024) NULL,
       sp_email_addr        varchar(50) NULL,
       l_email_addr         varchar(50) NULL,
       consolidation_date   int NULL, 
       currency             varchar(30) NOT NULL default '$',
       currency_pos         int NOT NULL default 0,
       l_name               varchar(50) NULL,
       amount_unit          int NOT NULL default 0,
       blm_scale_id         INT,
       blm_sc_name          varchar(256)  NULL,
       blm_sc_cal_method    int           NULL,
       blm_sc_inv_method    int           NULL,
       blm_size             FLOAT,
       subtotal             float,
       tax1_amount          float,
       tax2_amount          float,
       grand_total          float,
       evaluation           int  default 0
);
 
CREATE INDEX idx_head_inv0 ON head_inv(to_date, b_account_num);
CREATE INDEX idx_head_inv1 ON head_inv(to_date, b_dsbox_snum);
CREATE INDEX idx_head_inv3 ON head_inv(b_account_num);
 
CREATE TABLE addch_inv (
       aid                  SERIAL PRIMARY KEY,
       invoice_num          int NOT NULL REFERENCES head_inv,
       service_id           int NOT NULL,
       service_type         smallint NOT NULL,
       service_name         varchar(100) NOT NULL,
       qty                  float NOT NULL,
       price                float NOT NULL,
       amount               float NOT NULL,
       price_unit           varchar(7) NULL
);
 
CREATE INDEX addch_inv_num ON addch_inv
(
       INVOICE_NUM
);

CREATE TABLE ds_credit (
       credit_id            INT NOT NULL PRIMARY KEY,
       from_date            int NULL,
       creation_date        int NULL, --datetime NULL,
       computer_name        varchar(256) NULL,
       capacity             float NULL,
       used                 float NULL,
       currency             varchar(30) NOT NULL default '$',
       currency_pos         int NOT NULL default 0 ,
       missing              smallint NULL
);

CREATE TABLE sla_monitor_history (
       from_date            int NOT NULL, --datetime NOT NULL,
       to_date              int NULL, --datetime NULL,
       client               varchar(24) NULL,
       dsi_errors           smallint NULL DEFAULT 0,
       ssp_errors           smallint NULL DEFAULT 0,
       minutes              smallint NULL DEFAULT 0,
       PRIMARY KEY (from_date, to_date, client, dsi_errors, ssp_errors, minutes)
);

CREATE TABLE countries (
       country_code         varchar(3) NOT NULL PRIMARY KEY,
       country_name         varchar(256) NOT NULL 
);

INSERT INTO countries VALUES ('USA','United States');
INSERT INTO countries VALUES ('CAN','Canada');
INSERT INTO countries VALUES ('???','<unknown>');

CREATE TABLE addons (
       addon_id             INT NOT NULL PRIMARY KEY,
       id                   int NOT NULL,
       dsbox_snum           varchar(24) NOT NULL references dsbox (dsbox_snum) on delete cascade,
       effective_date       int NOT NULL,
       addon_num            int NOT NULL,
       serial_num           varchar(20) NOT NULL,
       remark               varchar(50) NULL,
       last_user            varchar(20) NULL
);
 
CREATE UNIQUE INDEX SerialNo ON addons (addon_num, serial_num);
CREATE INDEX andaddon ON addons (dsbox_snum, effective_date);

CREATE TABLE storage (
        st_date              int NOT NULL, 
        dsbox_snum           varchar(24) NOT NULL,
        online_amount        float NOT NULL,
        online_files         int NOT NULL,
        new_amount           float NOT NULL,
        new_files            int NOT NULL,
        transmit_amount      float NOT NULL,
        online_bck           float NOT NULL,
        backup_files         int NOT NULL,
        ds_size              float NOT NULL,
        actual_time          int NOT NULL,
        PRIMARY KEY (st_date, dsbox_snum)
);

CREATE TABLE load_summary (
        sum_time             int NOT NULL, 
        send                 int NOT NULL,
        recv                 int NOT NULL,
        cpu_load             smallint NOT NULL,
        mem_load             smallint NOT NULL,
        mem_commit           int NOT NULL,
        activities           smallint NOT NULL,
        clusterid            int,
        PRIMARY KEY (sum_time, clusterid)
);

CREATE TABLE slaconnectiontime (
        backupproblem   smallint NOT NULL ,
        disctapetime    int NOT NULL , -- datetime
        portablerequest smallint NOT NULL , 
        invalidfiles    smallint NOT NULL,
        PRIMARY KEY (backupproblem, disctapetime, portablerequest, invalidfiles)
);

insert into slaconnectiontime values ( 0,date_part('epoch',cast('2000-01-01'as timestamp)),0,0);

CREATE TABLE migration (
    mig_number           int NOT NULL,
    old_box_id           int NOT NULL,
    new_account_id       int NOT NULL,
    new_box_id           int NOT NULL,
    PRIMARY KEY (mig_number, old_box_id, new_account_id, new_box_id)
);

CREATE TABLE process_time (
  id		INT NOT NULL PRIMARY KEY,
  box_id	int NOT NULL,
  request_time	int NULL,
  time1		int NULL,
  time2		int NULL,
  time3		int NULL,
  receive_time	int NULL,
  status	smallint NULL,
  foreign key (box_id) references dsbox(box_id) on delete cascade
);

CREATE TABLE portable_noscale (
  id		INT NOT NULL PRIMARY KEY,
  box_id	int NOT NULL,
  request_time	int NULL,
  dump_time	int NULL,
  send_time	int NULL,
  status	smallint NULL,
  foreign key (box_id) references dsbox(box_id) on delete cascade
);

CREATE TABLE sla_event (
  idx_id	     SERIAL PRIMARY KEY,
  type		     smallint NOT NULL,
  ev_time	     int NOT NULL,
  cluster_name   varchar(50) NULL,
  company_name   varchar(100) NULL,
  account_num	 varchar(20) NULL,
  dsbox_snum	 varchar(24) NULL
);

CREATE TABLE cluster_events(
  ev_id           SERIAL PRIMARY KEY,
  ev_time         int,    -- the time the event was generated
  system_id       int,    -- the system id (cluste rid)
  ev_no           int,    -- message number
  ev_type         int,    -- type (info, warning, error)
  ev_text         varchar(1024),  -- message text
  ipaddress       varchar (765)
);

CREATE INDEX idx_clust_ev_log_time ON cluster_events(ev_time);

CREATE TABLE storage_history (
        box_id              int NOT NULL,
        record_time         int NOT NULL, -- datetime
        protected_size      float NOT NULL,-- current protected size
        stored_size         float NOT NULL,-- current stored size
        protected_size_avg  float NOT NULL,-- average protected size from beginning of the month to current time
        stored_size_avg     float NOT NULL,-- average stored size from beginning of the month to current time
        protected_size_max  float NOT NULL,-- maximum protected size from beginning of the month to current time
        stored_size_max     float NOT NULL,-- maximun stored size from beginning of the month to current time
        blm_prot_size       float,
        blm_ds_size         float,
        blm_prot_size_max   float,
        blm_ds_size_max     float,
        blm_prot_size_avg   float,
        blm_ds_size_avg     float,
        native_size         float,
        native_max          float,
        native_avg          float,
        local_prot_size     float,
        local_stored_size   float,
        local_native_size   float,
        vm_rep_count_used   int,
        vm_rep_native_size  float,
        PRIMARY KEY (box_id, record_time)
);


CREATE TABLE bset_storage_history(
   box_id               int NOT NULL,
   req_id               int NOT NULL,
   record_time          int NOT NULL, -- was datetime
   protected_size       float NOT NULL, -- current protected size
   stored_size          float NOT NULL, -- current stored size
   native_size          float,
   blm_prot_size        float,
   blm_ds_size          float
);

CREATE INDEX idx_bset_history_id ON bset_storage_history
(
   box_id,
   req_id,
   record_time
);

CREATE TABLE storage_his_settings (
	cust_id     int      NOT NULL,
	box_id      int      NOT NULL,
	interval    int      NOT NULL,  -- unit: minute
	keeplog     int      NOT NULL,  -- unit: month
  PRIMARY KEY (cust_id, box_id)
);

-- add the default history settings
INSERT INTO storage_his_settings(cust_id, box_id, interval, keeplog)
       values (0, 0, 1440, 3);

CREATE TABLE storage_groups (
  ext_group_id   INT NOT NULL PRIMARY KEY,
  ext_group_name VARCHAR(256) NOT NULL,
  ext_group_desc VARCHAR(1024)
);

CREATE TABLE storage_locations(
       id           SERIAL PRIMARY KEY,
       path         varchar(1024) NOT NULL,
       total_size   float NOT NULL,
       guard_size   float NOT NULL,
       used_size    float NOT NULL default 0,
       trash_size   float,
       max_files    int,
       used_files   int,
       trash_files  int,
       ext_group_id INT,
       vol_id       INT
);

CREATE TABLE storage_usage_history (
  id                INT,
  time              INT,
  online_size_add   FLOAT,
  online_size_del   FLOAT,
  online_size_total FLOAT,
  online_file_add   INT,
  online_file_del   INT,
  online_file_total INT,
  trash_size_add    FLOAT,
  trash_size_del    FLOAT,
  trash_size_total  FLOAT,
  trash_file_add    INT,
  trash_file_del    INT,
  trash_file_total  INT,
  PRIMARY KEY (id, time)
);

CREATE TABLE storage_levels(
       levellim       float PRIMARY KEY
);

INSERT INTO storage_levels(levellim) VALUES (0.25);
INSERT INTO storage_levels(levellim) VALUES (0.50);
INSERT INTO storage_levels(levellim) VALUES (0.70);
INSERT INTO storage_levels(levellim) VALUES (0.85);
INSERT INTO storage_levels(levellim) VALUES (0.90);
INSERT INTO storage_levels(levellim) VALUES (0.93);
INSERT INTO storage_levels(levellim) VALUES (0.96);
INSERT INTO storage_levels(levellim) VALUES (0.98);
INSERT INTO storage_levels(levellim) VALUES (0.99);
INSERT INTO storage_levels(levellim) VALUES (0.995);
INSERT INTO storage_levels(levellim) VALUES (0.999);
INSERT INTO storage_levels(levellim) VALUES (0.9995);
INSERT INTO storage_levels(levellim) VALUES (0.9999);

CREATE TABLE dsset_healing (
        box_id          int NOT NULL REFERENCES dsbox ON DELETE CASCADE,
        req_id          int NOT NULL,
        priority        int default 0,
        healing_start   int default 0, --datetime
        healing_end     int default 0, --datetime
        errors          int default 0,
        warnings        int default 0,
        fixed           int default 0,
        checked_files   int default 0,
        checked_size    float default 0,
        checked_dssize  float default 0,
        breakpoint      varchar(1024),
        activity_id     int,
        last_end        int default 0, -- last healing end time
        last_try        int default 0, -- last healing try time
        original_priority int default 0,
        description       varchar(1024),
        options           int,
        PRIMARY KEY (box_id, req_id)
);

-- Hold the configuration of DS-System
CREATE TABLE ds_config (
  cfg_id    INT NOT NULL PRIMARY KEY,
  cfg_name  VARCHAR(256),
  cfg_value VARCHAR(256),
  cfg_constraint VARCHAR(256),
  cfg_text  VARCHAR(1024)
);

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (1, '1', 'I0;1', 'RecycleSwitch', 'Recycle Master/Delta Switch');

-- 2 -> AutoHealing, not used anymore

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (3, '3', 'I1;256', 'HealingProcess', 'Number of Autonomic Healing processes to start automatically');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (4, '0', 'I0;1', 'DisasterRecoveryMode', 'DS-System mode: Regular / Disaster Recovery');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (5, '4', 'I1;100', 'RecoveryProcess', 'Maximum number of concurrent Disaster Recovery processes on each node');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (6, '1', 'I0;20', 'SysAdminProcess', 'Maximum number of concurrent System Admin processes on each node');

-- 7 -> SysAdmin Start, not used anymore
-- 8 -> SysAdmin End, not used anymore

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (9, '-1', 'I0;1', 'DirectorMode', 'DS-Director mode: DS-Director only / DS-Director & DS-System');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (10, '5', 'I1;1000', 'DirScanLimit',
       'How many directories can be opened at the same time by DS-Client Synchronization Process');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (11, '0', 'I0;1', 'FailBackupOnBLMError',
       'If the backup of a generation should fail in the case BLM infinite generations is configured and BLM movement of the old generation fails.');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (12, '0', 'I0;1', 'UseClientSNAP',
       'Use 3rd party snapshot for DS-Client BLM Point in time copy requests.');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (13, '1', 'I0;1', 'ExcludeRecycleDelta',
       'Exclude recycled delta generations for stored size');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (14, '1', 'I0;1', 'AllowUnencryptedConnections',
       'Allow connections to be made using an unencrypted protocol');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (15, '4', 'I1;16', 'RecoveryLibThreads',
       'How many library processing threads should be started for Disaster Recovery');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (16, '0', 'I0;65536', 'MaxBlockSize',
       'The maximum block size for sends. (0 = No maximum)');

-- public library switch
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (17, '1', 'I0;1', 'PubLibSwitch',
       'Global public library switch. (0=>disable,1=>enable public library)');

-- Read-only DS-System
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (18, '0', 'I0;1', 'ReadOnly',
       'Read-only DS-System. (0=>normal, 1=>Read-only DS-System)');

-- Force DR scan during synchronization
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (19, '0', 'I0;1', 'SyncDRScan',
       'Disaster recovery scan during synchronization.');

-- Require DS-Client send native size
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (20, '0', 'I0;2', 'NativeSize',
       'DS-Clients push native size and number of generations to DS-System.(0=>Disabled, 1->Enabled but does not include archived data, 2->Enabled and includes archived data)');

-- Maximum items in private_files
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (21, '1000000', 'I10000;1000000000', 'MaxPrivateItems',
       'Maximum number of potential libraries to keep in DS-System database.');

-- Maximum days in private_files
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (22, '365', 'I60;10000', 'MaxPrivateDays',
       'Maximum days to keep potential libraries in DS-System database.');

-- Online Warning Level
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (23, '500', 'I1;10000', 'OLWarnLevel',
       'Online free space warning level (current value divided by 100 is the percentage).');

-- Online Emergency Level
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (24, '200', 'I1;10000', 'OLEmerLevel',
       'Online free space emergency level (current value divided by 100 is the percentage).');

-- Online Stop Level
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (25, '50', 'I1;10000', 'OLStopLevel',
       'Online free space stop level (current value divided by 100 is the percentage).');

-- Warning pop-up message frequency
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (26, '4', 'I1;24', 'WarnPMFreq',
       'Warning message pop-up frequency (in hours).');

-- Emergency pop-up message frequency
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (27, '1', 'I1;24', 'EmerPMFreq',
       'Emergency message pop-up frequency (in hours).');

-- Free memory warning level
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (28, '0', 'I0;10000', 'MemWarnLevel',
       'Free memory warning level (0=no check).');

-- Free memory emergency level
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (29, '0', 'I0;10000', 'MemEmerLevel',
       'Free memory emergency level (0=no check).');

-- DS-Client auto-upgrade
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (30, '1', 'I-1;1', 'AutoUpgrade', 'DS-Client auto-upgrade (-1 - Rolling upgrade, 0 - disabled, 1 - auto upgrade).');

-- Clean orphaned library links
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (32, '0', 'I0;1', 'CleanLibLink', 'Clean orphaned library links.');

-- Skip database backup
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (35, '0', 'I0;1', 'SkipDBDump', 'Skip database backup.');

-- Database backup method
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (36, '0', 'I0;2', 'DBDumpMethod',
       'Database dump format(0-custom, 1-tar, 2-plain text).');

-- Database backup window begin
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (37, '8', 'I0;23', 'DBDumpStart',
       'Database backup window start hour.');

-- Database backup window end
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (38, '17', 'I0;23', 'DBDumpEnd',
       'Database backup window end hour.');

-- How many days to keep database backup
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (39, '2', 'I1;10000', 'DBDumpDays',
       'How many days to keep database backups.');

-- Allow storage lock for snapshot
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (40, '0', 'I0;1', 'AllowStorageLock',
       'Allow online storage lock for 3rd party snapshot.');

-- event_log
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (41, '12', 'I0;360', 'CleanEventLog',
       'Archive and clean event logs older than pre-defined months.(0-disable)');

-- clients_event_log
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (42, '6', 'I0;360', 'CleanClientEvent',
       'Archive and clean clients event logs older than pre-defined months.(0-disable)');

-- connection_log
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (43, '12', 'I0;360', 'CleanActivityLog',
       'Archive and clean activity logs older than pre-defined months.(0-disable)');

-- load_summary
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (44, '12', 'I0;360', 'CleanLoadSummary',
       'Archive and clean load summary older than pre-defined months.(0-disable)');

-- storage
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (45, '12', 'I0;360', 'CleanStorageSummary',
       'Archive and clean storage summary older than pre-defined months.(0-disable)');

-- healing_history
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (46, '12', 'I0;360', 'CleanHealingHistory',
       'Archive and clean healing history older than pre-defined months.(0-disable)');

-- cluster_events
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (47, '12', 'I0;360', 'CleanClusterEvent',
       'Archive and clean N+1 events older than pre-defined months.(0-disable)');

-- ds_audit
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (48, '0', 'I0;360', 'CleanAudit',
       'Archive and clean audit logs older than pre-defined months.(0-disable)');

-- 49 -> ClientDeleteOption, not user anymore

-- Delete DS-Client Threads
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (50, '2', 'I1;100', 'ClientDeleteThread',
       'How many processing threads should be started for Delete DS-Client.');

-- allow multiple storage on the same valume
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (51, '0', 'I0;1', 'MultiStorage',
       'Allow multiple storage on the same volume.');

-- check_delta_indexes option during autonomic healing
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (52, '0', 'I0;2', 'DeltaCheckOption',
       'Delta validation during Autonomic Healing. (1 - skip delta indexes, 2 - check delta block checksum)');

-- archive and clean storage history
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (53, '12', 'I0;360', 'CleanStorageHistory',
       'Archive and clean storage history older than pre-defined months.(0-disable)');

-- Allow Disaster Recovery process to perform additinal file level validation (library and delta links)?
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (54, '0', 'I0;1', 'RecoveryValidateFile',
       'Enable Disaster Recovery to perform some file level validations. Enabling this option will significantly impact the DR performance. It is recommended that you perform Autonomic Healing instead, since it has more advanced file level validations. (0-disable)');

-- DS-System group
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (55, '0', 'I0;1', 'DSSysGroup',
       'Allow DS-System group for multi-directional replication (0-disable).');

-- DS-System group port
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (56, '4409', 'I1024;65536', 'GrpPort',
       'DS-System group communication port.');

-- Allow DS-System group encrypt communication
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (57, '1', 'I0;1', 'GrpEncrypt',
       'Use encrypted communication for DS-System group.');

-- Maximum number of concurrent replication processes on each node
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (58, '4', 'I0;100', 'ReplicationProcess',
       'Maximum number of concurrent replication processes on each node.');

-- Perform replication check for shared DS-Client interval
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (59, '6', 'I0;360', 'ReplicationCheck',
       'Perform replication check for shared DS-Client interval (in hours, 0-disable).');

-- Replication send threads
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (60, '2', 'I1;100', 'ReplicationSendThreads',
       'How many send threads should be started for replication.');

-- Replication recv threads
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (61, '4', 'I1;100', 'ReplicationRecvThreads',
       'How many receive threads should be started for replication.');

-- Replication del threads
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (62, '2', 'I1;100', 'ReplicationDelThreads',
       'How many delete threads should be started for replication.');

-- normalize delta chain during optimization process
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (64, '0', 'I0;1', 'FixDeltaChain',
       'Fix the long delta chain during optimization process.');

-- define after how many file copies a library gets created
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (65, '3', 'I2;10', 'LibCreateCount',
       'A library file is created after this many copies of the same content is backed up.');

-- DS-System group serial code
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (66, '0', 'I0;2147483647', 'GrpSerialCode',
       'DS-System group serial code.');

-- Threshold for System Admin to consolidate small files
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (67, '10', 'I0;10000', 'SmallFileCount',
       'Threshold for System Admin to consolidate small files.');

-- FileStore cache size for each process
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (68, '2', 'I0;100', 'FileStoreCache',
       'FileStore cache size for each process.');

-- FileStore cache size for E-Mail backup set during backup process
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (69, '10', 'I0;100', 'MLRCache',
       'FileStore cache size for E-Mail backup set during backup process.');

-- Threshold for System Admin to vacuum the FileStore
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (70, '5', 'I0;100', 'FileStoreVacuum',
       'Threshold for System Admin to vacuum the FileStore(percentage).');

-- Database dump path
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (71, '', 'S', 'DBDumpPath', 'Database dump path');


-- Notification of License Expiration
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (72, '7', 'I1;100', 'LicExpireNotif',
       'The number of days prior to license expiration when DS-System sends notification to DS-Operator GUI and the System Event Log.');

-- Notification of Storage Capacity
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (73, '1000', 'I1;10000', 'LicStorageNotif',
       'Licensed storage capacity warning level (percentage left, current value divided by 100 is the percentage).');

-- Frequency of License Notification
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (74, '1', 'I1;24', 'LicNotifFreq',
       'The license expiration and capacity notification frequency (hours).');

-- How many days to keep DS-Client database backup
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (75, '2', 'I1;10', 'ClientDBDumpDays',
       'How many days to keep DS-Client database backups.');

-- Threshold to vacuum the DirStore
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (76, '5', 'I0;100', 'DirStoreVacuum',
       'Threshold to vacuum the DirStore(percentage).');

-- DirStore Safe Mode
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (77, '1', 'I0;1', 'DirStoreSafeMode',
       'Duplicate directory descriptor to DirStore.');

-- SMTP Debug Settings
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (78, '0', 'I0;1', 'SMTPDebug',
       'Log debug information for the SMTP send message process.');

-- storage snapshot
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (79, '0', 'I0;1', 'UseSnapshot',
       'Use storage snapshot for DS-System snapshot-capable processes.');

-- 80 -> MinTrashDays, not used anymore	   

-- trash switch
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (81, '1', 'I0;1', 'TrashSwitch',
       'Trash switch. (0=>disable,1=>enable trash)');

-- empty trash default days
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (82, '7', 'I0;99', 'DefaultTrashDays',
       'Empty trash default days.');

-- Remote DS-VDR - number of times to attempt connection
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
       VALUES (83, 20, 'I0;9999', 'RemoteVDRRetry', 'Maximum number of Remote DS-VDR connection retries.');

-- Remote DS-VDR - number of minutes to wait between connection attempts
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
       VALUES (84, 5, 'I0;99', 'RemoteVDRWait', 'The number of minutes to wait before retrying Remote DS-VDR connection.');

-- hardware registration default timer
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (85, '5', 'I1;10080', 'DefaultHardwareResetTimer',
       'Hardware Registration default timer(minutes).');

-- repair from replication
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (86, '1', 'I0;1', 'RepairFromReplication',
        'Allow Repair from replication');
	   
-- Remote DS-VDR power on priority
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
        VALUES (87, '60', 'I0;3600', 'RemoteVDRPowerOnPrioDelayDef',
        'Default delay time in seconds between power on priority levels during Remote DS-VDR Restore');
	   	   
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
       VALUES (89, 10, 'I0;99', 'RemoteVDRMaxSched', 
       'The maximum number of scheduled Remote DS-VDR activities allowed to run concurrently.');

-- TCP window size (or so called TCP buffer size)
INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
	VALUES(90, '0', 'I0;34752000', 'TcpBufferSize', 'The buffer size for TCP communication. Set to 0 to use default settings from the OS.');

-- TCP "NoDelay" option
INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
	VALUES(91, '-1', 'I-1;1', 'TcpNoDelay', 'Disable or enable the TCP option TCP_NODELAY. Set to 0 to use Nagle algorithm (disable TCP_NODELAY); Set to -1 will use the OS default.');

-- Maximum sending queue size
INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
	VALUES(92, '20', 'I20;1024', 'MaxSendingQueueSize', 'Maximum pending requests in the sending queue.');

-- Maximum receiving queue size
INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
	VALUES(93, '20', 'I20;1024', 'MaxReceivingQueueSize', 'Maximum pending requests in the receiving queue.');

-- Minimum library file size
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES(94, '32', 'I32;102400', 'MinLibFileSize', 'Minimum library file size (KB).');

-- VADP VM configuration ignore list
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
    VALUES (95, 'config\.changeVersion*,config\.extraConfig\..*\.sasWWID,config\.extraConfig\.replay\.filename,config\.files\..*,config\.memoryAllocation\.overheadLimit,config\.extraConfig\.sched\.swap\.derivedName,runtimeInfo\.host\.name', 'S', 'VADPCfgIgnoreList', 'VADP VM configuration ignore list');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
    VALUES (96, 'VIRTUALDISK*,VIRTUALIDECONTROLLER,VIRTUALPS2CONTROLLER,VIRTUALPCICONTROLLER,VIRTUALSIOCONTROLLER,VIRTUALKEYBOARD,VIRTUALMACHINEVMCIDEVICE,VIRTUALVMCIDEVICE,VIRTUALPOINTINGDEVICE', 'S', 'VADPCfgDevIgnoreList', 'VADP VM configuration device ignore list');    

-- File write trunk size
INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
    VALUES(97, '32', 'I32;32768', 'FileWriteTrunkSize', 'File write trunk size (KB).');

-- Maximum communication managers per thread
INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
    VALUES(98, '100', 'I1;100', 'MaxCommunicationManagersPerThread', 'Maximum communication managers per thread.');

-- Maximum communication managers per processing thread
INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
    VALUES(99, '10', 'I1;10', 'MaxCommunicationManagersPerProcessingThread', 'Maximum communication managers per processing thread.');

-- delete_logs
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (100, '1', 'I0;360', 'CleanDeleteLogs',
       'Archive and clean GDPR delete logs older than pre-defined months.(0-disable)');

    
-- USE cfg_id < 0 for special configuration
-- use cfg_id < 0 for special configuration
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name)
	VALUES (-1, '0', 'I', 'recycle_option');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name)
	VALUES (-2, '0', 'I', 'recycle_gens');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name)
	VALUES (-3, '0', 'I', 'recycle_days');
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name)
	VALUES (-4, '0', 'I', 'recycle_size');
-- -5 -> Skip SysAdmin, not used anymore
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name)
	VALUES (-6, '15', 'I', 'recycle_percentage');
-- set default LAN Discovery processes expire period as 2 Weeks
INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name)
	VALUES (-7, '131074', 'I', 'lan_discovery_expire_period');

INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
	VALUES (-9, '0', 'I', 'uncrypted_blm', 'Use uncrypted communication for BLM');

INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
	VALUES (-10, '2', 'I', 'blm_file_process_threads', 'BLM process threads');
INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
	VALUES (-11, '1', 'I', 'runtime_db_update', 'At what level of runtime DB update is the database');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-12, '20', 'I0;9999', 'MaxAdminActivityCount',
       'How many admin activities can be started concurrently');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-13, '120', 'I0;1440', 'MaxAdminWaitingTime',
       'Maximum time (in minutes) that DS-Client admin activities can be delayed.');
-- cfg_id # -14 is exclusively used for a Windows flag

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-15, '0', 'I0;1', 'PersistentLockCustomer',
       'Enable/Disable persistent lock when lock customer.');

INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-16, '1', 'I0;1', 'ExtFSCache',
       'Enable/Disable extensible storage cache.');

-- Storage Label
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-18, '0', 'I0;1', 'StorageLabel',
       'Indicate extensible storage label has been marked or not.');

-- DS-System group owner ID
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-19, '0', 'I0;100', 'GrpOwnerID', 'DS-System group ID.');

-- DS-System group timestamp
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-20, '0', 'I0;2147483647', 'GrpTimeStamp', 'DS-System group timestamp.');

INSERT INTO ds_config(cfg_id, cfg_value,cfg_constraint, cfg_name, cfg_text)
	VALUES (-21, '0', 'I', 'escrow_key_opt', 'Encryption key management option.');

-- Maximum number of concurrent retire storage processes on each node
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-22, '0', 'I0;100', 'RetireStorProcess',
       'Maximum number of concurrent retire storage processes on each node.');

-- delta chain length
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-23, '9', 'I3;100', 'DeltaChainLength',
       'Online delta chain length.');

-- Critical status error limits
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-24, '100', 'I1;99999', 'CriticalStatusErrorsLimit',
       'Critical status errors limit.');

-- Critical status time period
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-25, '60', 'I1;86400', 'CriticalStatusTimePeriod',
       'Critical status time period in seconds.');

-- Critical status error monitor is enabled
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-26, '1', 'I01;1', 'CriticalStatusEnabled',
       'Critical status function is enabled.');

-- Regular 2FA passcode expiration time (in hours)
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
       VALUES (-27, '2', 'I1;24', 'Regular2FAExpire',
       'Regular 2FA passcode expiration time (in hours)');

-- Lengthy 2FA passcode expiration time (in hours)
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
       VALUES (-28, '8', 'I1;72', 'Lengthy2FAExpire',
       'Lengthy 2FA passcode expiration time (in hours)');

-- DS-System GUID retrieved from the DS-License server
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-100, '', 'S', 'LicenseGUID', 'DS-License GUID');

-- Debug level
INSERT INTO ds_config(cfg_id,cfg_value,cfg_constraint,cfg_name,cfg_text)
	VALUES (-1001, '0', 'I0;1', 'DebugLevel',
       'DS-System Debug Level.');

CREATE TABLE storage_lock (
       idx_id      SERIAL PRIMARY KEY,
       lock_cmd    INT,
       lock_status INT
);

INSERT INTO storage_lock (lock_cmd, lock_status) VALUES (0, 0);

CREATE TABLE exchange_session (
  acc_id          int,
  box_id          int,
  req_id          int,
  appl_id         int,
  dir_id          int,
  file_id         int,
  gen_id          int,
  flag            int,
  bktime          int, -- datetime
  PRIMARY KEY (acc_id, box_id, req_id, appl_id, dir_id, file_id, gen_id, flag, bktime)
);
CREATE INDEX idx_exchange_session ON exchange_session(box_id, req_id);

CREATE TABLE dsset_recovery (
  box_id	int NOT NULL,
  req_id	int NOT NULL,
  set_name	varchar(1024),
  status	smallint,
  PRIMARY KEY (box_id, req_id)
);

CREATE TABLE ds_sequences (
  idx_id        SERIAL PRIMARY KEY,
  account_id    INT DEFAULT 0,
  box_id        INT DEFAULT 0,
  pub_id        INT DEFAULT 0,
  loc_id        INT DEFAULT 0,
  bloc_id       INT DEFAULT 0,
  rep_id        INT DEFAULT 0,
  group_id      INT DEFAULT 0,
  activity_id   INT DEFAULT 0,
  cd_id         INT DEFAULT 0,
  disaster_id   INT DEFAULT 0,
  charge_id     INT DEFAULT 0,
  scale_id      INT DEFAULT 0,
  slascale_id   INT DEFAULT 0,
  bplan_id      INT DEFAULT 0,
  message_id    INT DEFAULT 0,
  invoice_id    INT DEFAULT 0,
  credit_id     INT DEFAULT 0,
  addon_id      INT DEFAULT 0,
  blm_scale_id  INT,
  archive_req_id INT,
  ext_group_id   INT,
  lock_sched_id  INT,
  lock_sched_const_id INT,
  deltachain_cfg_id   INT,
  drill_id       INT
);

INSERT INTO ds_sequences (account_id, box_id, pub_id, loc_id, bloc_id, rep_id, group_id, activity_id,
       cd_id, disaster_id, charge_id, scale_id, slascale_id, bplan_id, message_id, invoice_id,
       credit_id, addon_id, blm_scale_id, archive_req_id, ext_group_id, lock_sched_id,
       lock_sched_const_id, deltachain_cfg_id, drill_id)
VALUES (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

CREATE TABLE blm_server(
  srvid         SERIAL PRIMARY KEY,
  blm_ip        varchar(256),
  blm_port      int NOT NULL,
  sys_id        int NOT NULL,
  cookie        bytea NOT NULL,
  blmactive     int,
  bandwidth     int,
  bw_sched_id   int,
  FOREIGN KEY (bw_sched_id) REFERENCES bandwidth_schedule(bw_sched_id) ON DELETE SET NULL
);

CREATE TABLE notification_admin (
  type             INT NOT NULL PRIMARY KEY,
  enabled          INT NOT NULL,
  param1           INT,
  param2           INT,
  param3           INT,
  freq1            INT,
  freq2            INT,
  freq3            INT,
  lastWarningLevel INT,
  lastWarningTime  INT
);

-- customer/ds-client storage quota has been reached.
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (1, 1, 0, 0, 0, 0, 0, 0, 0, 0);

--Database Driver used space reaches warning level.
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (2, 0, 80, 90, 95, 4, 1, 0, 0, 0);

--Storage Driver used space reaches the warning level
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (3, 1, 80, 90, 95, 4, 1, 0, 0, 0);

--License key will expire
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (4, 0, 10, 0, 0, 24, 0, 0, 0, 0);

--License storage limit
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (5, 0, 90, 0, 0, 1, 0, 0, 0, 0);

--LAN Storage Discovery processes
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (7, 0, 10, 0, 0, 24, 0, 0, 0, 0);

INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (8, 0, 0, 0, 0, 0, 0, 0, 0, 0);
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (9, 0, 0, 0, 0, 0, 0, 0, 0, 0);

--Storage Lock
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (10, 0, 0, 0, 0, 0, 0, 0, 0, 0);

--Storage Usage
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (11, 1, 8, 18, 0, 24, 0, 0, 0, 0);

--RVDR Activity
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (12, 1, 0, 0, 0, 0, 0, 0, 0, 0);

--License recovery capacity limit
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (13, 0, 90, 0, 0, 1, 0, 0, 0, 0);

--Recovery Drill activated
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (14, 0, 0, 0, 0, 0, 0, 0, 0, 0);

--DS-System is in Critical Status
INSERT INTO notification_admin (type, enabled, param1, param2, param3, freq1, freq2, freq3, lastWarningLevel, lastWarningTime) VALUES (15, 1, 0, 0, 0, 0, 0, 0, 0, 0);

CREATE TABLE ds_filesys (
  filesys       varchar(1024) PRIMARY KEY
);

CREATE TABLE healing_history (
        idx_id          SERIAL PRIMARY KEY,
        acc_id          int NOT NULL,
        box_id          int NOT NULL,
        req_id          int NOT NULL,
        start_time      int default 0, --datetime
        end_time        int default 0, --datetime
        errors          int default 0,
        warnings        int default 0,
        fixed           int default 0,
        checked_files   int default 0,
        checked_size    bigint default 0,
        checked_dssize  bigint default 0,
        activity_id     int default 0,
        description     varchar(1024),
        account_num     varchar(20),
        account_name    varchar(50),
        dsbox_snum      varchar(24),
        dsset_name      varchar(1024),
        type		int default -1	--backup set type
);

CREATE TABLE resume_files (
        acc_id          int NOT NULL,
        box_id          int NOT NULL,
        req_id          int NOT NULL,
        app_id          int NOT NULL,
        dir_id          int NOT NULL,
        file_id         int NOT NULL,
        gen_id          int NOT NULL,
        backup_time     int,
        prot_size       bigint,
        ds_size         bigint,
        signature       bytea,
        storage_id      int,
        temp_name       varchar(1024),
        flag            int NOT NULL DEFAULT 0,
        encrypt_iv      bytea,
        PRIMARY KEY (acc_id, box_id, req_id, app_id, dir_id, file_id, gen_id)
);

CREATE TABLE exp_history (
  idx_id   SERIAL PRIMARY KEY,
  tbl_name VARCHAR(1024) NOT NULL,
  col_type INT NOT NULL,
  col_name VARCHAR(1024) NOT NULL
);

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 6, 'dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 6, 'account_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 2, 'set_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 3, 'connect_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 3, 'start_session_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 3, 'end_session_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 2, 'files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 4, 'online_delta');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 4, 'online_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 4, 'transmit_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 4, 'arch_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 1, 'status');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 1, 'completion');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 1, 'session_type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 2, 'session_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 6, 'description');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 4, 'dsdelta_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 4, 'lib_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 2, 'owner_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 4, 'new_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('connection_log', 2, 'new_files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('connection_log', 0, 'dsbox_snum in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('event_log', 1, 'type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('event_log', 3, 'ev_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('event_log', 1, 'category');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('event_log', 2, 'error');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('event_log', 6, 'ev_text');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('event_log', 6, 'userid');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('event_log', 2, 'ex_long');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('event_log', 6, 'ex_text');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('clients_event_log', 1, 'type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('clients_event_log', 3, 'ev_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('clients_event_log', 1, 'category');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('clients_event_log', 2, 'error');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('clients_event_log', 6, 'ev_text');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('clients_event_log', 6, 'userid');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('clients_event_log', 2, 'ex_long');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('clients_event_log', 2, 'client_ex_long');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('clients_event_log', 6, 'ex_text');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES 
      ('clients_event_log', 0, 'userid in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 3, 'st_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 6, 'dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 4, 'online_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 2, 'online_files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 4, 'new_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 2, 'new_files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 4, 'transmit_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 4, 'online_bck');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 2, 'backup_files');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 4, 'ds_size');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 2, 'actual_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage', 0, 'dsbox_snum in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charges', 2, 'charge_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charges', 2, 'id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charges', 6, 'dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charges', 3, 'effective_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charges', 2, 'item_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charges', 2, 'quantity');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charges', 5, 'amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charges', 6, 'remark');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('charges', 0, 'dsbox_snum in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charge_items', 2, 'id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charge_items', 2, 'item_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charge_items', 6, 'item_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charge_items', 1, 'charge_type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charge_items', 5, 'price');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charge_items', 6, 'charge_unit');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charge_items', 6, 'c_u');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charge_items', 1, 'price_type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('charge_items', 3, 'effective_date');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addons', 2, 'addon_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addons', 2, 'id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addons', 6, 'dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addons', 3, 'effective_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addons', 2, 'addon_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addons', 2, 'serial_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addons', 6, 'remark');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('addons', 0, 'dsbox_snum in (SELECT dsbox_snum FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 2, 'invoice_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 3, 'from_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 3, 'to_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 3, 'creation_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 3, 'due_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'p_company_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'p_addr1');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'p_city');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'p_prov_state');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'p_postal_zip');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'p_phone');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'p_fax');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'b_dsbox_snum');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'b_account_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'c_company_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 2, 's_group_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 's_group_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 2, 's_rep_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 's_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 1, 'consolidation');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'l_addr1');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'l_addr2');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'l_city');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'l_prov_state');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'l_postal_zip');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'l_country');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'l_phone');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'l_fax');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_addr1');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_addr2');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_city');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_prov_state');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_postal_zip');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_country');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_phone');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_fax');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_po_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 2, 'bl_billing_plan');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_bank_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_bank_account');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 3, 'bl_exp_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_bank_addr');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_contact');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'bp_tax1');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'bp_tax2');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_tax1_exemp');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'bl_tax2_exemp');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'crt_online');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'crt_archive');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 3, 'crt_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 2, 'sc_scale_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'error_dscrpt');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'sp_email_addr');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, ' l_email_addr');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 3, 'consolidation_date');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 6, 'l_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'subtotal');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'tax1_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'tax2_amount');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 5, 'grand_total');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('head_inv', 0, 'b_account_num = :AccountNum');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 2, 'aid');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 2, 'invoice_num');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 2, 'service_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 1, 'service_type');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 6, 'service_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 5, 'qty');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 5, 'price');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 6, 'price_unit');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('addch_inv', 5, 'amount');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage_history', 2, 'box_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage_history', 3, 'record_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage_history', 4, 'protected_size');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage_history', 4, 'stored_size');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage_history', 5, 'protected_size_avg');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage_history', 5, 'stored_size_avg');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage_history', 4, 'protected_size_max');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('storage_history', 4, 'stored_size_max');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES
       ('storage_history', 0, 'box_id IN (SELECT box_id FROM dsbox WHERE account_num = :AccountNum)');

INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'set_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'box_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'req_id');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 6, 'set_name');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'active');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'lastbkup_comp');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES ('backup_sets', 2, 'lastbkup_time');
INSERT INTO exp_history (tbl_name, col_type, col_name) VALUES 
      ('backup_sets', 0, 'box_id IN (SELECT box_id FROM dsbox WHERE account_num = :AccountNum)');

CREATE TABLE schedule_details
(
  schedule_type     int NOT NULL,
  detail_id         int NOT NULL,
  category          int,
  type_every        int,
  type_para         int,
  from_time         int,
  end_time          int,
  end_after         int,
  para1             int,
  para2             int,
  para3             int,
  allow_speed_control     int,
  PRIMARY KEY (schedule_type, detail_id)
);

INSERT INTO schedule_details (schedule_type, detail_id, category, type_every, type_para, from_time, end_time, end_after, para1, para2, para3, allow_speed_control)
       VALUES (2, 1, 2, 1, 127 , extract(epoch from timestamp '1994-05-14 08:00:00'), 0, 1, 64, 0, 0, 0);

INSERT INTO schedule_details (schedule_type, detail_id, category, type_every, type_para, from_time,
            end_time, end_after, para1, para2, para3, allow_speed_control)
       VALUES (10, 1, 1, 1, 0, extract(epoch from timestamp '1994-05-14 09:00:00'),
               0, 0, 3, 3, 0, 0);

CREATE TABLE schedule_status
(
  schedule_type     int NOT NULL,
  detail_id         int NOT NULL,
  last_start_time   int DEFAULT 0,
  PRIMARY KEY (schedule_type, detail_id)
);

CREATE TABLE speed_control
(
  idx_id            SERIAL PRIMARY KEY,
  schedule_type     int NOT NULL,
  detail_id         int NOT NULL,
  start_time        int NOT NULL,
  end_time          int NOT NULL,
  speed             int NOT NULL
);

-- point in time archiving requests
CREATE TABLE archive_request 
(
  archive_id        int NOT NULL PRIMARY KEY,
  request_time      int NOT NULL,
  box_id            int NOT NULL REFERENCES dsbox,
  set_id            int NOT NULL,
  session_label     varchar(1024),
  archive_options   int NOT NULL,
  blm_archive_id    int NOT NULL,
  status            int NOT NULL
);

CREATE TABLE soap_config (
  flags      INT,
  url        VARCHAR(1024),
  namespace  VARCHAR(100),
  action     VARCHAR(100),
  timeout    INT,
  usr        VARCHAR(100),
  psw        VARCHAR(1024)
);

INSERT INTO soap_config(flags, url, namespace, action, timeout, usr, psw)
       VALUES (0, '', 'asigradss', '', 5, '', '');


CREATE TABLE extfs_root_cache (
  acc_id   INT NOT NULL,
  box_id   INT NOT NULL,
  req_id   INT NOT NULL,
  loc_id   INT NOT NULL,
  PRIMARY KEY (acc_id, box_id, req_id)
);

CREATE TABLE scheduled_report(
  id              int NOT NULL PRIMARY KEY,
  description     varchar(100),
  report_type     int  NOT NULL,
  schedule_type   int  NOT NULL,
  detail_id       int  NOT NULL,
  report_format   int  NOT NULL,
  selection       int,
  report_opt      int,
  order_by        int,
  email           varchar(512)
);

CREATE TABLE sched_report_selection(
  report_id       int NOT NULL,
  account_num     varchar(20),
  dsbox_snum      varchar(24),
  FOREIGN KEY (report_id) REFERENCES scheduled_report(id) ON DELETE CASCADE
);
CREATE INDEX idx_sched_report_selection ON sched_report_selection(report_id);

CREATE TABLE  role(
    role_id   int          NOT NULL,
    role_name varchar(256) NOT NULL
);


INSERT INTO role (role_id, role_name) VALUES (1, 'Data Operator');
INSERT INTO role (role_id, role_name) VALUES (2, 'Account Manager');
INSERT INTO role (role_id, role_name) VALUES (4, 'Billing Expert');

INSERT INTO role (role_id, role_name) VALUES (8, 'Role Assigner');



CREATE TABLE user_role(
    username varchar(256) NOT NULL,
    domain   varchar(256),
    role_ids  int NOT NULL DEFAULT 0,
    isgroup   int NOT NULL default 0,
    PRIMARY KEY(username, domain, isgroup)
);

CREATE TABLE exp_logs (
  idx_id   SERIAL PRIMARY KEY,
  tbl_name VARCHAR(1024) NOT NULL,
  col_type INT NOT NULL,
  col_name VARCHAR(1024) NOT NULL
);

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', -1, 'start_session_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 6, 'account_num');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 6, 'dsbox_snum');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 3, 'connect_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 3, 'start_session_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 3, 'end_session_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 2, 'files');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'online_delta');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'online_amount');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'transmit_amount');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'arch_amount');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 1, 'status');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 1, 'completion');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 1, 'session_type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 1, 'sub_type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 2, 'session_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 6, 'description');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'dsdelta_amount');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'lib_amount');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 2, 'owner_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 4, 'new_amount');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 2, 'new_files');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 2, 'cluster_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 6, 'system_address');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('connection_log', 0, 'end_session_time IS NOT NULL');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('event_log', -1, 'ev_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('event_log', 1, 'type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('event_log', 3, 'ev_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('event_log', 1, 'category');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('event_log', 2, 'error');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('event_log', 6, 'ev_text');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('event_log', 6, 'userid');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('event_log', 2, 'ex_long');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('event_log', 6, 'ex_text');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', -1, 'ev_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 1, 'type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 3, 'ev_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 1, 'category');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 2, 'error');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 6, 'ev_text');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 6, 'userid');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 2, 'ex_long');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 2, 'client_ex_long');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('clients_event_log', 6, 'ex_text');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', -1, 'st_date');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 3, 'st_date');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 6, 'dsbox_snum');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'online_amount');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 2, 'online_files');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'new_amount');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 2, 'new_files');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'transmit_amount');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'online_bck');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 2, 'backup_files');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 4, 'ds_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('storage', 2, 'actual_time');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('ds_audit', -1, 'time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('ds_audit', 3, 'time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('ds_audit', 6, 'userid');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('ds_audit', 1, 'type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('ds_audit', 1, 'table_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('ds_audit', 6, 'table_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('ds_audit', 6, 'remark');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('load_summary', -1, 'sum_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('load_summary', 3, 'sum_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('load_summary', 2, 'send');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('load_summary', 2, 'recv');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('load_summary', 1, 'cpu_load');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('load_summary', 1, 'mem_load');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('load_summary', 1, 'activities');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('load_summary', 1, 'clusterid');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('cluster_events', -1, 'ev_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('cluster_events', 3, 'ev_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('cluster_events', 2, 'system_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('cluster_events', 2, 'ev_no');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('cluster_events', 2, 'ev_type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('cluster_events', 6, 'ev_text');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('cluster_events', 6, 'ipaddress');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', -1, 'start_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 2, 'acc_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 2, 'box_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 2, 'req_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 2, 'type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 6, 'account_num');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 6, 'account_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 6, 'dsbox_snum');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 6, 'dsset_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 3, 'start_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 3, 'end_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 2, 'errors');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 2, 'warnings');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 2, 'fixed');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 2, 'checked_files');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 4, 'checked_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 4, 'checked_dssize');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 2, 'activity_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES
       ('healing_history', 6, 'description');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', -1, 'record_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 2, 'box_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 3, 'record_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'protected_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'stored_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'protected_size_avg');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'stored_size_avg');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'protected_size_max');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'stored_size_max');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'blm_prot_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'blm_ds_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'blm_prot_size_max');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'blm_ds_size_max');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'blm_prot_size_avg');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('storage_history', 4, 'blm_ds_size_avg');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('bset_storage_history', -1, 'record_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('bset_storage_history', 2, 'box_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('bset_storage_history', 2, 'req_id');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('bset_storage_history', 3, 'record_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('bset_storage_history', 4, 'protected_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('bset_storage_history', 4, 'stored_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('bset_storage_history', 4, 'native_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('bset_storage_history', 4, 'blm_prot_size');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('bset_storage_history', 4, 'blm_ds_size');

INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs', -1, 'delete_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'delete_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'delete_type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'user_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'dsbox_snum');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'bset_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'bset_type');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'dir_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  6, 'file_name');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'backup_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  2, 'modify_time');
INSERT INTO exp_logs (tbl_name, col_type, col_name) VALUES('file_delete_logs',  4, 'file_size');

CREATE TABLE dsbox_enckey (
   box_id        int NOT NULL PRIMARY KEY REFERENCES dsbox ON DELETE CASCADE,
   recv_time     int,
   acc_enc_type  int,
   box_enc_type  int,
   acc_key       varchar(1024),
   box_key       varchar(1024)
);

CREATE TABLE dssys_group (
  idx_id       SERIAL PRIMARY KEY,
  grp_id       int,
  ip_addr      varchar(1024)
);

CREATE TABLE dssys_group_bandwidth(
  grp_id       int,
  bandwidth    int,
  bw_sched_id  int,
  FOREIGN KEY (bw_sched_id) REFERENCES bandwidth_schedule(bw_sched_id) ON DELETE SET NULL
);


CREATE TABLE billing_server(
    ip          varchar(16) NOT NULL, 
    status      int NOT NULL, 
    cookie      bytea
);

CREATE TABLE lan_discovery_req(
    id          SERIAL PRIMARY KEY,
    box_id      int NOT NULL, 
    req_time    int NOT NULL,
    price       float NOT NULL,
	foreign key (box_id) references dsbox(box_id) on delete cascade
);

CREATE TABLE cdrequests_history(
   id                   SERIAL PRIMARY KEY,
   old_id               int NOT NULL,
   set_id               int NOT NULL,
   media_name			varchar(100),
   username             varchar(100) NULL,
   receivedtime         varchar(100) NULL,
   producetime          varchar(100) NULL,
   state                smallint NULL,
   price                float NULL,
   disknums             smallint NULL,
   options              int NULL,
   mailing              varchar(100) NULL,
   telephone            varchar(100) NULL,
   person               varchar(100) NULL,
   numfiles             int NULL,
   fbytes               float NULL,
   vbytes               float NULL,
   failedfiles          int NULL,
   buf_dir              varchar(1024) NULL,
   writing_time_in_min  int NULL,
   requestfinishtime    int NULL, -- was datetime
   cluster_id           int,  --The cluster id who set the bufer (buf_dir)
   copies               int,
   unitprice            float,
   fixedprice           float
);

CREATE TABLE history_customer_num (
  id               SERIAL,
  old_account_num  varchar(64) PRIMARY KEY,
  new_account_num  varchar(64),
  old_acc_id       int,
  new_acc_id       int,
  add_date         INT
);

CREATE TABLE history_box_num (
  id           SERIAL,
  old_box_num  varchar(64) PRIMARY KEY,
  old_box_id   int,
  new_box_num  varchar(64),
  new_box_id   int,
  add_date     INT
);

CREATE TABLE replication_resume (
        acc_id          int NOT NULL,
        box_id          int NOT NULL,
        req_id          int NOT NULL,
        app_id          int NOT NULL,
        dir_id          int NOT NULL,
        file_id         int NOT NULL,
        gen_id          int NOT NULL,
        file_type       int,
        seq_id          int,
        ds_size         bigint,
        signature       bytea,
        extra_data      bytea,
        storage_id      int,
        temp_name       varchar(1024),
        PRIMARY KEY (acc_id, box_id, req_id, app_id, dir_id, file_id, gen_id)
);

CREATE TABLE client_backup_policy (
  idx_id        SERIAL PRIMARY KEY,
  account_id    INT NOT NULL,
  box_id        INT NOT NULL,
  flags         INT NOT NULL,
  cookie        BYTEA,
  policy_text   TEXT,
  FOREIGN KEY (account_id) REFERENCES customer(account_id) ON DELETE CASCADE
);
CREATE INDEX idx_backup_policy ON client_backup_policy(account_id, box_id);

CREATE TABLE report_col_string(
    column_name      varchar(100)  NOT NULL,
    column_value     int,
    column_string    varchar(100)
);

INSERT INTO report_col_string VALUES('quota_unit',           1 , 'MB');
INSERT INTO report_col_string VALUES('quota_unit',           2 , 'GB');
INSERT INTO report_col_string VALUES('customer_quota.method', 0 , 'Protected Size');
INSERT INTO report_col_string VALUES('customer_quota.method', 1 , 'Stored Size');
INSERT INTO report_col_string VALUES('customer_quota.method', 2 , 'Native Size');
INSERT INTO report_col_string VALUES('dsbox.status',         0 , 'Unregistred');
INSERT INTO report_col_string VALUES('dsbox.status',         1 , 'Active');
INSERT INTO report_col_string VALUES('dsbox.status',         2 , 'Suspend');
INSERT INTO report_col_string VALUES('dsbox.status',         3 , 'Deactivate');
INSERT INTO report_col_string VALUES('dsbox.status',         4 , 'Deregistrated');
INSERT INTO report_col_string VALUES('dsbox_quota.method',   0 , 'Protected Size');
INSERT INTO report_col_string VALUES('dsbox_quota.method',   1 , 'Stored Size');
INSERT INTO report_col_string VALUES('dsbox_quota.method',   2 , 'Native Size');

INSERT INTO report_col_string VALUES('event_log.type', 0 , 'Information');
INSERT INTO report_col_string VALUES('event_log.type', 1 , 'Warning');
INSERT INTO report_col_string VALUES('event_log.type', 2 , 'Error');

INSERT INTO report_col_string VALUES('backup_sets.set_type', 0, 'File System');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 1, 'SQL Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 2, 'NT Services');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 3, 'Exchange Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 4, 'Oracle Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 5, 'Permissions');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 6, 'Exchange Server Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 7, 'Microsoft Outlook Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 8, 'MS Office');
INSERT INTO report_col_string VALUES('backup_sets.set_type', 9, 'AS400 Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',10, 'MySQL');
INSERT INTO report_col_string VALUES('backup_sets.set_type',11, 'PostgreSQL');
INSERT INTO report_col_string VALUES('backup_sets.set_type',12, 'Oracle Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',15, 'DB2 Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',16, 'Lotus Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type',17, 'Groupwise Email');
INSERT INTO report_col_string VALUES('backup_sets.set_type',18, 'SharePoint Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',20, 'VM Ware');
INSERT INTO report_col_string VALUES('backup_sets.set_type',21, 'Xen Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',23, 'Lotus Domino Database');
INSERT INTO report_col_string VALUES('backup_sets.set_type',24, 'VSS Hyper V');
INSERT INTO report_col_string VALUES('backup_sets.set_type',25, 'VSS SQL Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',26, 'VSS Exchange Server');
INSERT INTO report_col_string VALUES('backup_sets.set_type',28, 'VSS SharePoint');
INSERT INTO report_col_string VALUES('backup_sets.set_type',29, 'VMWare VADP');
INSERT INTO report_col_string VALUES('backup_sets.set_type',30, 'Apple iOS');
INSERT INTO report_col_string VALUES('backup_sets.set_type',31, 'Android');
INSERT INTO report_col_string VALUES('backup_sets.set_type',32, 'Cluster HyperV');
INSERT INTO report_col_string VALUES('backup_sets.set_type',33, 'PTOV');
INSERT INTO report_col_string VALUES('backup_sets.set_type',34, 'Salesforce');
INSERT INTO report_col_string VALUES('backup_sets.set_type',35, 'Google Apps');
INSERT INTO report_col_string VALUES('backup_sets.set_type',36, 'Microsoft Office 365');
INSERT INTO report_col_string VALUES('backup_sets.set_type',37, 'VM Replication');

INSERT INTO report_col_string VALUES('connection_log.session_type', 0 , 'Connection');
INSERT INTO report_col_string VALUES('connection_log.session_type', 1 , 'Backup');
INSERT INTO report_col_string VALUES('connection_log.session_type', 2 , 'Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type', 3 , 'Daily Admin');
INSERT INTO report_col_string VALUES('connection_log.session_type', 4 , 'Delete');
INSERT INTO report_col_string VALUES('connection_log.session_type', 5 , 'Weekly Admin');
INSERT INTO report_col_string VALUES('connection_log.session_type', 6 , 'Recovery');
INSERT INTO report_col_string VALUES('connection_log.session_type', 7 , 'Registration');
INSERT INTO report_col_string VALUES('connection_log.session_type', 8 , 'System Admin');
INSERT INTO report_col_string VALUES('connection_log.session_type', 9 , 'System Backup');
INSERT INTO report_col_string VALUES('connection_log.session_type',10 , 'Synchronization');
INSERT INTO report_col_string VALUES('connection_log.session_type',11 , 'Initial Backup');
INSERT INTO report_col_string VALUES('connection_log.session_type',12 , 'Disc/Tape');
INSERT INTO report_col_string VALUES('connection_log.session_type',13 , 'LAN Analyze Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',14 , 'Portable');
INSERT INTO report_col_string VALUES('connection_log.session_type',15 , 'Remove Orphaned Libraries');
INSERT INTO report_col_string VALUES('connection_log.session_type',16 , 'Empty Trash');
INSERT INTO report_col_string VALUES('connection_log.session_type',17 , 'OnLine File Summary');
INSERT INTO report_col_string VALUES('connection_log.session_type',18 , 'Synchronized Delete');
INSERT INTO report_col_string VALUES('connection_log.session_type',19 , 'Clean Libraries');
INSERT INTO report_col_string VALUES('connection_log.session_type',20 , 'SLA Monitor Check');
INSERT INTO report_col_string VALUES('connection_log.session_type',21 , 'SLA Monitor Register');
INSERT INTO report_col_string VALUES('connection_log.session_type',22 , 'SLA Monitor Unregister');
INSERT INTO report_col_string VALUES('connection_log.session_type',23 , 'Test Connection');
INSERT INTO report_col_string VALUES('connection_log.session_type',24 , 'Migration');
INSERT INTO report_col_string VALUES('connection_log.session_type',27 , 'LTS Process');
INSERT INTO report_col_string VALUES('connection_log.session_type',28 , 'LTS Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',29 , 'LTS Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type',30 , 'System Autonomic Healing');
INSERT INTO report_col_string VALUES('connection_log.session_type',32 , 'Disaster Recovery');
INSERT INTO report_col_string VALUES('connection_log.session_type',33 , 'Storage Scan');
INSERT INTO report_col_string VALUES('connection_log.session_type',34 , 'Validation');
INSERT INTO report_col_string VALUES('connection_log.session_type',35 , 'BLM Archiving');
INSERT INTO report_col_string VALUES('connection_log.session_type',36 , 'Auto Upgrade');
INSERT INTO report_col_string VALUES('connection_log.session_type',37 , 'Storage Statistics');
INSERT INTO report_col_string VALUES('connection_log.session_type',38 , 'BLM Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type',39 , 'BLM Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',40 , 'Retention');
INSERT INTO report_col_string VALUES('connection_log.session_type',41 , 'Disc/Tape Request');
INSERT INTO report_col_string VALUES('connection_log.session_type',42 , 'Disc/Tape Restore');
INSERT INTO report_col_string VALUES('connection_log.session_type',43 , 'Scheduled Report');
INSERT INTO report_col_string VALUES('connection_log.session_type',44 , 'File Optimization');
INSERT INTO report_col_string VALUES('connection_log.session_type',45 , 'Clean Logs');
INSERT INTO report_col_string VALUES('connection_log.session_type',46 , 'Tape Convert');
INSERT INTO report_col_string VALUES('connection_log.session_type',47 , 'Replication Send');
INSERT INTO report_col_string VALUES('connection_log.session_type',48 , 'Replication Receive');
INSERT INTO report_col_string VALUES('connection_log.session_type',49 , 'Replication Delete');

INSERT INTO report_col_string VALUES('event_log.category', 0 , 'Unknown');
INSERT INTO report_col_string VALUES('event_log.category', 1 , 'Application');
INSERT INTO report_col_string VALUES('event_log.category', 2 , 'Socket');
INSERT INTO report_col_string VALUES('event_log.category', 3 , 'Message');
INSERT INTO report_col_string VALUES('event_log.category', 4 , 'Database');
INSERT INTO report_col_string VALUES('event_log.category', 5 , 'Exception');
INSERT INTO report_col_string VALUES('event_log.category', 6 , 'I/O');
INSERT INTO report_col_string VALUES('event_log.category', 7,  'System');
INSERT INTO report_col_string VALUES('event_log.category', 8,  'Security');
INSERT INTO report_col_string VALUES('event_log.category', 9,  'MAPI');
INSERT INTO report_col_string VALUES('event_log.category',10,  'Netware');
INSERT INTO report_col_string VALUES('event_log.category',11,  'ORA');

INSERT INTO report_col_string VALUES('event_log.category',12,  'RMAN');
INSERT INTO report_col_string VALUES('event_log.category',14,  'XML Parsing');
INSERT INTO report_col_string VALUES('event_log.category',15,  'DB2');
INSERT INTO report_col_string VALUES('event_log.category',16,  'ORACLE');

INSERT INTO report_col_string VALUES('connection_log.client_stop', 0 , '');
INSERT INTO report_col_string VALUES('connection_log.client_stop', -1 , 'Unknown');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 1 , 'User Stop');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 2 , 'Time limit');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 3 , 'Error limit');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 4 , 'Storage limit');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 5 , 'Shutdown');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 6 , 'Disconnect');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 7 , 'No resource');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 8 , 'Exception');
INSERT INTO report_col_string VALUES('connection_log.client_stop', 9 , 'No connect');
INSERT INTO report_col_string VALUES('connection_log.client_stop',10 , 'Pre/Post failure');
INSERT INTO report_col_string VALUES('connection_log.client_stop',11 , 'Synchronization');
INSERT INTO report_col_string VALUES('connection_log.client_stop',12 , 'No share');
INSERT INTO report_col_string VALUES('connection_log.client_stop',15 , 'Could not allocate space for database');
INSERT INTO report_col_string VALUES('connection_log.client_stop',18 , 'Locked');
INSERT INTO report_col_string VALUES('connection_log.client_stop',19 , 'Upgrade stop');
INSERT INTO report_col_string VALUES('connection_log.client_stop',20 , 'Quota reached');
INSERT INTO report_col_string VALUES('connection_log.client_stop',21 , 'Quota reached');
INSERT INTO report_col_string VALUES('connection_log.client_stop',22 , 'Failed');
INSERT INTO report_col_string VALUES('connection_log.client_stop',23 , 'Unexpected stop');
INSERT INTO report_col_string VALUES('connection_log.client_stop',24 , 'Not allowed');
INSERT INTO report_col_string VALUES('connection_log.client_stop',25 , 'No enough disk space');
INSERT INTO report_col_string VALUES('connection_log.client_stop',26 , 'No local storage path');
INSERT INTO report_col_string VALUES('connection_log.client_stop',27 , 'Fatal Error');
INSERT INTO report_col_string VALUES('connection_log.client_stop',30 , 'DS-System Requested Stop');

CREATE TABLE report_views(
    view_id      int PRIMARY KEY,
    view_name    varchar(100) NOT NULL UNIQUE,
    view_from    text
);

CREATE TABLE report_views_tables(
    view_id           int,
    table_alias       varchar(100) NOT NULL,
    table_realname    varchar(100) NOT NULL
);

CREATE TABLE report_views_columns(
    column_name      varchar(100)  NOT NULL,
    column_table     varchar(100) NOT NULL,
    column_define    text NOT NULL,
    column_type      varchar(100) NOT NULL,
    column_sortable  int  NOT NULL,
    column_filter    int  NOT NULL,
    column_desc      varchar(100) NOT NULL,
    column_id        SERIAL PRIMARY KEY
);

INSERT INTO report_views_columns VALUES('provider_name',        'var_data',   'var_data.company_name',   'string', 0, 0, 'Service Provider''s Company Name');
INSERT INTO report_views_columns VALUES('provider_addr1',       'var_data',   'var_data.addr1',          'string', 0, 0, 'Service Provider''s Address Line 1');
INSERT INTO report_views_columns VALUES('provider_addr2',       'var_data',   'var_data.addr2',          'string', 0, 0, 'Service Provider''s Address Line 2');
INSERT INTO report_views_columns VALUES('provider_city',        'var_data',   'var_data.city',           'string', 0, 0, 'Service Provider''s City');
INSERT INTO report_views_columns VALUES('provider_contact',     'var_data',   'var_data.contact',        'string', 0, 0, 'Service Provider''s Contact');
INSERT INTO report_views_columns VALUES('provider_country_code','var_data',   'var_data.country',        'string', 0, 0, 'Service Provider''s Country Code');
INSERT INTO report_views_columns VALUES('provider_country_name','var_data',   '(select country_name from countries where countries.country_code=var_data.country)',  'string', 0, 0, 'Service Provider''s Country Name');
INSERT INTO report_views_columns VALUES('provider_email',       'var_data',   'var_data.email_addr',     'string', 0, 0, 'Service Provider''s EMail Address');
INSERT INTO report_views_columns VALUES('provider_fax',         'var_data',   'var_data.fax',            'string', 0, 0, 'Service Provider''s Fax');
INSERT INTO report_views_columns VALUES('provider_phone',       'var_data',   'var_data.phone',          'string', 0, 0, 'Service Provider''s Phone');
INSERT INTO report_views_columns VALUES('provider_zipcode',     'var_data',   'var_data.postal_zip',     'string', 0, 0, 'Service Provider''s Zipcode');
INSERT INTO report_views_columns VALUES('provider_prov_code',   'var_data',   'var_data.prov_state',     'string', 0, 0, 'Service Provider''s Province/State Code');
INSERT INTO report_views_columns VALUES('provider_prov_name',   'var_data',   '(select province_name from provinces where provinces.province_code=var_data.prov_state and provinces.country_code=var_data.country)', 'string', 0, 0, 'Service Provider''s Province/State Name');
INSERT INTO report_views_columns VALUES('provider_computername','var_data',   ':ComputerName',           'string', 0, 0, 'DS-System Computer Name');
INSERT INTO report_views_columns VALUES('provider_brandingfile','var_data',   ':BrandingFile',           'string', 0, 0, 'Service Provider''s Branding File');

INSERT INTO report_views_columns VALUES('customer_account_id',   'customer',  'customer.account_id',         'int',    0, 0, 'Customer''s Account ID');
INSERT INTO report_views_columns VALUES('customer_account_num',  'customer',  'customer.account_num',        'string', 1, 2004, 'Customer''s Account Number');
INSERT INTO report_views_columns VALUES('customer_account_name', 'customer',  'customer.company_name',       'string', 1, 0, 'Customer''s Company Name');
INSERT INTO report_views_columns VALUES('customer_contact',      'customer',  'customer.contact',            'string', 0, 0, 'Customer''s Contact');
INSERT INTO report_views_columns VALUES('customer_loc_id',       'customer',  'customer.location_id',        'int',    0, 0, 'Customer''s location id');

INSERT INTO report_views_columns VALUES('customer_loc_name',    'cust_loc',  'cust_loc.name',        'string', 0, 0, 'Customer''s location name');
INSERT INTO report_views_columns VALUES('customer_addr1',       'cust_loc',  'cust_loc.addr1',       'string', 0, 0, 'Customer''s addr line 1');
INSERT INTO report_views_columns VALUES('customer_addr2',       'cust_loc',  'cust_loc.addr2',       'string', 0, 0, 'Customer''s addr line 2');
INSERT INTO report_views_columns VALUES('customer_city',        'cust_loc',  'cust_loc.city',        'string', 0, 0, 'Customer''s city');
INSERT INTO report_views_columns VALUES('customer_phone',       'cust_loc',  'cust_loc.phone',       'string', 0, 0, 'Customer''s phone');
INSERT INTO report_views_columns VALUES('customer_fax',         'cust_loc',  'cust_loc.fax',         'string', 0, 0, 'Customer''s fax');
INSERT INTO report_views_columns VALUES('customer_email',       'cust_loc',  'cust_loc.email_addr',  'string', 0, 0, 'Customer''s E-Mail');
INSERT INTO report_views_columns VALUES('customer_prov_code',   'cust_loc',  'cust_loc.prov_state',  'string', 0, 0, 'Customer''s Province/State code');
INSERT INTO report_views_columns VALUES('customer_prov_name',   'cust_loc',  '(select province_name from provinces where provinces.province_code=cust_loc.prov_state and provinces.country_code=cust_loc.country)', 'string', 0, 0, 'Customer''s Province/State Name');
INSERT INTO report_views_columns VALUES('customer_zipcode',     'cust_loc',  'cust_loc.postal_zip',  'string', 0, 0, 'Customer''s postal code');
INSERT INTO report_views_columns VALUES('customer_country_code','cust_loc',  'cust_loc.country',     'string', 0, 0, 'Customer''s country code');
INSERT INTO report_views_columns VALUES('customer_country_name','cust_loc',  '(select country_name from countries where countries.country_code=cust_loc.country)',  'string', 0, 0, 'Customer''s Country Name');

INSERT INTO report_views_columns VALUES('customer_storage_quota',      'customer_quota',  '(case when ((customer_quota.flag & 1)!=0) then customer_quota.quota else 0 end)',  'int', 0, 0, 'Customer''s storage quota');
INSERT INTO report_views_columns VALUES('customer_quota_unit',         'customer_quota',  '(select column_string from report_col_string where column_name=''quota_unit'' and column_value=customer_quota.quota_unit)',  'string', 0, 0, 'Customer''s storage quota unit');
INSERT INTO report_views_columns VALUES('customer_quota_basedon',      'customer_quota',  '(select column_string from report_col_string where column_name=''customer_quota.method'' and column_value=customer_quota.method)',  'string', 0, 0, 'Customer''s storage quota calculation method');

INSERT INTO report_views_columns VALUES('box_id',                'dsbox',  'dsbox.box_id',              'int',      0, 0, 'DS-Client ID');
INSERT INTO report_views_columns VALUES('box_number',            'dsbox',  'dsbox.dsbox_snum',          'string',   1, 2005, 'DS-Client Number');
INSERT INTO report_views_columns VALUES('box_description',       'dsbox',  'dsbox.description',         'string',   0, 0, 'DS-Client description');
INSERT INTO report_views_columns VALUES('box_contact',           'dsbox',  'dsbox.contact',             'string',   0, 0, 'DS-Client contact');
INSERT INTO report_views_columns VALUES('box_service_start_date','dsbox',  'dsbox.service_start_date',  'date',     0, 0, 'DS-Client service start date');
INSERT INTO report_views_columns VALUES('box_service_end_date',  'dsbox',  'dsbox.service_end_date',    'date',     0, 0, 'DS-Client service end date');
INSERT INTO report_views_columns VALUES('box_creation_date',     'dsbox',  'dsbox.creation_date',       'date',     1, 1, 'DS-Client creation date');
INSERT INTO report_views_columns VALUES('box_activation_date',   'dsbox',  'dsbox.activation_date',     'datetime', 0, 0, 'DS-Client activation date');
INSERT INTO report_views_columns VALUES('box_storage_group_id',  'dsbox',  'dsbox.ext_group_id',        'int',      0, 0, 'DS-Client storage group id.');
INSERT INTO report_views_columns VALUES('box_storage_group_name','dsbox',  '(select ext_group_name from storage_groups where storage_groups.ext_group_id = dsbox.ext_group_id)',  'string', 0, 0, 'DS-Client storage group name.');
INSERT INTO report_views_columns VALUES('box_loc_id',            'dsbox',  'dsbox.location_id',         'int',      0, 0, 'DS-Client location id');
INSERT INTO report_views_columns VALUES('box_show_stored_size',  'dsbox',  '(case when ((dsbox.flags & 1048576 )!=0) then 1 else 0 end)',  'int', 0, 0, 'Allow DS-Client show stored size on backup set report');
INSERT INTO report_views_columns VALUES('box_status',            'dsbox',  'dsbox.status',              'int',      0, 2010, 'DS-Client status');
INSERT INTO report_views_columns VALUES('box_status_name',       'dsbox',  '(select column_string from report_col_string where column_name=''dsbox.status'' and column_value = dsbox.status)',  'string', 1, 0, 'DS-Client status name');
INSERT INTO report_views_columns VALUES('box_bandwidth_to_sys',  'dsbox',  '(select limit_tosystem from bandwidth where box_id = dsbox.box_id)',  'int', 0, 0, 'DS-Client bandwitdh limitation (to system)');
INSERT INTO report_views_columns VALUES('box_bandwidth_to_clnt', 'dsbox',  '(select limit_toclient from bandwidth where box_id = dsbox.box_id)',  'int', 0, 0, 'DS-Client bandwidth limitation (to client)');
INSERT INTO report_views_columns VALUES('box_req_registration',  'dsbox',  '(case when ((dsbox.flags & 2)!=0) then 1 else 0 end)',  'int', 0, 0, 'DS-Client require registration');

INSERT INTO report_views_columns VALUES('box_storage_quota', 'dsbox_quota',  '(case when ((dsbox_quota.flag & 256 )!=0) then dsbox_quota.quota else 0 end)',  'int', 0, 0, 'DS-Client storage quota');
INSERT INTO report_views_columns VALUES('box_quota_unit',    'dsbox_quota',  '(select column_string from report_col_string where column_name=''quota_unit'' and column_value=dsbox_quota.quota_unit)',  'string', 0, 0, 'DS-Client storage quota unit');
INSERT INTO report_views_columns VALUES('box_quota_basedon', 'dsbox_quota',  '(select column_string from report_col_string where column_name=''dsbox_quota.method'' and column_value=dsbox_quota.method)',  'string', 0, 0, 'DS-Client storage quota calculation method');

INSERT INTO report_views_columns VALUES('box_protected_size',      'dsbox_size',  'dsbox_size.prot_size',    'double', 1, 0, 'DS-Client protected size');
INSERT INTO report_views_columns VALUES('box_stored_size',         'dsbox_size',  '(dsbox_size.ds_size+dsbox_size.lib_size)',  'double', 1, 0, 'DS-Client stored size');
INSERT INTO report_views_columns VALUES('box_ds_size',             'dsbox_size',  'dsbox_size.ds_size',      'double', 0, 0, 'DS-Client DS Size');
INSERT INTO report_views_columns VALUES('box_native_size',         'dsbox_size',  'dsbox_size.native_size',   'double', 1, 0, 'DS-Client Native Size');
INSERT INTO report_views_columns VALUES('box_blm_protected_size',  'dsbox_size',  'dsbox_size.blm_prot_size','double', 0, 0, 'DS-Client BLM Protected Size');
INSERT INTO report_views_columns VALUES('box_blm_stored_size',     'dsbox_size',  'dsbox_size.blm_ds_size',  'double', 0, 0, 'DS-Client BLM stored size');
INSERT INTO report_views_columns VALUES('box_protected_size_avg',  'dsbox_size',  'dsbox_size.prot_avg',     'double', 0, 0, 'DS-Client protected size (average)');
INSERT INTO report_views_columns VALUES('box_stored_size_avg',     'dsbox_size',  'dsbox_size.ds_avg',       'double', 0, 0, 'DS-Client stored size (average)');
INSERT INTO report_views_columns VALUES('box_native_size_avg',     'dsbox_size',  'dsbox_size.native_avg',   'double', 0, 0, 'DS-Client Native size (average)');
INSERT INTO report_views_columns VALUES('box_blm_protected_avg',   'dsbox_size',  'dsbox_size.blm_prot_size_avg',  'double', 0, 0, 'DS-Client BLM Protected Size (average)');
INSERT INTO report_views_columns VALUES('box_blm_stored_avg',      'dsbox_size',  'dsbox_size.blm_ds_size_avg',    'double', 0, 0, 'DS-Client BLM stored size (average)');
INSERT INTO report_views_columns VALUES('box_protected_size_peak', 'dsbox_size',  'dsbox_size.prot_max',           'double', 0, 0, 'DS-Client protected size (peak)');
INSERT INTO report_views_columns VALUES('box_stored_size_peak',    'dsbox_size',  'dsbox_size.ds_max',             'double', 0, 0, 'DS-Client stored size (peak)');
INSERT INTO report_views_columns VALUES('box_native_size_peak',    'dsbox_size',  'dsbox_size.native_max',         'double', 0, 0, 'DS-Client Native size (peak)');
INSERT INTO report_views_columns VALUES('box_blm_protected_peak',  'dsbox_size',  'dsbox_size.blm_prot_size_max',  'double', 0, 0, 'DS-Client BLM Protected Size (peak)');
INSERT INTO report_views_columns VALUES('box_blm_stored_peak',     'dsbox_size',  'dsbox_size.blm_ds_size_max',    'double', 0, 0, 'DS-Client BLM stored size (peak)');

INSERT INTO report_views_columns VALUES('box_loc_name',    'box_loc',  'box_loc.name',       'string', 0, 0, 'DS-Client location name');
INSERT INTO report_views_columns VALUES('box_addr1',       'box_loc',  'box_loc.addr1',      'string', 0, 0, 'DS-Client addr line 1');
INSERT INTO report_views_columns VALUES('box_addr2',       'box_loc',  'box_loc.addr2',      'string', 0, 0, 'DS-Client addr line 2');
INSERT INTO report_views_columns VALUES('box_city',        'box_loc',  'box_loc.city',       'string', 0, 0, 'DS-Client city');
INSERT INTO report_views_columns VALUES('box_phone',       'box_loc',  'box_loc.phone',      'string', 0, 0, 'DS-Client phone');
INSERT INTO report_views_columns VALUES('box_fax',         'box_loc',  'box_loc.fax',        'string', 0, 0, 'DS-Client fax');
INSERT INTO report_views_columns VALUES('box_email',       'box_loc',  'box_loc.email_addr', 'string', 0, 0, 'DS-Client E-Mail');
INSERT INTO report_views_columns VALUES('box_prov_code',   'box_loc',  'box_loc.prov_state', 'string', 0, 0, 'DS-Client Province/State code');
INSERT INTO report_views_columns VALUES('box_prov_name',   'box_loc',  '(select province_name from provinces where provinces.province_code=box_loc.prov_state and provinces.country_code=box_loc.country)', 'string', 0, 0, 'DS-Client Province/State Name');
INSERT INTO report_views_columns VALUES('box_zipcode',     'box_loc',  'box_loc.postal_zip', 'string', 0, 0, 'DS-Client postal code');
INSERT INTO report_views_columns VALUES('box_country_code','box_loc',  'box_loc.country',    'string', 0, 0, 'DS-Client country code');
INSERT INTO report_views_columns VALUES('box_country_name','box_loc',  '(select country_name from countries where countries.country_code=box_loc.country)',  'string', 0, 0, 'DS-Client Country Name');

INSERT INTO report_views_columns VALUES('bset_id',            'backup_sets',  'backup_sets.set_id',        'int',     0, 2012, 'Backup set system side set id');
INSERT INTO report_views_columns VALUES('bset_req_id',        'backup_sets',  'backup_sets.req_id',        'int',     0, 0, 'Backup set req id (client side)');
INSERT INTO report_views_columns VALUES('bset_name',          'backup_sets',  'backup_sets.set_name',      'string',  1, 0, 'Backup set name (include computer name and user name)');
INSERT INTO report_views_columns VALUES('bset_last_backup_time','backup_sets',  'backup_sets.lastbkup_time', 'datetime',1, 0, 'Backup set last backup time');
INSERT INTO report_views_columns VALUES('bset_set_type',      'backup_sets',  'backup_sets.set_type',      'int',     0, 0, 'Backup set type');
INSERT INTO report_views_columns VALUES('bset_set_type_name', 'backup_sets',  '(select column_string from report_col_string where column_name=''backup_sets.set_type'' and column_value=backup_sets.set_type)',      'string',     1, 0, 'Backup set type');

INSERT INTO report_views_columns VALUES('bset_ds_size',           'dsset_size',  'dsset_size.ds_size',       'double', 0, 0, 'Backup set DS Size');
INSERT INTO report_views_columns VALUES('bset_protected_size',    'dsset_size',  'dsset_size.prot_size',     'double', 1, 0, 'Backup set Protected Size');
INSERT INTO report_views_columns VALUES('bset_stored_size',       'dsset_size',  '(dsset_size.ds_size+dsset_size.lib_size)','double', 1, 0, 'Backup set stored size');
INSERT INTO report_views_columns VALUES('bset_native_size',       'dsset_size',  'dsset_size.native_size',   'double', 1, 0, 'Backup set Native size');
INSERT INTO report_views_columns VALUES('bset_blm_stored_size',   'dsset_size',  'dsset_size.blm_ds_size',   'double', 0, 0, 'Backup set BLM stored size');
INSERT INTO report_views_columns VALUES('bset_blm_protected_size','dsset_size',  'dsset_size.blm_prot_size', 'double', 0, 0, 'Backup set BLM protected size');

INSERT INTO report_views_columns VALUES('log_connect_time',      'connection_log',   'connection_log.connect_time',      'datetime', 0, 0, 'Connection Log connect time');
INSERT INTO report_views_columns VALUES('log_start_session_time','connection_log',   'connection_log.start_session_time','datetime', 1, 3, 'Connection Log start session time');
INSERT INTO report_views_columns VALUES('log_end_session_time',  'connection_log',   'connection_log.end_session_time',  'datetime', 0, 0, 'Connection Log end session time');
INSERT INTO report_views_columns VALUES('log_files',             'connection_log',   'connection_log.files',             'int',      0, 0,      'Connection Log Files');
INSERT INTO report_views_columns VALUES('log_online_delta',      'connection_log',   'connection_log.online_delta',      'double',   0, 0, 'Connection Log Online Delta');
INSERT INTO report_views_columns VALUES('log_online_amount',     'connection_log',   'connection_log.online_amount',     'double',   0, 0, 'Connection Log Online Amount');
INSERT INTO report_views_columns VALUES('log_transmit_amount' ,  'connection_log',   'connection_log.transmit_amount',   'double',   0, 0, 'Connection Log Transmit Amount');
INSERT INTO report_views_columns VALUES('log_arch_amount',       'connection_log',   'connection_log.arch_amount',       'double',   0, 0, 'Connection Log Archive Amount');
INSERT INTO report_views_columns VALUES('log_session_type',      'connection_log',   'connection_log.session_type',      'int',      1, 2013, 'Connection Log Session Type');
INSERT INTO report_views_columns VALUES('log_session_type_name', 'connection_log',   '(select column_string from report_col_string where column_name=''connection_log.session_type'' and column_value=connection_log.session_type)',      'string',      1,0, 'Connection Log Session Type Name');
INSERT INTO report_views_columns VALUES('log_session_id',        'connection_log',   'connection_log.session_id',        'int',      0, 0, 'Connection Log Session ID');
INSERT INTO report_views_columns VALUES('log_description',       'connection_log',   'connection_log.description',       'string',   0, 0, 'Connection Log Description');
INSERT INTO report_views_columns VALUES('log_dsdelta_amount',    'connection_log',   'connection_log.dsdelta_amount',    'double',   0, 0, 'Connection Log DSDelta Amount');
INSERT INTO report_views_columns VALUES('log_lib_amount',        'connection_log',   'connection_log.lib_amount',        'double',   0, 0, 'Connection Log Lib Amount');
INSERT INTO report_views_columns VALUES('log_new_amount',        'connection_log',   'connection_log.new_amount',        'double',   0, 0, 'Connection Log New Amount');
INSERT INTO report_views_columns VALUES('log_new_files',         'connection_log',   'connection_log.new_files',         'int',      0, 0, 'Connection Log New Files');
INSERT INTO report_views_columns VALUES('log_cluster_id',        'connection_log',   'connection_log.cluster_id',        'int',      0, 2014, 'Connection Log Cluster ID');
INSERT INTO report_views_columns VALUES('log_system_addr',       'connection_log',   'connection_log.system_address',    'string',   0, 0, 'Connection Log Systm Address');
INSERT INTO report_views_columns VALUES('log_client_stop',       'connection_log',   'connection_log.client_stop',       'int',      0, 0, 'Connection Log Client Stop Reason');
INSERT INTO report_views_columns VALUES('log_client_stop_desc',  'connection_log',   '(select column_string from report_col_string where column_name=''connection_log.client_stop'' and column_value=connection_log.client_stop)',       'String',      0, 0, 'Connection Log Client Stop Reason String');
INSERT INTO report_views_columns VALUES('log_errors',            'connection_log',   'connection_log.status',            'int',      0, 0, 'Connection Log Status');
INSERT INTO report_views_columns VALUES('log_completion',        'connection_log',   'connection_log.completion',        'int',      0, 0, 'Connection Log Completion');

INSERT INTO report_views_columns VALUES('event_id',           'event_log',  'event_log.ev_id',    'int',      0, 0, 'Event ID');
INSERT INTO report_views_columns VALUES('event_type',         'event_log',  'event_log.type',     'int',      0, 5, 'Event Type');
INSERT INTO report_views_columns VALUES('event_type_name',    'event_log',  '(select column_string from report_col_string where column_name=''event_log.type'' and column_value=event_log.type)',     'string',      1,0, 'Event Type Name');
INSERT INTO report_views_columns VALUES('event_time',         'event_log',  'event_log.ev_time',  'datetime', 1, 3, 'Event Time');
INSERT INTO report_views_columns VALUES('event_category',     'event_log',  'event_log.category', 'int',      0, 6, 'Event Category');
INSERT INTO report_views_columns VALUES('event_category_name','event_log',  '(select column_string from report_col_string where column_name=''event_log.category'' and column_value=event_log.category)', 'string',   1, 0, 'Event Category Name');
INSERT INTO report_views_columns VALUES('event_error_num',    'event_log',  'event_log.error',    'int',      0, 0, 'Event Error Number');
INSERT INTO report_views_columns VALUES('event_text',         'event_log',  'event_log.ev_text',  'string',   0, 0, 'Event Description');
INSERT INTO report_views_columns VALUES('event_user',         'event_log',  'event_log.userid',   'string',   1, 7, 'Event User Name');
INSERT INTO report_views_columns VALUES('event_ex_text',      'event_log',  'event_log.ex_text',  'string',   0, 0, 'Event Extra Text');

INSERT INTO report_views(view_id, view_name, view_from) 
VALUES (3, 'customers', 'var_data, customer '
   ' left join location cust_loc              ON cust_loc.id = customer.location_id '
   ' left join customer_quota                 ON customer.account_id = customer_quota.account_id '
);

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (4, 'ds_clients', 'var_data, dsbox '
   ' left join customer                       ON dsbox.account_num = customer.account_num '
   ' left join location cust_loc              ON cust_loc.id = customer.location_id '
   ' left join customer_quota                 ON customer.account_id = customer_quota.account_id '
   ' left join dsbox_quota                    ON dsbox.box_id      = dsbox_quota.box_id '
   ' left join dsbox_size                     ON dsbox.box_id      = dsbox_size.box_id '
   ' left join location box_loc               ON dsbox.location_id = box_loc.id '
);

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (5, 'backup_sets',
   'var_data '
   ' join backup_sets             ON backup_sets.active = 1 '
   ' join dsbox                   ON dsbox.box_id = backup_sets.box_id '
   ' join customer                ON dsbox.account_num = customer.account_num '
   ' left join dsset_size         ON (dsset_size.box_id = backup_sets.box_id and dsset_size.req_id = backup_sets.req_id) '
   ' left join dsbox_quota        ON dsbox.box_id = dsbox_quota.box_id '
   ' left join customer_quota     ON customer.account_id = customer_quota.account_id '
);

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (6, 'activity_logs', 'var_data, connection_log '
   ' left join backup_sets ON backup_sets.set_id = connection_log.set_id '
   ' left join dsbox       ON dsbox.dsbox_snum = connection_log.dsbox_snum '
   ' left join customer    ON dsbox.account_num = customer.account_num '
);

INSERT INTO report_views(view_id, view_name, view_from)
VALUES (7, 'event_logs', 'var_data, event_log '
   ' left join connection_log ON event_log.ex_long = connection_log.session_id '
   ' left join backup_sets on backup_sets.set_id = connection_log.set_id '
   ' left join dsbox on dsbox.dsbox_snum = connection_log.dsbox_snum '
   ' left join customer on dsbox.account_num = customer.account_num '
);

INSERT INTO report_views_tables VALUES(3, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(3, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(3, 'cust_loc',       'location');
INSERT INTO report_views_tables VALUES(3, 'customer_quota', 'customer_quota');

INSERT INTO report_views_tables VALUES(4, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(4, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(4, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(4, 'cust_loc',       'location');
INSERT INTO report_views_tables VALUES(4, 'customer_quota', 'customer_quota');
INSERT INTO report_views_tables VALUES(4, 'dsbox_quota',    'dsbox_quota');
INSERT INTO report_views_tables VALUES(4, 'dsbox_size',     'dsbox_size');
INSERT INTO report_views_tables VALUES(4, 'box_loc',        'location');

INSERT INTO report_views_tables VALUES(5, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(5, 'backup_sets',    'backup_sets');
INSERT INTO report_views_tables VALUES(5, 'dsset_size',     'dsset_size');
INSERT INTO report_views_tables VALUES(5, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(5, 'dsbox_quota',    'dsbox_quota');
INSERT INTO report_views_tables VALUES(5, 'customer',       'customer');
INSERT INTO report_views_tables VALUES(5, 'customer_quota', 'customer_quota');

INSERT INTO report_views_tables VALUES(6, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(6, 'connection_log', 'connection_log');
INSERT INTO report_views_tables VALUES(6, 'backup_sets',    'backup_sets');
INSERT INTO report_views_tables VALUES(6, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(6, 'customer',       'customer');

INSERT INTO report_views_tables VALUES(7, 'var_data',       'var_data');
INSERT INTO report_views_tables VALUES(7, 'event_log',      'event_log');
INSERT INTO report_views_tables VALUES(7, 'connection_log', 'connection_log');
INSERT INTO report_views_tables VALUES(7, 'backup_sets',    'backup_sets');
INSERT INTO report_views_tables VALUES(7, 'dsbox',          'dsbox');
INSERT INTO report_views_tables VALUES(7, 'customer',       'customer');

CREATE TABLE retire_storage (
  idx_id    SERIAL PRIMARY KEY,
  loc_id    INT,
  acc_id    INT,
  box_id    INT,
  req_id    INT
);

CREATE INDEX idx_retire_storage_loc ON retire_storage(loc_id);


/* SLA Items */
CREATE TABLE dsbox_sla(
   dsbox_id             int,
   slascale_id          int,
   scale_name           varchar(100),
   unavailable_time     smallint,
   unavailable_price    float,
   disctape_time        smallint,
   disctape_price       float
);
CREATE INDEX idx_dsbox_sla_dsbox_id ON dsbox_sla(dsbox_id);
CREATE INDEX idx_dsbox_sla_slascale_id ON dsbox_sla(slascale_id);

CREATE TABLE lock_schedule (
  lock_sched_id   INT PRIMARY KEY,
  lock_sched_name VARCHAR(1024)
);

INSERT INTO lock_schedule (lock_sched_id, lock_sched_name) VALUES (0, '<DEFAULT>');

CREATE TABLE lock_sched_const (
  lock_sched_const_id INT PRIMARY KEY,
  lock_sched_id       INT CONSTRAINT lock_sched_id_belongs_lock_schedule REFERENCES lock_schedule,
  lock_flag           INT,
  from_time           INT,
  to_time             INT
);

-- Everyday, 0:00AM to 11:59PM
INSERT INTO lock_sched_const (lock_sched_const_id, lock_sched_id, lock_flag, from_time, to_time)
       VALUES (1, 0, 127, 0, 1439);

-- Weekday, 8:00AM to 6:00PM
INSERT INTO lock_sched_const (lock_sched_const_id, lock_sched_id, lock_flag, from_time, to_time)
       VALUES (2, 0, 31, 480, 1080);

CREATE TABLE lock_sched_detail (
  lock_sched_const_id INT CONSTRAINT lock_sched_const_id_belongs_lock_sched_const REFERENCES lock_sched_const,
  lock_type           INT,
  lock_priority       INT
);

-- default priority
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 1, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 2, 12);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 3, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 4, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 5, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 6, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 7, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 8, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 9, 2);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 10, 10);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 11, 11);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 12, 1);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 13, 6);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 14, 6);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 15, 1);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 16, 4);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 17, 5);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 18, 14);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 19, 7);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 21, 3);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 22, 1);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 23, 1);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 25, 13);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 26, 15);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 28, 9);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 30, 16);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 31, 17);
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (1, 33, 3);

-- give CDP backup priority during the business hours
INSERT INTO lock_sched_detail (lock_sched_const_id, lock_type, lock_priority) VALUES (2, 2, 2);

CREATE TABLE scheduled_validation (
  idx_id     SERIAL PRIMARY KEY,
  detail_id  INT NOT NULL,
  box_id     INT,
  req_id     INT
);

CREATE TABlE monitoring_settings (
  noc_id         serial primary key,
  noc_addr       varchar(100),
  noc_guid       varchar(100),
  noc_sys_id     int NOT NULL,
  noc_sys_name   varchar(100),
  connect_freq   int NOT NULL,
  retry_times    int NOT NULL,
  retry_interval int NOT NULL,
  last_sync      int
);

CREATE TABlE monitoring_clients (
  idx_id      serial primary key,
  noc_id      int not null,
  acc_id      int null,
  box_id      int null,
  monitored   int,
  foreign key  (noc_id) references monitoring_settings(noc_id) on delete cascade
);

CREATE TABlE storage_filer (
  filer_id       SERIAL PRIMARY KEY,
  filer_type     INT,
  filer_addr     VARCHAR(1024),
  filer_param1   VARCHAR(1024),
  filer_param2   VARCHAR(1024),
  filer_param3   VARCHAR(1024),
  filer_flag     INT,
  filer_port     INT
);

CREATE TABlE storage_volume (
  vol_id         SERIAL PRIMARY KEY,
  filer_id       INT,
  vol_name       VARCHAR(1024),
  vol_path       VARCHAR(1024),
  snap_path      VARCHAR(1024),
  FOREIGN KEY (filer_id) REFERENCES storage_filer(filer_id) ON DELETE CASCADE
);

/* Lock customers/clients for deletion (i.e. backup data is
 * in append-only, like for legal locking)
 */
CREATE TABLE delete_lock (
  account_id   INT NOT NULL,           -- locked account
  box_id       INT NULL,               -- locked ds-client (or NULL if all)
  opertime     INT NOT NULL,           -- time locking applied
  userid       VARCHAR(256) NOT NULL,  -- who locked/unlocked
  description  VARCHAR(1024) NOT NULL, -- reason for the action
  state        INT NOT NULL,           -- 0/1 - locked/unlocked (active), 2/3 (locked/unlocked) - inactive

  FOREIGN KEY (account_id) REFERENCES customer ON DELETE CASCADE
);

CREATE UNIQUE INDEX idx_del_lock_acc_box_id ON delete_lock(account_id, box_id, opertime);
CREATE INDEX idx_del_lock_acc_opertime ON delete_lock(account_id, opertime);

CREATE TABLE deltachain_config (
    deltachain_cfg_id     INT PRIMARY KEY,
    cfg_name              VARCHAR(1024)
);

CREATE TABLE deltachain_detail (
    deltachain_detail_id  SERIAL PRIMARY KEY,
    deltachain_cfg_id     INT,
    backup_type           INT,
    chain_length          INT
);

CREATE TABLE deltachain_change_log (
    account_id            INT,
    box_id                INT,
    set_id                INT,
    appl_id               INT,
    dir_id                INT
);
CREATE INDEX idx_deltachain_change_log ON deltachain_change_log(account_id, box_id, set_id);

CREATE TABLE ds_data(
       company_name         varchar(50) PRIMARY KEY,
       addr1                varchar(30) NOT NULL,
       addr2                varchar(30) NULL,
       city                 varchar(30) NOT NULL,
       prov_state           varchar(5) NOT NULL,
       postal_zip           varchar(10) NULL,
       country              varchar(3) NOT NULL,
       phone                varchar(20) NULL,
       fax                  varchar(20) NULL,
       contact              varchar(30) NULL,
       last_user            varchar(20) NULL,
       db_number            int NOT NULL,
       ds_version           varchar(20),
       email_addr           varchar(50) NULL,
       lang                 varchar(10),
       billing_option       int NULL,
       dslic_server         VARCHAR(1024),
       dslic_port           int,
       dslic2_server        VARCHAR(1024),
       dslic2_port          int,
       cookie               VARCHAR(1024),
       cookie2              varchar(1024),
       dslic_check_interval  INT,
       dslic_switch_interval INT
);

-- create hotfix_dir table
CREATE TABLE hotfix_dir(
   cust_id           int,
   box_id            int,
   hotfix_dir        VARCHAR(1024)
);

CREATE INDEX idx_hotfix_dir ON hotfix_dir(cust_id, box_id);

CREATE TABLE vdr_vbs (
    vbs_id            SERIAL PRIMARY KEY,
    acc_id            INT NOT NULL,
    box_id            INT NOT NULL,
    req_id            INT NOT NULL,
    set_id            INT NOT NULL,
    flags             INT,
    poweronprio_delay INT,
    FOREIGN KEY (set_id) REFERENCES backup_sets(set_id) ON DELETE CASCADE
);

CREATE TABLE vdr_machines (
    vm_id             SERIAL PRIMARY KEY,
    vbs_id            INT NOT NULL,
    vdr_id            INT NOT NULL,
    esx_id            INT NOT NULL,
    appl_id           INT NOT NULL,
    dir_id            INT NOT NULL,
    cluster_id        INT,
    config_id         INT,
    datacenter        VARCHAR(765) NOT NULL,
    host              VARCHAR(765) NOT NULL,
    folder            VARCHAR(765) NOT NULL,
    name              VARCHAR(255) NOT NULL,
    flags             INT,
    last_gen          INT,
    poweron_priority  INT,
    FOREIGN KEY (vbs_id) REFERENCES vdr_vbs(vbs_id) ON DELETE CASCADE
);

CREATE TABLE vdr_disks (
    disk_id           SERIAL PRIMARY KEY,
    vm_id             INT NOT NULL,
    file_id           INT NOT NULL,
    datastore         VARCHAR(765) NOT NULL,
    name              VARCHAR(765) NOT NULL,
    disk_key          INT,
    change_id         VARCHAR(128),
    last_gen          INT,
    FOREIGN KEY (vm_id) REFERENCES vdr_machines(vm_id) ON DELETE CASCADE
);

CREATE TABLE vdr_servers (
    server_id         SERIAL PRIMARY KEY,
    name              VARCHAR(765) NOT NULL,
    description       VARCHAR(765) NOT NULL,
    addr              VARCHAR(765) NOT NULL,
    port              INT          NOT NULL,
    vdr_type          INT          NOT NULL
);
CREATE UNIQUE INDEX uname ON vdr_servers ( name );
CREATE UNIQUE INDEX udest ON vdr_servers ( addr,port );

CREATE TABLE vdr_esx (
    esx_id            SERIAL PRIMARY KEY,
    addr              VARCHAR(765) NOT NULL,
    username          VARCHAR(765) NOT NULL,
    psw               VARCHAR(765) NOT NULL,
    type              INT
);

CREATE TABLE restore_log(
   rst_id      SERIAL PRIMARY KEY,
   rst_type    int,
   rst_size    float,
   rst_time    int,
   box_id      int,
   req_id      int,
   session_id  int,
   flags       int,
   reason      int,
   term_end    int
);	   
CREATE INDEX rstlog_box_req_type_time ON restore_log(box_id, req_id, rst_type, rst_time, rst_id);
CREATE INDEX rstlog_req_type_time     ON restore_log(box_id, rst_type, rst_time, rst_id);
CREATE INDEX rstlog_type_time         ON restore_log(rst_type, rst_time, rst_id);
CREATE INDEX rstlog_time              ON restore_log(rst_time, rst_id);
CREATE INDEX rstlog_sessionid         ON restore_log(session_id);   

CREATE TABLE restore_reason (
    box_id             INT,
    req_id             INT,
    act_id             INT,
    type               INT,
    req_name           TEXT,
    share              TEXT,
    tenant_id          INT,
    tenant_name        TEXT,
    restore_type       INT,
    license_type       INT,
    reason             INT,
    pnum_tot           INT,
    pnum_res           INT,
    psize_tot          float,
    psize_res          float,
    ssize_res          float,
    nsize_tot          float,
    nsize_res          float,
    tstart             INT,
    tfinish            INT,
    status             INT,
    errors             INT,
    warnings           INT,
    flags              INT
);
CREATE INDEX restorereason_tenant_name ON restore_reason(tenant_name);   

CREATE TABLE drill_log(
   id           SERIAL PRIMARY KEY,
   drill_id     INT NOT NULL UNIQUE,
   box_id       INT NOT NULL,
   req_id       INT NOT NULL,
   request_date INT,
   commit_date  INT, 
   start_date   INT,
   end_date     INT,
   capacity_allocated float,
   capacity_used float,
   flags INT
);	   
CREATE INDEX drilllog_id                  ON drill_log(drill_id);
CREATE INDEX drilllog_start_time          ON drill_log(start_date, drill_id);
CREATE INDEX drilllog_box_req_start_time  ON drill_log(box_id, req_id, start_date, drill_id);

CREATE TABLE critical_status_admin_processes(
   activity_type   INT,
   activity_status INT
);
INSERT INTO critical_status_admin_processes VALUES(108,1);
INSERT INTO critical_status_admin_processes VALUES(130,1);
INSERT INTO critical_status_admin_processes VALUES(144,1);
INSERT INTO critical_status_admin_processes VALUES(153,1);
INSERT INTO critical_status_admin_processes VALUES(154,1);

CREATE TABLE critical_status_monitored_event(
   id             SERIAL PRIMARY KEY,
   event_no       INT,
   event_category INT,
   event_type     INT,
   event_text     VARCHAR(1024)
);

INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692754,1,2,'Invalid data header.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1073741648,1,2,'File deleted. Generation (delta file) linked with the invalid file.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692825,1,2,'Invalid file/directory encountered, name = {0}. It was moved to the trash directory.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692600,1,2,'Invalid file/directory encountered, name = {0}. It was deleted.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692724,1,2,'The bad file was deleted.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693159,1,2,'Unexpected file encountered.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693160,1,2,'Unexpected directory encountered.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693189,1,2,'Invalid directory location.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693186,1,2,'Link to invalid library file was deleted.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693179,1,2,'Invalid file header: does not start with ''''DS''''');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693178,1,2,'Invalid file header: invalid version.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693177,1,2,'Invalid file header: empty file name.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693176,1,2,'Invalid file header: compression ID too large.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693175,1,2,'Invalid file header: invalid encryption type.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693173,1,2,'Invalid library link: not a positive number.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693172,1,2,'Invalid library link: multiple library locations specified.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693171,1,2,'Invalid file header: delta file and library file at the same time.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693170,1,2,'Failed to read delta block size: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693169,1,2,'Failed to read delta header: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693168,1,2,'Delta checksum verification failed.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693148,1,2,'Failed to create directory.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693131,1,2,'Failed to close file.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693122,1,2,'Unexpected EOF while reading file data (insufficient data read).');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693200,1,2,'Failed to read file header: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693199,1,2,'Failed to read file name: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693198,1,2,'Failed to read E-Mail information: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693197,1,2,'Failed to read System i information: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693183,1,2,'File renaming failed.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693084,1,2,'File is corrupted: invalid ACL length of {0} bytes.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693083,1,2,'Failed to read file ACL: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693082,1,2,'Invalid delta reconstruction index ({0}).');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693081,1,2,'DS-Delta reconstruction: invalid internal state.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693080,1,2,'Invalid requested block index ({0}).');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693079,1,2,'Invalid new delta block index ({0}).');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693078,1,2,'Failed to read directory descriptor header: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693077,1,2,'Invalid directory descriptor header (not starting with ''''DS'''' or invalid version).');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693076,1,2,'Directory header seems corrupted: invalid size - {0} bytes of data.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693075,1,2,'Failed to read directory descriptor data: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693003,1,2,'Failed to open link file: unknown reason.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693002,1,2,'Failed to read from link file: unknown reason.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693001,1,2,'Failed to read link file header: insufficient data read.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072693000,1,2,'Invalid link header: does not start with ''''LINK''''.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692999,1,2,'Short read while reading link data.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692998,1,2,'Invalid link file version.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692997,1,2,'Failed to write the link file: unknown reason.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692992,1,2,'Failed to read from the file: unknown reason.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692991,1,2,'Failed to write to the file: unknown reason.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692746,1,2,'Too few bytes read (truncated/corrupted file).');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1072692722,1,2,'Invalid stream checksum. Data stream is corrupted.');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1073741679,1,2,'Failed to read data block (read error)');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1073741680,1,2,'Failed to read data block (no more)');
INSERT INTO critical_status_monitored_event(event_no,event_category,event_type,event_text) VALUES(-1073741676,1,2,'Invalid delta header information');

CREATE TABLE client_geo_location(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  box_id                  int NOT NULL,
  trace_device            int,
  geo_interval            int,
  geo_time                int, -- was datetime
  geo_type                int,
  geo_latitude            float,
  geo_longitude           float,
  geo_country             varchar(100),
  geo_region              varchar(100),
  geo_city                varchar(100),
  geo_zipcode             varchar(100),
  geo_accuracy            int,
  geo_computer_name       varchar(100),
  geo_ip_address          varchar(100),
  status_date             int, -- was datetime
  FOREIGN KEY  (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY  (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_geo_location_noc ON client_geo_location(noc_id,box_id);
CREATE INDEX idx_client_geo_location_box ON client_geo_location(box_id);

CREATE TABLE client_trace_config(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  account_id              int NULL,
  trace_device            int DEFAULT 0,
  geo_interval            int DEFAULT 30,
  FOREIGN KEY (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY (account_id) REFERENCES customer(account_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_trace_config_acc ON client_trace_config(account_id);
CREATE INDEX idx_client_trace_config_noc ON client_trace_config(noc_id,account_id);


CREATE TABLE client_lock_config(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  box_id                  int NOT NULL,
  lock_device             int,
  lock_password           varchar(100),
  status                  int,
  status_date             int, -- was datetime
  FOREIGN KEY (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_lock_config_box ON client_lock_config(box_id);
CREATE INDEX idx_client_lock_config_noc ON client_lock_config(noc_id,box_id);


CREATE TABLE client_remote_wipe(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  box_id                  int NOT NULL,
  remote_wipe             int,
  req_time                int, -- was datetime
  command                 int,
  req_id                  int,
  path                    varchar(256),
  status                  int,
  status_date             int, -- was datetime
  user_name               varchar(256),
  password                varchar(256),
  user_from               varchar(256),
  errors                  int,
  wipe_end_time           int, -- was datetime
  FOREIGN KEY (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY  (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_remote_wipe_box ON client_remote_wipe(box_id);
CREATE INDEX idx_client_remote_wipe_noc ON client_remote_wipe(noc_id,box_id);

CREATE TABLE client_wipe_config(
  id                      SERIAL PRIMARY KEY,
  noc_id                  int NOT NULL,
  account_id              int NULL,
  remote_wipe             int DEFAULT 0,
  FOREIGN KEY (noc_id) REFERENCES monitoring_settings(noc_id) on DELETE CASCADE,
  FOREIGN KEY (account_id) REFERENCES customer(account_id) ON DELETE CASCADE ON UPDATE CASCADE
);
CREATE INDEX idx_client_wipe_config_acc ON client_wipe_config(account_id);
CREATE INDEX idx_client_wipe_config_noc ON client_wipe_config(noc_id,account_id);

CREATE TABLE vmr_group(
   vmrg_id      SERIAL PRIMARY KEY,
   source       VARCHAR(1024) NOT NULL,
   dest         VARCHAR(1024) NOT NULL,
   source_port  VARCHAR(1024) default 8090 NOT NULL
);	   

CREATE TABLE native_archive_config(
    idx_id        SERIAL PRIMARY KEY,
    archive_addr  TEXT,
    archive_port  int,
    archive_key   TEXT,
    thread_dir    int,
    thread_single int,
    thread_multi  int,
    archive_flags int
);

INSERT INTO native_archive_config(archive_port, thread_dir, thread_single, thread_multi, archive_flags)
VALUES (4419, 2, 2, 2, 0);

CREATE TABLE telemetry_server_settings (
  server_id       serial PRIMARY KEY,
  noc_guid        varchar(100),
  server_addr     varchar(100),
  last_connection int
);

CREATE TABLE telemetry_keys (
  key_id         bigserial PRIMARY KEY,
  server_id      int,
  box_id         int,
  api_key        varchar(100),
  private_key    varchar(100),
  FOREIGN KEY  (server_id) REFERENCES telemetry_server_settings(server_id) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY  (box_id) REFERENCES dsbox(box_id) ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE upgrade_config (
    upgrade_start    INT,
    upgrade_end      INT,
    upgrade_flag     INT,
    default_priority INT,
    priority_period  INT,
    current_priority INT,
    current_start    INT
);
INSERT INTO upgrade_config(upgrade_flag, default_priority, priority_period) VALUES (0, 1, 3);

CREATE TABLE ldap_dssys (
    ldap_id     SERIAL PRIMARY KEY,
    ldap_guid   varchar(1024),
    address     varchar(1024),
    description varchar(1024),
    domain      varchar(1024),
    username    varchar(1024),
    password    varchar(1024),
    flag        int,
    last_update int
);

CREATE TABLE ldap_customer (
    account_id     int NOT NULL,
    ldap_id        int NULL,
    domain         varchar(1024),
    flag           int,
    last_update    int,
    foreign key    (account_id) references customer(account_id) on delete cascade,
    foreign key    (ldap_id)    references ldap_dssys(ldap_id) on delete set null
);

CREATE TABLE ldap_dsbox (
    box_id         int NOT NULL,
    domain         varchar(1024),
    username       varchar(1024),
    flag           int,
    last_update    int,
    foreign key    (box_id)  references dsbox(box_id) on delete cascade
);

CREATE TABLE file_delete_logs (
    idx_id         SERIAL PRIMARY KEY,
    delete_time    INT,
    delete_type    INT,
    bset_type      INT,
    dsbox_snum     varchar(24),
    bset_name      varchar(1024),
    dir_name       varchar(1024),
    file_name      varchar(1024),
    user_name      varchar(256),
    backup_time    INT,
    modify_time    INT,
    file_size      BIGINT
);
CREATE INDEX idx_file_delete_logs_del_time ON file_delete_logs(delete_time);
CREATE INDEX idx_file_delete_logs_client ON file_delete_logs(dsbox_snum);
CREATE INDEX idx_file_delete_logs_extra_idx ON file_delete_logs(dsbox_snum, bset_name, bset_type, delete_type, user_name);

-- billing_option is 1 if ds-system has NO billing data to import to ds-billing.
INSERT INTO ds_data VALUES ('ASIGRA Inc.','1120 Finch Ave. W., Suite 400','',
  'Toronto','ON','M3J 3H7', 'CAN','4167368111','4167367120','David Farajun',
  '', 234, '', 'info@asigra.com', 'en', 1, '', 4417, '', 4417, '', '', 30, 60);

-- please keep ds_data as the last line. We change it on every patch and we want to make it easy to find
