/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.charts.type.EdgeEnum;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.components.charts.ChartCustomizer;
import net.sf.jasperreports.components.charts.ChartSettings;
import net.sf.jasperreports.components.spiderchart.FillSpiderDataset;
import net.sf.jasperreports.components.spiderchart.SpiderChartComponent;
import net.sf.jasperreports.components.spiderchart.SpiderChartSharedBean;
import net.sf.jasperreports.components.spiderchart.SpiderPlot;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class SpiderChartRendererEvaluator {
    public static final String FILL_DATASET = "fillDataset";
    public static final String SAMPLE_DATASET = "sampleDataset";
    public static final Double SAMPLE_MAXVALUE = 10.0;
    private static DefaultCategoryDataset sampleDataset;

    public static JRRenderable evaluateRenderer(JRComponentElement element, SpiderChartSharedBean spiderchartBean, ChartCustomizer chartCustomizer, String defaultRenderType, String datasetType) {
        return SpiderChartRendererEvaluator.evaluateRenderable(DefaultJasperReportsContext.getInstance(), element, spiderchartBean, chartCustomizer, defaultRenderType, datasetType);
    }

    public static Renderable evaluateRenderable(JasperReportsContext jasperReportsContext, JRComponentElement element, SpiderChartSharedBean spiderchartBean, ChartCustomizer chartCustomizer, String defaultRenderType, String datasetType) {
        LegendTitle legend;
        String subtitleText;
        Color backcolor;
        SpiderChartComponent chartComponent = (SpiderChartComponent)element.getComponent();
        ChartSettings chartSettings = chartComponent.getChartSettings();
        SpiderPlot plot = (SpiderPlot)chartComponent.getPlot();
        DefaultCategoryDataset dataset = null;
        StandardCategoryItemLabelGenerator labelGenerator = null;
        if (FILL_DATASET.equals(datasetType)) {
            dataset = ((FillSpiderDataset)spiderchartBean.getDataset()).getCustomDataset();
            labelGenerator = ((FillSpiderDataset)spiderchartBean.getDataset()).getLabelGenerator();
        } else {
            dataset = SpiderChartRendererEvaluator.getSampleDataset();
            labelGenerator = new StandardCategoryItemLabelGenerator();
        }
        SpiderWebPlot spiderWebPlot = new SpiderWebPlot((CategoryDataset)dataset);
        if (plot.getAxisLineColor() != null) {
            spiderWebPlot.setAxisLinePaint((Paint)plot.getAxisLineColor());
        }
        if (plot.getAxisLineWidth() != null) {
            spiderWebPlot.setAxisLineStroke((Stroke)new BasicStroke(plot.getAxisLineWidth().floatValue()));
        }
        if (plot.getBackcolor() != null) {
            spiderWebPlot.setBackgroundPaint((Paint)plot.getBackcolor());
        }
        if (plot.getBackgroundAlpha() != null) {
            spiderWebPlot.setBackgroundAlpha(plot.getBackgroundAlpha().floatValue());
        }
        if (plot.getForegroundAlpha() != null) {
            spiderWebPlot.setForegroundAlpha(plot.getForegroundAlpha().floatValue());
        }
        if (plot.getHeadPercent() != null) {
            spiderWebPlot.setHeadPercent(plot.getHeadPercent().doubleValue());
        }
        if (plot.getInteriorGap() != null) {
            spiderWebPlot.setInteriorGap(plot.getInteriorGap().doubleValue());
        }
        if (plot.getLabelColor() != null) {
            spiderWebPlot.setLabelPaint((Paint)plot.getLabelColor());
        }
        if (plot.getLabelFont() != null) {
            spiderWebPlot.setLabelFont(JRFontUtil.getAwtFont(plot.getLabelFont(), Locale.getDefault()));
        }
        if (plot.getLabelGap() != null) {
            spiderWebPlot.setAxisLabelGap(plot.getLabelGap().doubleValue());
        }
        if (spiderchartBean.getMaxValue() != null) {
            spiderWebPlot.setMaxValue(spiderchartBean.getMaxValue().doubleValue());
        }
        if (plot.getRotation() != null) {
            spiderWebPlot.setDirection(plot.getRotation().getRotation());
        }
        if (plot.getStartAngle() != null) {
            spiderWebPlot.setStartAngle(plot.getStartAngle().doubleValue());
        }
        if (plot.getTableOrder() != null) {
            spiderWebPlot.setDataExtractOrder(plot.getTableOrder().getOrder());
        }
        if (plot.getWebFilled() != null) {
            spiderWebPlot.setWebFilled(plot.getWebFilled().booleanValue());
        }
        spiderWebPlot.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        spiderWebPlot.setLabelGenerator((CategoryItemLabelGenerator)labelGenerator);
        Font titleFont = chartSettings.getTitleFont() != null ? JRFontUtil.getAwtFont(chartSettings.getTitleFont(), Locale.getDefault()) : TextTitle.DEFAULT_FONT;
        String titleText = spiderchartBean.getTitleText();
        JFreeChart jfreechart = new JFreeChart(titleText, titleFont, (Plot)spiderWebPlot, true);
        Color color = backcolor = chartSettings.getBackcolor() != null ? chartSettings.getBackcolor() : element.getBackcolor();
        if (backcolor != null) {
            jfreechart.setBackgroundPaint((Paint)backcolor);
        }
        RectangleEdge titleEdge = SpiderChartRendererEvaluator.getEdge(chartSettings.getTitlePosition(), RectangleEdge.TOP);
        if (titleText != null) {
            TextTitle title = jfreechart.getTitle();
            title.setText(titleText);
            if (chartSettings.getTitleColor() != null) {
                title.setPaint((Paint)chartSettings.getTitleColor());
            }
            title.setFont(titleFont);
            title.setPosition(titleEdge);
            jfreechart.setTitle(title);
        }
        if ((subtitleText = spiderchartBean.getSubtitleText()) != null) {
            TextTitle subtitle = new TextTitle(subtitleText);
            subtitle.setText(subtitleText);
            if (chartSettings.getSubtitleColor() != null) {
                subtitle.setPaint((Paint)chartSettings.getSubtitleColor());
            }
            if (chartSettings.getSubtitleColor() != null) {
                Font subtitleFont = chartSettings.getSubtitleFont() != null ? JRFontUtil.getAwtFont(chartSettings.getSubtitleFont(), Locale.getDefault()) : TextTitle.DEFAULT_FONT;
                subtitle.setFont(subtitleFont);
            }
            subtitle.setPosition(titleEdge);
            jfreechart.addSubtitle((Title)subtitle);
        }
        if ((legend = jfreechart.getLegend()) != null) {
            legend.setVisible(chartSettings.getShowLegend() == null || chartSettings.getShowLegend() != false);
            if (legend.isVisible()) {
                if (chartSettings.getLegendColor() != null) {
                    legend.setItemPaint((Paint)chartSettings.getLegendColor());
                }
                if (chartSettings.getLegendBackgroundColor() != null) {
                    legend.setBackgroundPaint((Paint)chartSettings.getLegendBackgroundColor());
                }
                if (chartSettings.getLegendFont() != null) {
                    legend.setItemFont(JRFontUtil.getAwtFont(chartSettings.getLegendFont(), Locale.getDefault()));
                }
                legend.setPosition(SpiderChartRendererEvaluator.getEdge(chartSettings.getLegendPosition(), RectangleEdge.BOTTOM));
            }
        }
        String renderType = chartSettings.getRenderType() == null ? defaultRenderType : chartSettings.getRenderType();
        Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, element.getWidth(), element.getHeight());
        if (chartCustomizer != null) {
            chartCustomizer.customize(jfreechart, chartComponent);
        }
        return ChartUtil.getInstance(jasperReportsContext).getChartRenderableFactory(renderType).getRenderable(jasperReportsContext, jfreechart, spiderchartBean.getHyperlinkProvider(), rectangle);
    }

    public static DefaultCategoryDataset getSampleDataset() {
        if (sampleDataset == null) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            dataset.addValue(1.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 1"));
            dataset.addValue(5.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 2"));
            dataset.addValue(4.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 3"));
            dataset.addValue(3.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 4"));
            dataset.addValue(6.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 5"));
            dataset.addValue(4.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 6"));
            dataset.addValue(3.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Category 7"));
            dataset.addValue(5.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 1"));
            dataset.addValue(7.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 2"));
            dataset.addValue(8.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 3"));
            dataset.addValue(6.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 4"));
            dataset.addValue(9.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 5"));
            dataset.addValue(8.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 6"));
            dataset.addValue(7.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Category 7"));
            dataset.addValue(5.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 1"));
            dataset.addValue(4.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 2"));
            dataset.addValue(6.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 3"));
            dataset.addValue(3.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 4"));
            dataset.addValue(2.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 5"));
            dataset.addValue(7.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 6"));
            dataset.addValue(5.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Category 7"));
            sampleDataset = dataset;
        }
        return sampleDataset;
    }

    public Locale getLocale() {
        return null;
    }

    public TimeZone getTimeZone() {
        return null;
    }

    private static RectangleEdge getEdge(EdgeEnum position, RectangleEdge defaultPosition) {
        RectangleEdge edge = defaultPosition;
        if (position != null) {
            switch (position) {
                case TOP: {
                    edge = RectangleEdge.TOP;
                    break;
                }
                case BOTTOM: {
                    edge = RectangleEdge.BOTTOM;
                    break;
                }
                case LEFT: {
                    edge = RectangleEdge.LEFT;
                    break;
                }
                case RIGHT: {
                    edge = RectangleEdge.RIGHT;
                }
            }
        }
        return edge;
    }
}

