/*
 * Decompiled with CFR 0.152.
 */
package ds.ui.themes;

import ds.errmsg.d;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class PropertiesMetalTheme
extends DefaultMetalTheme {
    private String name = "Custom Theme";
    private ColorUIResource primary1;
    private ColorUIResource primary2;
    private ColorUIResource primary3;
    private ColorUIResource secondary1;
    private ColorUIResource secondary2;
    private ColorUIResource secondary3;
    private ColorUIResource black;
    private ColorUIResource white;

    public PropertiesMetalTheme(InputStream inputStream) {
        this.initColors();
        this.loadProperties(inputStream);
    }

    private void initColors() {
        this.primary1 = super.getPrimary1();
        this.primary2 = super.getPrimary2();
        this.primary3 = super.getPrimary3();
        this.secondary1 = super.getSecondary1();
        this.secondary2 = super.getSecondary2();
        this.secondary3 = super.getSecondary3();
        this.black = super.getBlack();
        this.white = super.getWhite();
    }

    private void loadProperties(InputStream object) {
        Properties properties = new Properties();
        try {
            properties.load((InputStream)object);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        object = properties.get("name");
        if (object != null) {
            this.name = object.toString();
        }
        if ((object = properties.get("primary1")) != null) {
            this.primary1 = this.parseColor(object.toString());
        }
        if ((object = properties.get("primary2")) != null) {
            this.primary2 = this.parseColor(object.toString());
        }
        if ((object = properties.get("primary3")) != null) {
            this.primary3 = this.parseColor(object.toString());
        }
        if ((object = properties.get("secondary1")) != null) {
            this.secondary1 = this.parseColor(object.toString());
        }
        if ((object = properties.get("secondary2")) != null) {
            this.secondary2 = this.parseColor(object.toString());
        }
        if ((object = properties.get("secondary3")) != null) {
            this.secondary3 = this.parseColor(object.toString());
        }
        if ((object = properties.get("black")) != null) {
            this.black = this.parseColor(object.toString());
        }
        if ((object = properties.get("white")) != null) {
            this.white = this.parseColor(object.toString());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    @Override
    protected ColorUIResource getBlack() {
        return this.black;
    }

    @Override
    protected ColorUIResource getWhite() {
        return this.white;
    }

    private ColorUIResource parseColor(String string) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            n4 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            d.a(exception);
            d.a(new Exception("Couldn't parse color :" + string));
        }
        return new ColorUIResource(n2, n3, n4);
    }
}

