/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barbecue;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.components.barbecue.BarbecueComponent;
import net.sf.jasperreports.components.barbecue.BarbecueRenderer;
import net.sf.jasperreports.components.barbecue.BarbecueStyleResolver;
import net.sf.jasperreports.components.barbecue.BarcodeInfo;
import net.sf.jasperreports.components.barbecue.BarcodeProviders;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sourceforge.barbecue.Barcode;

public class BarbecueFillComponent
extends BaseFillComponent {
    private final BarbecueComponent barcodeComponent;
    private final Map<JRStyle, JRTemplateImage> printTemplates = new HashMap<JRStyle, JRTemplateImage>();
    private String code;
    private String applicationIdentifier;

    public BarbecueFillComponent(BarbecueComponent barcode) {
        this.barcodeComponent = barcode;
    }

    protected BarbecueComponent getBarcode() {
        return this.barcodeComponent;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateBarcode(evaluation);
        }
    }

    protected void evaluateBarcode(byte evaluation) throws JRException {
        this.code = JRStringUtil.getString(this.fillContext.evaluate(this.barcodeComponent.getCodeExpression(), evaluation));
        this.applicationIdentifier = JRStringUtil.getString(this.fillContext.evaluate(this.barcodeComponent.getApplicationIdentifierExpression(), evaluation));
    }

    protected boolean isEvaluateNow() {
        return this.barcodeComponent.getEvaluationTimeValue() == EvaluationTimeEnum.NOW;
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        return this.isEvaluateNow() && this.code == null ? FillPrepareResult.NO_PRINT_NO_OVERFLOW : FillPrepareResult.PRINT_NO_STRETCH;
    }

    @Override
    public JRPrintElement fill() {
        JRTemplateImage templateImage = this.getTemplateImage();
        JRTemplatePrintImage image = new JRTemplatePrintImage(templateImage, this.elementId);
        JRComponentElement element = this.fillContext.getComponentElement();
        image.setUUID(element.getUUID());
        image.setX(element.getX());
        image.setY(this.fillContext.getElementPrintY());
        image.setWidth(element.getWidth());
        image.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.setBarcodeImage(image);
        } else {
            this.fillContext.registerDelayedEvaluation(image, this.barcodeComponent.getEvaluationTimeValue(), this.barcodeComponent.getEvaluationGroup());
        }
        return image;
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateBarcode(evaluation);
        this.setBarcodeImage((JRTemplatePrintImage)element);
    }

    protected void setBarcodeImage(JRTemplatePrintImage image) {
        BarcodeInfo barcodeInfo = new BarcodeInfo();
        barcodeInfo.setType(this.barcodeComponent.getType());
        barcodeInfo.setCode(this.code);
        barcodeInfo.setApplicationIdentifier(this.applicationIdentifier);
        barcodeInfo.setDrawText(this.barcodeComponent.isDrawText());
        barcodeInfo.setRequiresChecksum(this.barcodeComponent.isChecksumRequired());
        barcodeInfo.setBarWidth(this.barcodeComponent.getBarWidth());
        barcodeInfo.setBarHeight(this.barcodeComponent.getBarHeight());
        Barcode barcode = BarcodeProviders.createBarcode(barcodeInfo);
        BarbecueRenderer renderer = new BarbecueRenderer(barcode);
        renderer.setRotation(BarbecueStyleResolver.getRotationValue(this.fillContext.getComponentElement()));
        image.setRenderable(renderer);
    }

    protected JRTemplateImage getTemplateImage() {
        JRStyle elementStyle = this.fillContext.getElementStyle();
        JRTemplateImage templateImage = this.printTemplates.get(elementStyle);
        if (templateImage == null) {
            templateImage = new JRTemplateImage(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider());
            templateImage.setStyle(elementStyle);
            templateImage.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
            templateImage = this.deduplicate(templateImage);
            this.printTemplates.put(elementStyle, templateImage);
        }
        return templateImage;
    }
}

